/*
 * lock.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef lock_h
#define lock_h


#include"proc.h"
#include"lib.h"


#ifndef ASM_FILE


/***********************************************************************
 *
 * Spin lock
 *
 ***********************************************************************/

/*
 * Atomic set 1
 * parameters : Gate
 * returns : not set 0,already set 1
 */
/*extern inline int atomic_set(int *gate)
{
	int rest;


	asm volatile(
		"movl	$1,%%eax\n"
		"xchgl	%%eax,(%%edx)"
		:"=a"(rest):"d"(gate)
	);

	return rest;
}
*/

/*
 * ԥå
 * parameters : ԥåѥȡʺǽ0Ƥɬפ
 */
extern inline void enter_spinlock(int volatile *gate)
{
	int rest;


	set_proc_lockflag();
	for(;;)
	{
		while(*gate==1);
		asm volatile(
			"movl	$1,%%eax\n"
			"xchgl	%%eax,(%%edx)"
			:"=a"(rest):"d"(gate)
		);
		if(rest==0)break;
	}
}


/*
 * ԥåФ
 * parameters : ԥåѥ
 */
extern inline void exit_spinlock(int volatile *gate)
{
	*gate=0;
	release_proc_lockflag(get_current_task());
}


/***********************************************************************
 *
 * ɹ߶ͭå
 *
 ***********************************************************************/

typedef struct{
	int gate;		/* ߥåȡ */
	int count;		/* ɹ߶ͭȡ */
}SHARE_LOCK;


/*
 * ¾å
 * parameters : ͭå¤Υɥ쥹staticͤǺǽ0Ƥɬפ롣),Ǿɤ߹楫
 */
/*extern inline void enterWriteLock(SHARE_LOCK volatile *share,int count)
{
	int rest;


	for(;;)
	{
		for(;;)
		{
			while(share->gate==1);
			asm volatile(
				"movl	$1,%%eax\n"
				"xchgl	%%eax,(%%edx)"
				:"=a"(rest):"d"(&share->gate)
			);
			if(rest==0)break;
		}

		if(share->count<=count)break;

		share->gate=0;
	}
}
*/

/*
 * ɹѶͭå
 * parameters : ͭå¤Υɥ쥹staticͤǺǽ0Ƥɬפ롣
 */
/*extern inline void enterReadLock(SHARE_LOCK volatile *share)
{
	int rest;


	for(;;)
	{
		while(share->gate==1);
		asm volatile(
			"movl	$1,%%eax\n"
			"xchgl	%%eax,(%%edx)"
			:"=a"(rest):"d"(&share->gate)
		);
		if(rest==0)break;
	}

	++share->count;
	share->gate=0;
}
*/

/*
 * ¾åФ
 * parameters : ͭå¤Υɥ쥹staticͤǺǽ0Ƥɬפ롣
 */
/*extern inline void exitWriteLock(SHARE_LOCK volatile *share)
{
	share->gate=0;
}
*/

/*
 * ɹѶͭåФ
 * parameters : ͭå¤Υɥ쥹staticͤǺǽ0Ƥɬפ롣
 */
/*extern inline void exitReadLock(SHARE_LOCK volatile *share)
{
	--share->count;
}
*/

/*
 * ߥå
 * ߥե饰¸ƳԲĤꤹ
 * parameters : ߲ĥե饰¸Хåե
 */
/*extern inline void enter_intrlock(int *iflag)
{
	asm volatile(
		"pushfl\n"
		"popl	%%eax\n"
		"cli"
		:"=a"(*iflag):
	);
	*iflag&=0x200;
}*/


/*
 * ߥå
 * ¸Ƥߥե饰
 * parameters : ߲ĥե饰¸Хåե
 */
/*extern inline void exit_intrlock(int *iflag)
{
	asm volatile(
		"pushfl\n"
		"popl	%%edx\n"
		"orl	%%eax,%%edx\n"
		"pushl	%%edx\n"
		"popfl"
		::"a"(*iflag)
	);
}*/


#endif


#endif
