/*
 * fcntl.h
 */


#ifndef fcntl_h
#define fcntl_h


#include<sys/types.h>
#include<share/fcntl.h>


enum{
	/* Values for l_type used for record locking with fcntl() (the following values are unique). */
	F_RDLCK,		/* Shared or read lock. */
	F_UNLCK,		/* Unlock. */
	F_WRLCK,		/* Exclusive or write lock. */

	/* Mask for use with file access modes. */
	O_ACCMODE,	/* Mask for file access modes. */
};


/* The structure flock describes a file lock. It shall include the following members. */
short  l_type;		/* Type of lock; F_RDLCK, F_WRLCK, F_UNLCK. */
short  l_whence;	/* Flag for starting offset. */
off_t  l_start;		/* Relative offset in bytes. */
off_t  l_len;		/* Size; if 0 then until EOF. */
pid_t  l_pid;		/* Process ID of the process holding the lock; returned with F_GETLK. */


/* Function declarations. */
extern int  open(const char *, int, ...);
extern int  creat(const char *, mode_t);
extern int  fcntl(int, int, ...);


#endif
