/*
 * locale.h
 */


#ifndef locale_h
#define locale_h


#include<stddef.h>


/* Describes formatting of monetary and other numeric values. */
struct lconv{
	char* decimal_point;		/* decimal point for non-monetary values. */
	char* grouping;				/* sizes of digit groups for non-monetary values. */
	char* thousands_sep;		/* separator for digit groups for non-monetary values (left of "decimal point"). */
	char* currency_symbol;		/* currency symbol. */
	char* int_curr_symbol;		/* international currency symbol. */
	char* mon_decimal_point;	/* decimal point for monetary values. */
	char* mon_grouping;			/* sizes of digit groups for monetary values. */
	char* mon_thousands_sep;	/* separator for digit groups for monetary values (left of "decimal point"). */
	char* negative_sign;		/* negative sign for monetary values. */
	char* positive_sign;		/* positive sign for monetary values. */
	char frac_digits;			/* number of digits to be displayed to right of "decimal point" for monetary values. */
	char int_frac_digits;		/* number of digits to be displayed to right of "decimal point" for international monetary values. */
	char n_cs_precedes;			/* whether currency symbol precedes (1) or follows (0) negative monetary values. */
	char n_sep_by_space;		/* whether currency symbol is (1) or is not (0) separated by space from negative monetary values. */
	char n_sign_posn;			/*
								 * format for negative monetary values,
								 * 0:parentheses surround quantity and currency symbol
								 * 1:sign precedes quantity and currency symbol
								 * 2:sign follows quantity and currency symbol
								 * 3:sign immediately precedes currency symbol
								 * 4:sign immediately follows currency symbol
								 */
	char p_cs_precedes;			/* whether currency symbol precedes (1) or follows (0) positive monetary values. */
	char p_sep_by_space;		/* whether currency symbol is (1) or is not (0) separated by space from non-negative monetary values. */
	char p_sign_posn;			/* format for non-negative monetary values, with values as for n_sign_posn. */
};


enum{
	LC_ALL=0,		/* ϰ硣 */
	LC_NUMERIC,		/* ϰ辮ʸ硣 */
	LC_MONETARY,	/* ϰ̲߽硣 */
	LC_COLLATE,		/* ϰʸȹ硣 */
	LC_CTYPE,		/* ϰʸ硣 */
	LC_TIME,		/* ϰֽ硣 */
};


extern struct lconv* localeconv(void);
extern char* setlocale(int category, const char* locale);


#endif
