/*
 * fcntl.h
 */


#ifndef share_fcntl_h
#define share_fcntl_h


#ifndef ASM_FILE


enum{
	/* File access modes used for open() and fcntl(). */
	O_RDONLY=1,			/* Open for reading only. */
	O_RDWR=1<<1,		/* Open for reading and writing. */
	O_WRONLY=1<<2,		/* Open for writing only. */

	/* Flags and are used in the oflag value to open(). They shall be bitwise-distinct. */
	O_CREAT=1<<3,		/* Create file if it does not exist. */
	O_EXCL=1<<4,		/* Exclusive use flag. */
	O_NOCTTY=1<<5,		/* Do not assign controlling terminal. */
	O_TRUNC=1<<6,		/* Truncate flag. */

	/* File status flags used for open() and fcntl(). */
	O_APPEND=1<<7,		/* Set append mode. */
	O_NONBLOCK=1<<8, 	/* Non-blocking mode. */

	/* File descriptor flags used for fcntl(). */
	FD_CLOEXEC=1,		/* Close the file descriptor upon execution of an exec family function. */
	
	/* Values for cmd used by fcntl() (the following values are unique). */
	F_DUPFD=0,		/* Duplicate file descriptor. */
	F_GETFD,		/* Get file descriptor flags. */
	F_SETFD,		/* Set file descriptor flags. */
	F_GETFL,		/* Get file status flags and file access modes. */
	F_SETFL,		/* Set file status flags. */
	F_GETLK,		/* Get record locking information. */
	F_SETLK,		/* Set record locking information. */
	F_SETLKW,		/* Set record locking information; wait if blocked. */
	F_GETOWN,		/* Get process or process group ID to receive SIGURG signals. */
	F_SETOWN,		/* Set process or process group ID to receive SIGURG signals. */
};


#endif


#endif
