/*
 * share/termios.h
 */


#ifndef share_termios_h
#define share_termios_h


#ifndef ASM_FILE


enum{
	/* The c_iflag field describes the basic terminal input control. */
	BRKINT=1<<0,	/* Signal interrupt on break. */
	ICRNL=1<<1,		/* Map CR to NL on input. */
	IGNBRK=1<<2,	/* Ignore break condition. */
	IGNCR=1<<3,		/* Ignore CR. */
	IGNPAR=1<<4,	/* Ignore characters with parity errors. */
	INLCR=1<<5,		/* Map NL to CR on input. */
	INPCK=1<<6,		/* Enable input parity check. */
	ISTRIP=1<<7,	/* Strip character. */
	IXOFF=1<<8,		/* Enable start/stop input control. */
	IXON=1<<9,		/* Enable start/stop output control. */
	PARMRK=1<<10,	/* Mark parity errors. */

	/* The c_oflag field specifies the system treatment of output. */
	OPOST=1,		/* Post-process output. */
	/*ONLCR,*/		/* Map NL to CR-NL on output. */
	/*OCRNL,*/		/* Map CR to NL on output. */
	/*ONOCR,*/		/* No CR output at column 0. */
	/*ONLRET,*/		/* NL performs CR function. */
	/*OFILL,*/		/* Use fill characters for delay. */
	/*NLDLY,*/		/* Select newline delays: */
	/*NL0,*/		/* Newline type 0. */
	/*NL1,*/		/* Newline type 1. */
	/*CRDLY,*/		/* Select carriage-return delays: */
	/*CR0,*/		/* Carriage-return delay type 0. */
	/*CR1,*/		/* Carriage-return delay type 1. */
	/*CR2,*/		/* Carriage-return delay type 2. */
	/*CR3,*/		/* Carriage-return delay type 3. */
	/*TABDLY,*/		/* Select horizontal-tab delays: */
	/*TAB0,*/		/* Horizontal-tab delay type 0. */
	/*TAB1,*/		/* Horizontal-tab delay type 1. */
	/*TAB2,*/		/* Horizontal-tab delay type 2. */
	/*TAB3,*/		/* Expand tabs to spaces. */
	/*BSDLY,*/		/* Select backspace delays: */
	/*BS0,*/		/* Backspace-delay type 0. */
	/*BS1,*/		/* Backspace-delay type 1. */
	/*VTDLY,*/		/* Select vertical-tab delays: */
	/*VT0,*/		/* Vertical-tab delay type 0. */
	/*VT1,*/		/* Vertical-tab delay type 1. */
	/*FFDLY,*/		/* Select form-feed delays: */
	/*FF0,*/		/* Form-feed delay type 0. */
	/*FF1,*/		/* Form-feed delay type 1. */

	/* The c_cflag field describes the hardware control of the terminal. */
	CS5=1<<0,		/* 5 bits */
	CS6=1<<1,		/* 6 bits */
	CS7=1<<2,		/* 7 bits */
	CS8=1<<3,		/* 8 bits */
	CSTOPB=1<<4,	/* Send two stop bits, else one. */
	CREAD=1<<5,		/* Enable receiver. */
	PARENB=1<<6,	/* Parity enable. */
	PARODD=1<<7,	/* Odd parity, else even. */
	HUPCL=1<<8,		/* Hang up on last close. */
	CLOCAL=1<<9,	/* Ignore modem status lines. */

	/* The c_lflag field of the argument structure is used to control various terminal functions. */
	ECHO=1<<0,		/* Enable echo. */
	ECHOE=1<<1,		/* Echo erase character as error-correcting backspace. */
	ECHOK=1<<2,		/* Echo KILL. */
	ECHONL=1<<3,	/* Echo NL. */
	ICANON	=1<<4,	/* Canonical input (erase and kill processing). */
	IEXTEN=1<<5,	/* Enable extended input character processing. */
	ISIG=1<<6,		/* Enable signals. */
	NOFLSH=1<<7,	/* Disable flush after interrupt or quit. */
	TOSTOP=1<<8,	/* Send SIGTTOU for background output. */

	/* the array c_cc. */
	NCCS=11,		/* Size of the array c_cc for control characters. */
	VINTR=0,	/* INTR character. */
	VQUIT=1,	/* QUIT character. */
	VSTART=2,	/* START character. */
	VSTOP=3,	/* STOP character. */
	VSUSP=4,	/* SUSP character. */
	VEOF=5,		/* EOF character. */
	VEOL=6,		/* EOL character. */
	VERASE=7,	/* ERASE character. */
	VKILL=8,	/* KILL character. */
	VMIN=9,		/* MIN value. */
	VTIME=10,	/* TIME value. */

	/* The following symbolic constants for use with tcsetattr() are defined. */
	TCSANOW,	/* Change attributes immediately. */
	TCSADRAIN,	/* Change attributes when output has drained. */
	TCSAFLUSH,	/* Change attributes when output has drained; also flush pending input. */

	/* The following symbolic constants for use with tcflush() shall be defined. */
	TCIFLUSH,	/* Flush pending input. */
	TCIOFLUSH,	/* Flush both pending input and untransmitted output. */
	TCOFLUSH,	/* Flush untransmitted output. */

	/* The following symbolic constants for use with tcflow() shall be defined. */
	TCIOFF,		/* Transmit a STOP character, intended to suspend input data. */
	TCION,		/* Transmit a START character, intended to restart input data. */
	TCOOFF,		/* Suspend output. */
	TCOON,		/* Restart output. */

	/* Baud Rate. */
	B0,		/* Hang up */
	B50,	/* 50 baud */
	B75,	/* 75 baud */
	B110,	/* 110 baud */
	B134,	/* 134.5 baud */
	B150,	/* 150 baud */
	B200,	/* 200 baud */
	B300,	/* 300 baud */
	B600,	/* 600 baud */
	B1200,	/* 1200 baud */
	B1800,	/* 1800 baud */
	B2400,	/* 2400 baud */
	B4800,	/* 4800 baud */
	B9600,	/* 9600 baud */
	B19200,	/* 19200 baud */
	B38400,	/* 38400 baud */
};


typedef unsigned char cc_t;		/* Used for terminal special characters. */
typedef unsigned int speed_t;	/* Used for terminal baud rates. */
typedef unsigned int tcflag_t;	/* Used for terminal modes. */

struct termios{
	tcflag_t  c_iflag;		/* Input modes. */
	tcflag_t  c_oflag;		/* Output modes. */
	tcflag_t  c_cflag;		/* Control modes. */
	tcflag_t  c_lflag;		/* Local modes. */
	cc_t      c_cc[NCCS];	/* Control characters. */
};


#endif


#endif
