/*
 * sys/wait.h
 */


#ifndef sys_wait_h
#define sys_wait_h


#include<sys/types.h>
#include<share/wait.h>


/*
 * Macros for analysis of process status values.
 */
/* True if child exited normally. */
extern inline int WIFEXITED(int state)
{
	return (state>>WIFEXITED_SHIFT)&0x1;
}

/* Return exit status. */
extern inline int WEXITSTATUS(int state)
{
	return (state>>WEXITSTATUS_SHIFT)&0xff;
}

/* True if child exited due to uncaught signal. */
extern inline int WIFSIGNALED(int state)
{
	return (state>>WIFSIGNALED_SHIFT)&0x1;
}

/* Return signal number that caused process to terminate. */
extern inline int WTERMSIG(int state)
{
	return (state>>WTERMSIG_SHIFT)&0xff;
}

/* True if child is currently stopped. */
extern inline int WIFSTOPPED(int state)
{
	return (state>>WIFSTOPPED_SHIFT)&0x1;
}

/* Return signal number that caused process to stop. */
extern inline int WSTOPSIG(int state)
{
	return (state>>WSTOPSI_SHIFT)&0xff;
}

pid_t  wait(int *);
pid_t  waitpid(pid_t, int *, int);


#endif
