/*
 * stdlib.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<errno.h>
#include<string.h>
#include<unistd.h>


void exit(int state)
{
	_exit(state);
}


int atoi(const char *str)
{
	int rest=0;


	for(;*str!='\0';++str)
	{
		if((*str<'0')||(*str>'9'))return 0;
		rest=rest*10+*str-'0';
	}

	return rest;
}


extern char **environ;

char *getenv(const char *name)
{
	char **p;
	char *q;
	int i;


	for(p=environ;p!=NULL;++p)
	{
		q=*p;
		for(i=0;q[i]==name[i];++i);
		if((q[i]=='=')&&(name[i]=='\0'))return q;
	}
	return NULL;
}


/*========================================================================================*
 *                              memory allocate                                           *
 *========================================================================================*/

enum{
	MIN_SIZE=8,					/* ǾХȿ */
	FIRST_INDEX=3,				/* Ǿإåǥå */
	HEADER_NUM=31-FIRST_INDEX,	/* إåơ֥ */
	MAGIC_NUMBER=0xffff,		/* إåޥåʥС */
};


typedef union MALLOC_HEAD{
	union MALLOC_HEAD *next;
	struct{
		ushort index;
		ushort magic;
	}head;
}MALLOC_HEAD;


static const char indexNumber[]={
	0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
};


static MALLOC_HEAD *nextHead[HEADER_NUM];


void *malloc(size_t size)
{
	int index;
	MALLOC_HEAD *head;


	if(size==0)return  NULL;
	if(size<MIN_SIZE)size=MIN_SIZE;

	/* ǥå */
	if(size<0x100)
	{
		index=indexNumber[size];
		if(size&((1<<index)-1))++index;
	}
	else if(size<0x10000)
	{
		index=indexNumber[size>>8]+8;
		if(size&((1<<index)-1))++index;
	}
	else if(size<0x1000000)
	{
		index=indexNumber[size>>16]+16;
		if(size&((1<<index)-1))++index;
	}
	else
	{
		index=indexNumber[size>>24]+24;
		if(size&((1<<index)-1))++index;
		if(index==32)return NULL;
	}

	/* ꡼ */
	if(nextHead[index-FIRST_INDEX]!=NULL)
	{
		head=nextHead[index-FIRST_INDEX];
		nextHead[index-FIRST_INDEX]=head->next;
	}
	else
	{
		if((head=(MALLOC_HEAD*)sbrk((1<<index)+sizeof(MALLOC_HEAD)))==NULL)return NULL;
	}
	head->head.magic=MAGIC_NUMBER;
	head->head.index=index-FIRST_INDEX;

	return (void*)(head+1);
}


void free(void *ptr)
{
	int index;
	MALLOC_HEAD *head;


	if(ptr==NULL)return;

	head=(MALLOC_HEAD*)ptr-1;
	if(head->head.magic!=MAGIC_NUMBER)return;		/* ҡפ˲Ƥ롣 */

	index=head->head.index;
	head->next=nextHead[index];
	nextHead[index]=head;
}


void *realloc(void *ptr,size_t size)
{
	void *mem;
	int shift;
	MALLOC_HEAD *head;


	if(ptr==NULL)return malloc(size);
	if(size==0)
	{
		free(ptr);
		return NULL;
	}

	head=(MALLOC_HEAD*)ptr-1;
	if(head->head.magic!=MAGIC_NUMBER)return NULL;	/* ҡפ˲Ƥ롣 */

	shift=head->head.index+FIRST_INDEX;
	if(size>(1<<shift))								/* (1<<shift)=ߤͿ줿 */
	{
		if((mem=malloc(size))==NULL)return NULL;
		memcpy(mem,ptr,1<<shift);
		free(ptr);
		return mem;
	}
	else return ptr;
}


void *calloc(size_t nmemb, size_t size)
{
	void *mem;


	if((mem=malloc(size*nmemb))==NULL)return NULL;
	memset(mem,0,size*nmemb);

	return mem;
}
