/*
 * Copyright (c) 1987, 1989 Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Arthur David Olson of the National Cancer Institute.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * 2004: modified by minoru murashima.
 */


#include<share/user_config.h>
#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<stdio.h>
#include<time.h>


char *asctime(const struct tm *timeptr)
{
	static const char *wday_name[]={
		"Sun","Mon","Tue","Wed","Thu","Fri","Sat"
	};
	static const char *mon_name[]={
		"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"
	};
	static char	result[26];


	sprintf(result,"%.3s %.3s%3d %02d:%02d:%02d %d\n",
		wday_name[timeptr->tm_wday],
		mon_name[timeptr->tm_mon],
		timeptr->tm_mday, timeptr->tm_hour,
		timeptr->tm_min, timeptr->tm_sec,
		1900 + timeptr->tm_year);

	return result;
}


/*
 * time.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


static time_t timezone=LOCAL_TIME;
static struct tm timest;


time_t time(time_t* tp)
{
	int rest;


	if((rest=syscall2(SYS_TIME,(int)tp))<0)
	{
		errno=-rest;
		return -1;
	}
	return rest;
}


struct tm *gmtime(const time_t *timep)
{
	int tmp,years;
	int flg_leap=0;		/* ǯե饰 */


	timest.tm_sec=*timep%60;
	tmp=*timep/60;						/* ʬ */
	timest.tm_min=tmp%60;
	tmp/=60;							/* ֿ */
	timest.tm_hour=tmp%24;
	tmp/=24;							/*  */
	timest.tm_wday=(tmp+4)%7;
	years=tmp/365;						/* 1970ǯǯ */
	timest.tm_yday=tmp%365-(years+1)/4;
	if(timest.tm_yday<=0)
	{
		timest.tm_yday+=365;
		if((--years+1970)%4==0)
		{
			++timest.tm_yday;
			flg_leap=1;
		}
	}
	timest.tm_year=years+70;
	if(timest.tm_yday<=31)												/*  */
	{
		timest.tm_mon=0;
		timest.tm_mday=timest.tm_yday;
	}
	else if(timest.tm_yday<=31+28+flg_leap)								/*  */
	{
		timest.tm_mon=1;
		timest.tm_mday=timest.tm_yday-31;
	}
	else if(timest.tm_yday<=31+28+31+flg_leap)							/*  */
	{
		timest.tm_mon=2;
		timest.tm_mday=timest.tm_yday-(31+28+flg_leap);
	}
	else if(timest.tm_yday<=31+28+31+30+flg_leap)						/*  */
	{
		timest.tm_mon=3;
		timest.tm_mday=timest.tm_yday-(31+28+31+flg_leap);
	}
	else if(timest.tm_yday<=31+28+31+30+31+flg_leap)					/*  */
	{
		timest.tm_mon=4;
		timest.tm_mday=timest.tm_yday-(31+28+31+30+flg_leap);
	}
	else if(timest.tm_yday<=31+28+31+30+31+30+flg_leap)					/*  */
	{
		timest.tm_mon=5;
		timest.tm_mday=timest.tm_yday-(31+28+31+30+31+flg_leap);
	}
	else if(timest.tm_yday<=31+28+31+30+31+30+31+flg_leap)				/*  */
	{
		timest.tm_mon=6;
		timest.tm_mday=timest.tm_yday-(31+28+31+30+31+30+flg_leap);
	}
	else if(timest.tm_yday<=31+28+31+30+31+30+31+31+flg_leap)			/*  */
	{
		timest.tm_mon=7;
		timest.tm_mday=timest.tm_yday-(31+28+31+30+31+30+31+flg_leap);
	}
	else if(timest.tm_yday<=31+28+31+30+31+30+31+31+30+flg_leap)		/*  */
	{
		timest.tm_mon=8;
		timest.tm_mday=timest.tm_yday-(31+28+31+30+31+30+31+31+flg_leap);
	}
	else if(timest.tm_yday<=31+28+31+30+31+30+31+31+30+31+flg_leap)		/* 10 */
	{
		timest.tm_mon=9;
		timest.tm_mday=timest.tm_yday-(31+28+31+30+31+30+31+31+30+flg_leap);
	}
	else if(timest.tm_yday<=31+28+31+30+31+30+31+31+30+31+30+flg_leap)	/* 11 */
	{
		timest.tm_mon=10;
		timest.tm_mday=timest.tm_yday-(31+28+31+30+31+30+31+31+30+31+flg_leap);
	}
	else															/* 12 */
	{
		timest.tm_mon=11;
		timest.tm_mday=timest.tm_yday-(31+28+31+30+31+30+31+31+30+31+30+flg_leap);
	}
	timest.tm_isdst=0;

	return &timest;
}


struct tm *localtime(const time_t *timep)
{
	time_t ltime;


	ltime=*timep+timezone;
	return gmtime(&ltime);
}


char *ctime(const time_t *timep)
{
	localtime(timep);
	return asctime(&timest);
}


time_t mktime(struct tm *tm)
{
	static ushort sumMonthDay[13]={0,31,59,90,120,151,181,212,243,273,304,334};	/* ιס */
	int days;


	days=(tm->tm_year-70)*365;
	days+=(tm->tm_year-1-70)/4;
	days+=sumMonthDay[tm->tm_mon]+tm->tm_mday-1;
	if((tm->tm_year%4==0)&&(tm->tm_mon>2))++days;
	return ((days*24+tm->tm_hour)*60+tm->tm_min)*60+tm->tm_sec-timezone;
}
