/*
 * shell.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * 桼󥿡ե
 */


#include<sys/types.h>
#include<unistd.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<errno.h>
#include<dirent.h>
#include<sys/wait.h>
#include<sys/stat.h>


enum{
	ARG_SIZE=128,			/* Хåե */
	SHELL_ARGS_MAX=10,		/* 뤬κ */
};


/*****************************************************************************************
 *
 * Prompt.
 *
 ******************************************************************************************/

enum{
	CRNT_DIR_BUF_SIZE=128,	/* Size of current directory path buffer. */
};


/* PRIVATE */
static char crntDir[CRNT_DIR_BUF_SIZE];		/* Current directory buffer. */


/*
 * PRIVATE
 * ȥǥ쥯ȥХåեѴ
 */
static inline void crntDirToPrompt()
{
	char *p,*q;


	for(p=q=crntDir+1;*p!='\0';++p)
	{
		if(*p=='/')q=p+1;
	}
	if(p==&crntDir[1])crntDir[0]='/';
	else memcpy(crntDir,q,(uint)p-(uint)q+1);
}


/*
 * PUBLIC
 * Init prompt.
 * return : 0 or error=-1
 */
static int initPrompt()
{
	/* Get current directory. */
	if(getcwd(crntDir,CRNT_DIR_BUF_SIZE)==NULL)
	{
		printf("Failed getcwd\n");
		return -1;
	}

	crntDirToPrompt();

	return 0;
}


/*****************************************************************************************
 *
 * Execute file.
 *
 ******************************************************************************************/

/*
 * PUBLIC
 * Execute file.
 * parameters : arguments
 */
static void execFile(char **arg)
{
	int error;


	error=fork();
    if(error==0)
	{
		if(execve(arg[0],arg,NULL)!=0)
			printf("Failed execute ""%s""! error:%s\n",arg[0],strerror(errno));

		exit(0);
	}
	else if(error<0)
	{
		printf("Failed fork! error:%s\n",strerror(errno));
	}
	else wait(NULL);
}


/*****************************************************************************************
 *
 * Do builtin command.
 *
 ******************************************************************************************/

typedef struct{
	const char *name;
	void (*cmd)(char**);
}COMMAND;


/*
 * PRIVATE
 * ʸκǸ夬'/'ʤ'\0'񤭤롣
 * NOTE!
 *  ǽNULLåʤ
 * parameters : ʸ
 */
static inline char *takeOutSlash(char *str)
{
	char *p;


	p=str;
	while(*++p!='\0');
	if((--p!=str)&&(*p=='/'))*p='\0';

	return str;
}


/*
 * PRIVATE
 * Builtin command.
 */
/* cd */
static void cd(char **arg)
{
	if(chdir(takeOutSlash(arg[0]))==0)initPrompt();
	else printf("Failed cd : %s\n",strerror(errno));
}

/* reboot */
static void _reboot(char **arg)
{
	if(reboot(REBOOT_REBOOT)==-1)printf("Failed halt\n");
}

/* halt */
static void halt(char **arg)
{
	if(reboot(REBOOT_POWEROFF)==-1)printf("Failed halt\n");
}

/* ls */
static void ls(char **arg)
{
	int len;
	DIR *dir;
	struct dirent *dirent;
	struct stat sbuf;


	if(*arg[0]=='\0')strncpy(arg[0],".",2);

	if((dir=opendir(takeOutSlash(arg[0])))==NULL)
	{
		printf("Failed ls : %s\n",strerror(errno));
		return;
	}

	strcat(arg[0],"/");
	len=strlen(arg[0]);
	while((dirent=readdir(dir))!=NULL)
	{
		strcpy(&arg[0][len],dirent->d_name);
		stat(arg[0],&sbuf);
		if(S_ISDIR(sbuf.st_mode))
			printf("%s/\n",dirent->d_name);
		else printf("%s\n",dirent->d_name);
	}

	if(closedir(dir)==-1)
		printf("Failed closedir : %s\n",strerror(errno));
}


/*
 * PRIVATE
 * Cmmand structure
 * ϥޥ̾ν¤٤롣
 */
static COMMAND command[]={
	{"cd",cd},
	{"halt",halt},
	{"ls",ls},
	{"reboot",_reboot},
};


enum{
	CMD_NUM=sizeof(command)/sizeof(COMMAND),		/* Number of builtin commands. */
};


/*
 * PUBLIC
 * Execute command.
 * parameters : arguments
 */
static void execCommand(char *arg[])
{
	int low,high,middle;


	/* ʬ */
	for(low=0,high=CMD_NUM-1;low<=high;)
	{
		middle=(low+high)/2;
		if(strcmp(arg[0],command[middle].name)==1)low=middle+1;
		else high=middle-1;
	}
	if((low>=CMD_NUM)||(strcmp(arg[0],command[low].name)!=0))
		printf("Command ""%s"" not found\n",arg[0]);
	else command[low].cmd(&arg[1]);
}


/*****************************************************************************************
 *
 * Parse command line.
 *
 ******************************************************************************************/

/*
 * PUBLIC
 * Ϥ줿ޥɥ饤ڤäưݥ󥿥Хåեꤹ롣
 * parameters : command line buffer,arguments pointer buffer
 */
static void parseCommandLine(char *line,char *arg[])
{
	char*p,*q;
	int i;


	p=line;
	for(;*p==' ';++p);
	for(i=0;i<SHELL_ARGS_MAX-1;++i)
	{
		if((q=strchr(p,' '))!=NULL)
		{
			*q='\0';
			arg[i]=p;
			while(*++q==' ');
			p=q;
		}
		else
		{
			arg[i]=p;
			arg[i+1]=strchr(p,'\0')+1;
			*arg[i+1]='\0';
			break;
		}
	}
}


/*****************************************************************************************
 *
 * Main.
 *
 ******************************************************************************************/

int main()
{
	char buf[ARG_SIZE];
	char *arg[SHELL_ARGS_MAX];
	int size;


	/* å󳫻ϡ */
	if(setsid()<0)
	{
		printf("Failed setsid()!\n");
		return 0;
	}

	/* ץץȤɽ */
	if(initPrompt()!=0)
	{
		printf("Fialed init prompt!\n");
		return 0;
	}

	for(;;)
	{
		printf("%s>",crntDir);

		/* üϼա */
		if((size=read(STDIN_FILENO,buf,ARG_SIZE-1))!=0)
		{
			buf[size]='\0';			

			/* ȡʬ䡣 */
			parseCommandLine(buf,arg);

			/* Execute command line. */
			if(strchr(arg[0],'/')!=NULL)execFile(arg);
			else execCommand(arg);
		}
	}

	return 0;
}
