<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>

<html:html>
<head>
<title><bean:message key="select.title"/></title>
<link rel="stylesheet" href="<html:rewrite page="/css/style.css"/>" type="text/css"/>
<script src="js/common.js" type="text/javascript"></script>
<html:base/>
<script language="javascript">
	<!-- //
	function execute_action(action) {
		// 1.エラー判定
		if (!checkRadio('scriptId')) {
			alert('分析処理が未選択です。');
		    return false;
		}
		// 2.画面遷移
		document.forms[1].submit(); 
	    return false;
	}

	function delete_list() {
		alert("選択している分析結果を削除します。削除すると分析結果をダウンロードできなくなります。よろしいですか？");
	}
	
	function submitForWelcome() {
		document.forms[2].submit(); 
	    return false;
	}

	function submitForAnalyze() {
		document.forms[1].submit(); 
	    return false;
	}
function logout(){ 
	document.forms[0].submit(); 
} 
	// -->
</script>
</head>

<body class="mainbg">
	<div class="main">
		<div class="head"><img src="../images/mhead.jpg"  alt=""></div>
		<div class="float_left" >
		ログインID：<%=session.getAttribute("userid")%>
		</div>
		<% String uid = (String)session.getAttribute("userid"); %>
		<div class="float_right" >
			<html:form action="/Logout">
				<a href="javascript:logout()"><bean:message key="common.logout.label"/></a>
			</html:form>
		</div>
		<div class="clear" />
		<logic:notPresent name="org.apache.struts.action.MESSAGE" scope="application">
			<font color="red">
            ERROR:  Application resources not loaded -- check servlet container logs for error messages.
			</font>
		</logic:notPresent>

		<div class="explanation_box">
			<p><bean:message key="select.explain"/></p>
		</div>
		<br>

		<%-- エラーメッセージがセットされていれば表示する --%>
		<logic:notEqual name="SelectScriptForm" property="message" value="">
			<div class="error">
				<bean:write name="SelectScriptForm" property="message" />
			</div>
			<br>
		</logic:notEqual>

		<html:form action="/Analyze">
		<html:hidden property="r_id" value="<%=uid%>" />
		<logic:notEmpty name="ScriptList" scope="session">
			<table class="table_frame">
				<tr>
					<th class="header_column1 column_center_40"><bean:message key="label.select"/></th>
					<th class="header_column1 column_center_150"><bean:message key="common.groupName"/></th>
					<th class="header_column1 column_center_widthless"><bean:message key="label.analyzeName"/></th>
				</tr>

				<logic:iterate id="dto" name="ScriptList" offset="0" indexId="index">
				<tr>
					<%-- 選択用ラジオボタン --%>
					<td class="column_center_40">
						<html:radio idName="dto" property="scriptId" value="scriptId" styleId="scriptId"/>
					</td>
					<%-- 分類名称 --%>
					<td class="column_left_150"><bean:write name="dto" property="groupName" /></td>
					<%-- 分析処理名称 --%>
					<td class="column_left_widthless"><bean:write name="dto" property="scriptName" /></td>
				</tr>
				</logic:iterate>
			</table>
		</logic:notEmpty>
		</html:form>

		<%-- 分析パラメータ設定ボタン --%>
		<div class="float_left">
			<html:submit property="action" onclick="execute_action('scriptId')"><bean:message key="label.parameterSetting"/></html:submit>
		</div>

		<%-- 分析処理状況一覧へ戻るボタン --%>
		<div class="float_right">
			<html:form action="/Welcome">
				<html:hidden property="r_id" value="<%=uid%>" />
				<html:submit property="action"><bean:message key="common.return.label"/></html:submit>
			</html:form>
		</div>

		<div class="clear" />
		<hr />
		<%-- 著作権表記 --%>
	</div>
	<span class="copyright"><bean:message key="common.copyright"/></span>
</body>
</html:html>
