/*    */ package jp.ac.musashiasp.action;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.FileNotFoundException;
/*    */ import java.io.IOException;
/*    */ import java.util.List;
/*    */ import javax.servlet.http.HttpServletRequest;
/*    */ import javax.servlet.http.HttpServletResponse;
/*    */ import javax.servlet.http.HttpSession;
/*    */ import jp.ac.musashiasp.dto.ScriptDto;
/*    */ import jp.ac.musashiasp.form.AnalyzeForm;
/*    */ import jp.ac.musashiasp.util.Common;
		 import jp.ac.musashiasp.dto.UserInfo;
/*    */ import jp.ac.musashiasp.util.DataAccess;
/*    */ import jp.ac.musashiasp.util.FileAccess;
/*    */ import org.apache.struts.action.Action;
/*    */ import org.apache.struts.action.ActionForm;
/*    */ import org.apache.struts.action.ActionForward;
/*    */ import org.apache.struts.action.ActionMapping;
/*    */ 
/*    */ public final class AnalyzeAction extends Action
/*    */ {
/*    */   public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response)
/*    */   {
/* 48 */     AnalyzeForm form = (AnalyzeForm)actionForm;
/*  54 */    HttpSession ses = request.getSession();
			 UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
		     if(userinfo == null){
		    	 //error
				ses.setAttribute("ErrMes", "ユーザ情報がありません。再度、ログインして処理して下さい。");
				return mapping.findForward("rtnSelect");
		     }
/*    */     try
/*    */     {
/* 52 */       ScriptDto script = DataAccess.getScriptDataByScriptId(form.getScriptId(),userinfo.getRole());
/*    */ 
/* 55 */       form.setScriptId(script.getScriptId());
/* 56 */       form.setUsrId(script.getUsrId());
/* 57 */       form.setGroupName(script.getGroupName());
/* 58 */       form.setScriptName(script.getScriptName());
/* 59 */       form.setScriptFileName(script.getScriptFileName());
/* 60 */       form.setDelete_flg(script.getDelete_flg());
/*    */ 
/* 63 */       if (!chkFile(Common.getScriptDir(userinfo.getRole()) + "/" + script.getScriptFileName())) {
/*    */ 
/* 66 */         ses.setAttribute("ErrMes", "スクリプトファイルが存在しません。");
/* 67 */         return mapping.findForward("rtnSelect");
/*    */       }
/*    */ 
/* 71 */       List initParamList = FileAccess.getScriptParameter(script.getScriptFileName(),userinfo.getRole());
//->shitamoto add
			   int isfiles = FileAccess.getScriptIsFiles(script.getScriptFileName(),userinfo.getRole());
			   form.setIsfiles(isfiles);
//<-shitamoto add
/*    */ 
/* 73 */       request.setAttribute("initParamList", initParamList);
/*    */     }
/*    */     catch (FileNotFoundException e) {
/* 76 */       form.setMessage(Common.getMessage("errors.jobfile.notfound"));
/*    */     } catch (IOException e) {
/* 78 */       form.setMessage(Common.getMessage("errors.jobfile.readerror"));
/*    */     }
/*    */ 
/* 81 */     return mapping.findForward("success");
/*    */   }
/*    */ 
/*    */   private boolean chkFile(String filePath)
/*    */   {
/* 86 */     File objFile = new File(filePath);
/*    */ 
/* 88 */     return objFile.exists();
/*    */   }
/*    */ }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.AnalyzeAction
 * JD-Core Version:    0.6.0
 */