/*     */ package jp.ac.musashiasp.action;
/*     */ 
/*     */ import au.com.bytecode.opencsv.CSVReader;
/*     */ import au.com.bytecode.opencsv.CSVWriter;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.BufferedWriter;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FileWriter;
/*     */ import java.io.InputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.Reader;
/*     */ import java.io.Writer;
/*     */ import java.text.DateFormat;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Date;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Random;
		  import java.nio.channels.FileChannel;
		  import java.nio.channels.FileLock;
		  import java.io.FileNotFoundException;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*    */  import javax.servlet.http.HttpSession;
/*     */ import jp.ac.musashiasp.dto.JobDto;
/*     */ import jp.ac.musashiasp.dto.ParameterDto;
/*     */ import jp.ac.musashiasp.form.AnalyzeForm;
/*     */ import jp.ac.musashiasp.util.Common;
		  import jp.ac.musashiasp.dto.UserInfo;
		  import jp.ac.musashiasp.util.DataAccess;
/*     */ import org.apache.struts.action.Action;
/*     */ import org.apache.struts.action.ActionForm;
/*     */ import org.apache.struts.action.ActionForward;
/*     */ import org.apache.struts.action.ActionMapping;
/*     */ import org.apache.struts.action.ActionMessage;
/*     */ import org.apache.struts.action.ActionMessages;
/*     */ import org.apache.struts.upload.FormFile;

/*     */ public final class AnalyzeCreateAction extends Action
/*     */ {
/*     */   public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response)
/*     */   {
/*  60 */     AnalyzeForm form = (AnalyzeForm)actionForm;
/*     */ 
/*  54 */     HttpSession ses = request.getSession();
			  UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
		      if(userinfo == null){
		    	 //error
				form.setMessage("ユーザ情報がありません。再度、ログインして処理して下さい。");
		       	return mapping.findForward("success");
		      }
/*  63 */     List paramDto = form.getParamList();
/*     */ 
/*  66 */     String errMsg = makeRunFile(form, paramDto,userinfo.getRole(),userinfo.getUserId());
/*  67 */     if (!errMsg.equals("OK"))
/*     */     {
/*  70 */       ActionMessages messages = new ActionMessages();
/*  71 */       messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(errMsg, false));
/*  72 */       saveErrors(request, messages);
/*     */     }
/*     */ 
/*  75 */     return mapping.findForward("success");
/*     */   }
/*     */ 
/*     */   private boolean makeJobFile(String strJobID, String scriptName, String errFlg,String groupid,String userid)
/*     */   {
/*  84 */       List jobList = new ArrayList();
/*     */       try
/*     */       {
                  synchronized (DataAccess.lock_job) {//20130903 add 排他制御-><-
/*  89 */       	JobDto newData = new JobDto();
/*     */ 
/*  91 */       	DateFormat df = new SimpleDateFormat("yyyy/M/d HH:mm");
/*  92 */       	String nowdate = df.format(new Date());
/*     */ 
/*  94 */       	newData.setJobid(Integer.parseInt(strJobID));
/*  95 */       	newData.setUsrId(userid);//shitamoto
/*  96 */       	newData.setName(scriptName);
/*  97 */       	newData.setRegist_time(nowdate);
/*  98 */       	newData.setStart_time("");
/*  99 */       	newData.setEnd_time("");
/* 100 */       	newData.setDelete_flg(0);
/* 101 */       	newData.setErr_flg(Integer.valueOf(errFlg).intValue());
/*     */ 
/* 103 */       	jobList.add(newData);
/*     */ 
/* 105 */       	CSVReader reader = new CSVReader(
/* 106 */         	new InputStreamReader(new FileInputStream(Common.getMasterDir(groupid) + "/" + "job.csv"), "UTF-8"));
/*     */       	String[] nextLine;
/* 108 */       	while ((nextLine = reader.readNext()) != null)
/*     */       	{
/*     */        	//shitamoto  String[] nextLine;
/* 109 */         		if (nextLine[0].length() == 0)
/*     */         		{
/*     */           		break;
/*     */         		}
/*     */ 
/* 114 */     	    	JobDto fromFile = new JobDto();
/* 115 */      		   	fromFile.setJobid(Integer.parseInt(nextLine[0]));
/* 116 */         		fromFile.setUsrId(nextLine[1]);
/* 117 */         		fromFile.setName(nextLine[2]);
/* 118 */         		fromFile.setRegist_time(nextLine[3]);
/* 119 */         		fromFile.setStart_time(nextLine[4]);
/* 120 */         		fromFile.setEnd_time(nextLine[5]);
/* 121 */         		fromFile.setDelete_flg(Integer.parseInt(nextLine[6]));
/* 122 */         		fromFile.setErr_flg(Integer.parseInt(nextLine[7]));
/*     */ 
/* 124 */         		jobList.add(fromFile);
/*     */       	}
/*     */ 
/* 127 */	       	reader.close();
/*     */ 
/* 130 */       	CSVWriter writer = new CSVWriter(
/* 131 */         	new OutputStreamWriter(new FileOutputStream(Common.getMasterDir(groupid) + "/" + "job.csv"), "UTF-8"));
/* 132 */       	Iterator iter = jobList.iterator();
/* 133 */       	while (iter.hasNext()) {
/* 134 */         		JobDto job = (JobDto)iter.next();
/* 135 */         		String[] outData = { Integer.toString(job.getJobid()), 
/* 136 */       	   	 	job.getUsrId(), 
/* 137 */          	 		job.getName(), 
/* 138 */          	 		job.getRegist_time(), 
/* 139 */          	 		job.getStart_time(), 
/* 140 */           		job.getEnd_time(), 
/* 141 */           		Integer.toString(job.getDelete_flg()), 
/* 142 */           		Integer.toString(job.getErr_flg()) };
/* 143 */         		writer.writeNext(outData);
/*     */       	}
/* 145 */       	writer.close();
				  }//20130903 add 排他制御-><-
/*     */     	}catch (Exception e) {
/* 148 */       	e.printStackTrace();
/* 150 */       	return false;
/*     */     	}
/* 152 */     return true;
/*     */   }
/*     */ 
/*     */   private int rtnSeqNo(String groupid)
/*     */   {
/* 160 */     int seqNo = 0;
/*     */     FileOutputStream fs = null;
/* 162 */     String openFile = Common.getMasterDir(groupid) + "/" + "jobidseq.txt";
/*     */     try
/*     */     {
                synchronized (DataAccess.lock_jobseq) {//20130903 add 排他制御-><-
					Reader seqFile = new InputStreamReader(new FileInputStream(openFile), "UTF-8");
					BufferedReader inBuffer = new BufferedReader(seqFile);
					String line;
					if ((line = inBuffer.readLine()) != null)
					{
						seqNo = Integer.parseInt(line);
					}else {
						seqNo = 0;
					}
					
					if (inBuffer != null) {
						inBuffer.close();
					}
					FileWriter outFile = new FileWriter(openFile);
					BufferedWriter outBuffer = new BufferedWriter(outFile);

					outBuffer.write(String.valueOf(seqNo + 1));

					outBuffer.flush();
					outBuffer.close();
				}//20130903 add 排他制御-><-
			  }catch (Exception e){
					seqNo = -1;
			  }
/* 197 */     return seqNo;
/*     */   }
/*     */ 
/*     */   private String makeRunFile(AnalyzeForm form, List<ParameterDto> paramList,String groupid,String userid)
/*     */   {
/* 209 */     int intJobID = rtnSeqNo(groupid);
/* 210 */     if (intJobID == -1)
/*     */     {
/* 212 */       return "ジョブIDの取得に失敗しました。1";
/*     */     }
/*     */ 
/* 215 */     String strJobID = Integer.toString(intJobID);
/*     */     try
/*     */     {
/* 224 */       makeDir(strJobID,groupid);
/*     */     }
/*     */     catch (Exception e) {
/* 227 */       return "ディレクトリの作成に失敗しました。";
/*     */     }
/*     */ 
/* 237 */     String execScriptName = form.getScriptFileName();
/*     */ 
/* 239 */     String makeScriptName = strJobID;
/*     */     try
/*     */     {
/* 243 */       Reader inFile = new InputStreamReader(
/* 244 */         new FileInputStream(Common.getScriptDir(groupid) + "/" + execScriptName), "UTF-8");
/*     */ 
/* 246 */       Writer outFile = new OutputStreamWriter(
/* 247 */         new FileOutputStream(Common.getExecuteDir(strJobID,groupid) + "/" + makeScriptName + ".run"), "UTF-8");
/*     */ 
/* 249 */       BufferedReader inBuffer = new BufferedReader(inFile);
/*     */ 
/* 251 */       BufferedWriter outBuffer = new BufferedWriter(outFile);
/*     */ 
/* 255 */       String lf = "\n";
/*     */ 
/* 257 */       int startPos = 0;
/*     */ 
/* 259 */       boolean startPosFlg = false;
/* 260 */       int lpcnt = 0;
/*     */ 
/* 263 */       outBuffer.write("touch \"" + Common.getTempDir(groupid) + "/" + strJobID + ".sta" + "\"" + lf);
/*     */       String line;
/* 266 */       while ((line = inBuffer.readLine()) != null)
/*     */       {
/*     */         //shitamoto String line;
/* 268 */         if ((line.trim().length() > 0) && (line.substring(0, 1).equals("#")))
/*     */         {
/* 270 */           outBuffer.write(line + lf);
/*     */         }
/*     */         else
/*     */         {
/* 274 */           if (line.indexOf("@") > -1) {
/* 275 */             startPos = 0;
/* 276 */             for (int i = 0; i < line.length(); i++)
/*     */             {
/* 278 */               if (!line.substring(i, i + 1).equals("@"))
/*     */                 continue;
/* 280 */               if (!startPosFlg)
/*     */               {
/* 282 */                 startPos = i;
/* 283 */                 startPosFlg = true;
/*     */               }
/*     */               else
/*     */               {
/* 287 */                 String keyword = line.substring(startPos + 1, i);
/*     */ 
/* 289 */                 String[] strTemp = keyword.split(":");
/*     */ 
/* 291 */                 if (strTemp.length < 3)
/*     */                 {
/* 293 */                   return "スクリプト内の埋め込みキーワードが不正です。";
/*     */                 }
/*     */ 
/* 296 */                 String keywordName = "";
/* 297 */                 String keywordTitle = "";
/* 298 */                 String keywordType = "";
/*     */ 
/* 301 */                 keywordName = strTemp[0];
/* 302 */                 keywordTitle = strTemp[1];
/* 303 */                 keywordType = strTemp[2];
/*     */ 
/* 306 */                 if (keywordType.equals("text"))
/*     */                 {
/* 308 */                   String replaceString = "";
/*     */ 
/* 310 */                   Iterator it = paramList.iterator();
/* 311 */                   while (it.hasNext()) {
/* 312 */                     ParameterDto param = (ParameterDto)it.next();
/* 313 */                     if (!param.getVar().equals(keywordName)) {
/*     */                       continue;
/*     */                     }
/* 316 */                     replaceString = param.getInitial().toString();
/* 317 */                     break;
/*     */                   }
/*     */ 
/* 321 */                   line = line.replace("@" + keyword + "@", replaceString);
/*     */ 
/* 323 */                   outBuffer.write(line + lf);
/* 324 */                 } else if (keywordType.equals("date"))
/*     */                 {
/* 326 */                   String replaceString = "";
/*     */ 
/* 328 */                   Iterator it = paramList.iterator();
/* 329 */                   while (it.hasNext()) {
/* 330 */                     ParameterDto param = (ParameterDto)it.next();
/* 331 */                     if (!param.getVar().equals(keywordName))
/*     */                       continue;
/* 333 */                     replaceString = param.getInitial().toString();
/* 334 */                     break;
/*     */                   }
/*     */ 
/* 338 */                   line = line.replace("@" + keyword + "@", replaceString);
/*     */ 
/* 340 */                   outBuffer.write(line + lf);
/* 341 */                 } else if (keywordType.equals("master"))
/*     */                 {
/* 343 */                   String replaceString = "";
/*     */ 
/* 345 */                   Iterator it = paramList.iterator();
/* 346 */                   while (it.hasNext()) {
/* 347 */                     ParameterDto param = (ParameterDto)it.next();
/* 348 */                     if (!param.getVar().equals(keywordName))
/*     */                       continue;
/* 350 */                     replaceString = Common.getInmasterDir(groupid) + param.getInitial().toString();
/* 351 */                     break;
/*     */                   }
/*     */ 
/* 355 */                   line = line.replace("@" + keyword + "@", replaceString);
/*     */ 
/* 357 */                   outBuffer.write(line + lf);
/* 358 */                 } else if (keywordType.equals("file"))
/*     */                 {
/* 360 */                   String replaceString = "";
/* 361 */                   replaceString = Common.getExecuteDir(strJobID,groupid) + "/" + strJobID + ".csv";
/*     */ 
/* 363 */                   line = line.replace("@" + keyword + "@", replaceString);
/*     */ 
/* 365 */                   outBuffer.write(line + lf);
/*     */                 }
/* 369 */                 else if (keywordType.equals("files"))
/*     */                 {
/* 371 */                   String[] selectedIndatas = form.getSelectedIndatas();
/* 372 */                   List selectedIndataList = new ArrayList();
/* 373 */                   if ((selectedIndatas != null) && (selectedIndatas.length > 0)) {
/* 374 */                     selectedIndataList = Arrays.asList(selectedIndatas);
/*     */                   }
/*     */ 
/* 377 */                   for (int j = 0; j < selectedIndataList.size(); j++)
/*     */                   {
/* 380 */                     line = keywordTitle + " " + "\"" + Common.getIndataDir(groupid) + 
/* 381 */                       (String)selectedIndataList.get(j) + "\"" + " " + strJobID + lpcnt + j;
/*     */ 
/* 383 */                     outBuffer.write(line + lf);
/*     */                   }
/*     */ 
/*     */                 }
					//shitamoto add 20110920 ->
						  else if (keywordType.equals("uploadfile"))
						  {
						  	//アップロードファイルの保存
						   String upFilePath = "";
		                   Iterator it = paramList.iterator();
		                   while (it.hasNext()) {
		                     ParameterDto param = (ParameterDto)it.next();
		                     if (!param.getVar().equals(keywordName)) {
		                       continue;
		                     }
		                     FormFile upFile = param.getUpfile();
		                     
							 if (upFile != null){
								 if (upFile.getFileName().trim().length() == 0) {
									return "ファイルが選択されていません。";
							     }
							     if (upFile.getFileSize() == 0) {
								 	return "指定したファイルは存在しないか、空のファイルです。 Invalid File : " + upFile.getFileName();
						         }
						         if(upFile.getFileSize() > 1073741000){
						         	return "指定したファイルのサイズが1Gを超えています。 Invalid File : " + upFile.getFileName();
						         }
								 upFilePath = Common.getExecuteDir(strJobID,groupid) + "/" + upFile.getFileName();
						         InputStream is2 = upFile.getInputStream();
						         InputStreamReader upData = new InputStreamReader(is2, "UTF-8");
								 BufferedReader inBuffer2 = new BufferedReader(upData);
						         FileOutputStream fos2 = new FileOutputStream(upFilePath);
						         OutputStreamWriter outFile2 = new OutputStreamWriter(fos2, "UTF-8");
				       			 BufferedWriter outBuffer2 = new BufferedWriter(outFile2);
								 
								 int contents = 0;
								 while ((contents = inBuffer2.read()) != -1) {
									 outBuffer2.write(contents);
								 }
								 outBuffer2.flush();
								 inBuffer2.close();
								 outBuffer2.close();
								 upFile.destroy();
		                     }
		                     break;
		                   }
		                   line = line.replace("@" + keyword + "@", upFilePath);
		                   outBuffer.write(line + lf);
						  }
					//shitamoto add 20110920 <-					
/*     */ 
/* 391 */                 startPosFlg = false;
/*     */               }
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 398 */             outBuffer.write(line + lf);
/*     */           }
/* 400 */           lpcnt++;
/*     */         }
/*     */       }
/*     */ 
/* 404 */       outBuffer.write("touch \"" + Common.getTempDir(groupid) + "/" + strJobID + ".end" + "\"" + lf);
/*     */ 
/* 406 */       outBuffer.flush();
/* 407 */       inBuffer.close();
/* 408 */       outBuffer.close();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 412 */       return "実行スクリプトの作成に失敗しました。";
/*     */     }
/*     */ 
/* 416 */     String qsubFlg = "0";
/*     */ 
/* 418 */     if (makeShell(makeScriptName, strJobID,groupid))
/*     */     {
/*     */       try
/*     */       {
/* 422 */         qsubFlg = execCom(strJobID,groupid);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 426 */         return "コマンドの実行に失敗しました。";
/*     */       }
/*     */     }
/*     */     else {
/* 430 */       return "実行シェルファイルの作成に失敗しました。";
/*     */     }
/*     */ 
/* 434 */     if (!makeJobFile(strJobID, form.getScriptName(), qsubFlg,groupid,userid))
/*     */     {
/* 436 */       return "ジョブの登録に失敗しました。";
/*     */     }
/*     */ 
/* 440 */     return "OK";
/*     */   }
/*     */ 
/*     */   private boolean makeShell(String scriptName, String strJobID,String groupid)
/*     */   {
/* 449 */     String lf = "\n";
/*     */ 
/* 451 */     String shName = Common.getExecuteDir(strJobID,groupid) + "/" + Common.getProperty("jobName") + strJobID + ".sh";
/*     */ 
/* 453 */     FileOutputStream fos = null;
/* 454 */     BufferedWriter outBuffer = null;
/*     */     try
/*     */     {
/* 459 */       fos = new FileOutputStream(shName);
/* 460 */       OutputStreamWriter outFile = new OutputStreamWriter(fos, "UTF-8");
/* 461 */       outBuffer = new BufferedWriter(outFile);
/*     */ 
/* 464 */       outBuffer.write("#!/bin/sh" + lf);
/*     */ 
/* 467 */       outBuffer.write("cd " + Common.getExecuteDir(strJobID,groupid) + "/;" + lf);
/* 468 */       outBuffer.write("sh ./" + scriptName + ".run" + lf);
/* 469 */       outBuffer.write("exit 0" + lf);
/*     */ 
/* 473 */       outBuffer.flush();
/* 474 */       outBuffer.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 478 */       return false;
/*     */     }
/*     */ 
/* 481 */     return true;
/*     */   }
/*     */ 
/*     */   private String execCom(String strJobID,String groupid)
/*     */     throws Exception
/*     */   {
/* 490 */     Random rnd = new Random();
/* 491 */     int ransu = rnd.nextInt(99999);
/*     */ 
/* 493 */     String fileNm = Common.getTempDir(groupid) + "/" + ransu + ".err";
/*     */ 
/* 495 */     String[] cmds = { "bash", "-c", "cd " + Common.getExecuteDir(strJobID,groupid) + 
/* 496 */       "/; export LANG=ja_JP.UTF-8; " + "qsub -N " + Common.getProperty("jobName") + strJobID + " " + 
/* 497 */       "-e " + Common.getExecuteDir(strJobID,groupid) + "/" + strJobID + ".log" + " " + Common.getProperty("jobName") + strJobID + ".sh" + " 2> " + fileNm };
/*     */ 
/* 501 */     Process qsubp = Runtime.getRuntime().exec(cmds);
/* 502 */     qsubp.waitFor();
/*     */ 
/* 505 */     sleep(1000L);
/*     */ 
/* 507 */     boolean waitFig = true;
/* 508 */     int retryCnt = 0;
/*     */ 
/* 510 */     while (waitFig)
/*     */     {
/* 513 */       File resultQsub = new File(fileNm);
/*     */ 
/* 515 */       if (resultQsub.exists()) {
/* 516 */         if (resultQsub.length() > 0L)
/*     */         {
/* 518 */           String[] cmd = { "bash", "-c", "rm " + fileNm + ";" };
/*     */ 
/* 522 */           Process delp = Runtime.getRuntime().exec(cmd);
/* 523 */           delp.waitFor();
/*     */ 
/* 525 */           waitFig = false;
/*     */ 
/* 527 */           return "3";
/*     */         }
/*     */ 
/* 530 */         String[] cmd = { "bash", "-c", "rm " + fileNm + ";" };
/*     */ 
/* 534 */         Process delp = Runtime.getRuntime().exec(cmd);
/* 535 */         delp.waitFor();
/*     */ 
/* 537 */         waitFig = false;
/*     */ 
/* 539 */         return "0";
/*     */       }
/*     */ 
/* 543 */       retryCnt++;
/* 544 */       if (retryCnt > 3) {
/* 545 */         waitFig = false;
/*     */ 
/* 547 */         throw new IOException();
/*     */       }
/*     */ 
/* 550 */       sleep(1000L);
/*     */     }
/*     */ 
/* 555 */     return "0";
/*     */   }
/*     */ 
/*     */   public synchronized void sleep(long msec)
/*     */   {
/*     */     try
/*     */     {
/* 566 */       wait(msec);
/*     */     }
/*     */     catch (InterruptedException localInterruptedException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   private void makeDir(String strJobID,String groupid)
/*     */     throws Exception
/*     */   {
/* 577 */     String[] cmds = { "bash", "-c", "mkdir " + Common.getExecuteDir(strJobID,groupid) };
/*     */ 
/* 579 */     Process mkdp = Runtime.getRuntime().exec(cmds);
/* 580 */     mkdp.waitFor();
/*     */   }
/*     */ }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.AnalyzeCreateAction
 * JD-Core Version:    0.6.0
 */