/*     */ package jp.ac.musashiasp.action;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.BufferedWriter;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStreamWriter;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*    */ import javax.servlet.http.HttpSession;

/*     */ import jp.ac.musashiasp.form.UploadIndataForm;
/*     */ import jp.ac.musashiasp.util.Common;
/*     */ import jp.ac.musashiasp.dto.UserInfo;
/*     */ import org.apache.struts.action.Action;
/*     */ import org.apache.struts.action.ActionForm;
/*     */ import org.apache.struts.action.ActionForward;
/*     */ import org.apache.struts.action.ActionMapping;
/*     */ import org.apache.struts.upload.FormFile;
/*     */ 
/*     */ public final class UploadIndataAction extends Action
/*     */ {
/*     */   public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response)
/*     */   {
/*  49 */     UploadIndataForm form = (UploadIndataForm)actionForm;
/*     */ 
/*  53 */     FormFile upFile = form.getUpFile();
		      HttpSession ses = request.getSession();
		      UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
		     
		      if(userinfo == null){
		      	 //error
				form.setMessage("ユーザ情報がありません。再度、ログインして処理して下さい。");
		       	return mapping.findForward("success");
		      }
/*  55 */     if (upFile != null)
/*     */     {
/*  58 */       if (upFile.getFileName().trim().length() == 0) {
/*  59 */         form.setMessage("登録ファイルを選択してください。");
/*  60 */         return mapping.findForward("success");
/*  61 */       }if (upFile.getFileSize() == 0) {
/*  62 */         form.setMessage("指定したファイルは存在しないか、空のファイルです。 Invalid File : " + upFile.getFileName());
/*  63 */         return mapping.findForward("success");
/*     */       }
/*     */ 
/*  67 */       String upFilePath = "";
/*  68 */       String upFileNameString = "";
/*  69 */       if (form.getUpType().equals("0"))
/*     */       {
/*  71 */         upFilePath = Common.getIndataDir(userinfo.getRole()) + "/" + upFile.getFileName();
/*  72 */         upFileNameString = "処理対象データ";
/*     */       }
/*     */       else {
/*  75 */         upFilePath = Common.getInmasterDir(userinfo.getRole()) + "/" + upFile.getFileName();
/*  76 */         upFileNameString = "マスタデータ";
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/*  82 */         InputStream is = upFile.getInputStream();
/*     */ 
/*  84 */         InputStreamReader upData = new InputStreamReader(is, "UTF-8");
/*     */ 
/*  86 */         BufferedReader inBuffer = new BufferedReader(upData);
/*     */ 
/*  88 */         FileOutputStream fos = new FileOutputStream(upFilePath);
/*     */ 
/*  90 */         OutputStreamWriter outFile = new OutputStreamWriter(fos, "UTF-8");
/*     */ 
/*  92 */         BufferedWriter outBuffer = new BufferedWriter(outFile);
/*     */ 
/*  94 */         int contents = 0;
/*     */ 
/*  97 */         while ((contents = inBuffer.read()) != -1) {
/*  98 */           outBuffer.write(contents);
/*     */         }
/*     */ 
/* 101 */         outBuffer.flush();
/* 102 */         inBuffer.close();
/* 103 */         outBuffer.close();
/*     */ 
/* 106 */         upFile.destroy();
/*     */ 
/* 108 */         form.setMessage(upFileNameString + "を登録しました。");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 112 */         form.setMessage("アップロードエラー : " + e.toString());
/* 113 */         return mapping.findForward("success");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 118 */       form.setUpType("0");
/*     */     }
/*     */ 
/* 122 */     return mapping.findForward("success");
/*     */   }
/*     */ }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.UploadIndataAction
 * JD-Core Version:    0.6.0
 */