/*     */ package jp.ac.musashiasp.util;
/*     */ 
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.regex.*;
import jp.ac.musashiasp.dto.UserInfo;
public class BasicAuthFilter implements Filter {
	private static final String EXCLUDE_PATH = "excludepath";
	private static final String LOGIN_PATH = "loginpath";
	private static final String OPENW_PATH = "openwindowpath";
	private String[] excludeArray;
	private String loginPath;
	private String[] openwArray;
	public void init(FilterConfig config) throws ServletException {
		//web.xmlからパラメタを読み込む
		String excludePath = (String)config.getInitParameter(EXCLUDE_PATH);
		String openwPath = (String)config.getInitParameter(OPENW_PATH);
		loginPath= (String)config.getInitParameter(LOGIN_PATH);
		//パスを分割
		excludeArray =excludePath.split(",");
		openwArray = openwPath.split(",");
    }

    public void destroy() {
        // userファイル内容の破棄
        
    }

    public void doFilter(ServletRequest req, 
                         ServletResponse res, 
                         FilterChain chain) throws IOException, ServletException {

		// ServletRequestとServletResponseをHttp*にキャストする
        HttpServletRequest hreq = (HttpServletRequest)req;
        HttpServletResponse hres = (HttpServletResponse)res;
        HttpSession session = hreq.getSession();
		String target = ((HttpServletRequest)req).getRequestURI();
		boolean isOpenw = isOpenWPath(target);
		String aaa= (String)session.getAttribute("aaaaa");
		session.setAttribute("aaaaa",aaa + " *[" + isOpenw + "][" + target + "]");
		try {
			
			if(!isExcludePath(target)){
		    
				if (session == null){
					/* まだ認証されていない */
					/*初めてのログイン*/
					if(isOpenw){//別起動のWindow
						((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() +  "/error.jsp");
						return;
					}
					session = ((HttpServletRequest)req).getSession(true);
					session.setAttribute("target", target);
					session.setAttribute("login", "login");
					((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() +  loginPath);
					return;
				}else{
					Object loginCheck = session.getAttribute("login");
					if (loginCheck == null ){
						if(isOpenw){//別起動のWindow
							((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() +  "/error.jsp");
							return;
						}
						/* まだ認証されていない */
						/*ログアウト後,セッションタイムアウトのログイン*/
						session.setAttribute("target", target);
						session.setAttribute("login", "login");
						((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() + loginPath);
						return;
					}else{
						if(!loginCheck.equals("ok")){
							if(loginCheck.equals("check")){
								if(isOpenw){//別起動のWindow
									((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() +  "/error.jsp");
									return;
								}
								/*ログイン処理中*/
								((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() + loginPath);
								return;
							}else{
								if(isOpenw){//別起動のWindow
									((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() +  "/error.jsp");
									return;
								}

								/* まだ認証されていない */
								/*ログアウト後,セッションタイムアウトのログイン*/
								session.setAttribute("target", target);
								session.setAttribute("login", "login");
								((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() + loginPath);
								return;						
							}
						}else{

							//認証済み
							//正しいページからのアクセスかをチェック
							String req_id = hreq.getParameter("r_id");
							String ses_id = (String)session.getAttribute("userid");
							//session.setAttribute("bbbbb"," *[" + req_id + "][" + ses_id + "]");
							if(req_id != null && ses_id != null && !req_id.equals(ses_id)){
									((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() +  "/error2.jsp");
									return;
							}					
						}
					}
				}
			}
		} catch(Exception ex) {
			if(isOpenw){//別起動のWindow
				((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() +  "/error.jsp");
				return;
			}

			// 失敗したら再度認証を行うように要求する。
			session.setAttribute("target", target);
			session.setAttribute("login", "login");
			((HttpServletResponse)res).sendRedirect(((HttpServletRequest)req).getContextPath() + loginPath);
			return;
		}

							

        chain.doFilter(req, res);
    }

    private boolean isExcludePath(String target) {

       //パターンとリクエストされているURLを比較して判定
       for(int i = 0; i < excludeArray.length; i++){
           Pattern pattern = Pattern.compile("^" + excludeArray[i]);
           Matcher matcher = pattern.matcher(target);
           if(matcher.matches()){
               return true;
           }
       }

       return false;
    }
    private boolean isOpenWPath(String target) {

       //パターンとリクエストされているURLを比較して判定
       //ポップアップウィンドウの場合の処理、ログイン画面へ渡さず、エラー画面へ遷移させる。
       for(int i = 0; i < openwArray.length; i++){
           Pattern pattern = Pattern.compile("^" + openwArray[i]);
           Matcher matcher = pattern.matcher(target);
           if(matcher.matches()){
               return true;
           }
       }

       return false;
    }
}
