/*     */ package jp.ac.musashiasp.util;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.BufferedWriter;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.Reader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import jp.ac.musashiasp.dto.ParameterDto;
/*     */ 
/*     */ public class FileAccess
/*     */ {
/*     */   public static final int FILE_TYPE_ID_INDATA = 1;
/*     */   public static final int FILE_TYPE_ID_SCRIPT = 2;
/*     */   public static final int FILE_TYPE_ID_MASTER = 3;
/*     */   public static final int FILE_TYPE_ID_OUTDATA = 4;
/*     */   public static final int FILE_TYPE_ID_INMASTER = 5;
/*     */ 
/*     */   public static List<String> readLogFile(String logFileName,String groupid)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/*  66 */     String logDir = Common.getExecuteDir(logFileName,groupid);
/*     */ 
/*  68 */     String logFilePath = logDir + "/" + logFileName + ".log";
/*     */ 
/*  71 */     List logContents = new ArrayList();
/*     */ 
/*  73 */     logContents = readFile(logFilePath);
/*     */ 
/*  75 */     return logContents;
/*     */   }
/*     */ 
/*     */   public static List<String> readFile(String filename)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/*  87 */     List scriptData = new ArrayList();
/*     */     try {
/*  89 */       Reader in = new InputStreamReader(new FileInputStream(filename), "UTF-8");
/*     */ 
/*  91 */       BufferedReader br = new BufferedReader(in);
/*     */       String line;
/*  93 */       while ((line = br.readLine()) != null)
/*     */       {
/*     */         //shitamoto String line;
/*  94 */         scriptData.add(line);
/*     */       }
/*  96 */       br.close();
/*  97 */       in.close();
/*     */     } catch (FileNotFoundException e) {
/*  99 */       e.printStackTrace();
/* 100 */       throw e;
/*     */     } catch (IOException e) {
/* 102 */       e.printStackTrace();
/* 103 */       throw e;
/*     */     }
/* 105 */     return scriptData;
/*     */   }
/*     */ 
/*     */   public static void writeFile(String filename, List<String> data)
/*     */     throws IOException
/*     */   {
/* 117 */     BufferedWriter bw = 
/* 118 */       new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename), "UTF-8"));
/*     */     try {
/* 120 */       for (int i = 0; i < data.size(); i++) {
/* 121 */         bw.write((String)data.get(i));
/* 122 */         bw.newLine();
/* 123 */         bw.flush();
/*     */       }
/* 125 */       bw.close();
/*     */     } catch (IOException e) {
/* 127 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static List<ParameterDto> getScriptParameter(String fileName,String groupid)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/* 144 */     String scripFileFullPath = Common.getScriptDir(groupid) + "/" + fileName;
/* 145 */     List scriptParameter = new ArrayList();
/* 146 */     BufferedReader br = null;
/*     */     try {
/* 148 */       br = new BufferedReader(
/* 149 */         new InputStreamReader(new FileInputStream(scripFileFullPath), "UTF-8"));
/*     */       String line;
/* 152 */       while ((line = br.readLine()) != null)
/*     */       {
/*     */         //shitamoto String line;
/* 153 */         ParameterDto dto = new ParameterDto();
/*     */ 
/* 155 */         if ((line.trim().length() <= 0) || (line.substring(0, 1).equals("#"))) {
/*     */           continue;
/*     */         }
/* 158 */         int pos1 = line.indexOf('@');
/*     */ 
/* 160 */         if (pos1 == -1)
/*     */           continue;
/* 162 */         int pos2 = line.indexOf('@', pos1 + 1);
/* 163 */         if (pos2 == -1)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 171 */         String parameters = line.substring(pos1 + 1, pos2);
/* 172 */         String[] parameter = parameters.split(":");
/* 173 */         String type = parameter[2];
/* 174 */         if ((type == null) || ("".equals(type)) || ("files".equals(type)) || 
/* 175 */           ("file".equals(type))) {
/*     */           continue;
/*     */         }
/* 178 */         if (parameter.length == 3) {
/* 179 */           dto.setVar(parameter[0]);
/* 180 */           dto.setLabel(parameter[1]);
/* 181 */           dto.setType(parameter[2]);
/* 182 */           dto.setInitial("");
//-> shitamoto 20110629 add 
/* 187 */           dto.setCommenttitle("");
/* 188 */           dto.setComment("");
//<- shitamoto 20110629 add 
/*     */         }
/* 185 */         else if (parameter.length == 4) {
/* 186 */           dto.setVar(parameter[0]);
/* 187 */           dto.setLabel(parameter[1]);
/* 188 */           dto.setType(parameter[2]);
/* 189 */           dto.setInitial(parameter[3]);
//-> shitamoto 20110629 add 
/* 187 */           dto.setCommenttitle("");
/* 188 */           dto.setComment("");
//<- shitamoto 20110629 add 
/*     */         }
//-> shitamoto 20110629 add ->
/* 185 */         else if (parameter.length == 5) {
/* 186 */           dto.setVar(parameter[0]);
/* 187 */           dto.setLabel(parameter[1]);
/* 188 */           dto.setType(parameter[2]);
/* 189 */           dto.setInitial("");
/* 187 */           dto.setCommenttitle(parameter[4]);
/* 188 */           dto.setComment(parameter[5]);
/*     */         }
/* 185 */         else if (parameter.length == 6) {
/* 186 */           dto.setVar(parameter[0]);
/* 187 */           dto.setLabel(parameter[1]);
/* 188 */           dto.setType(parameter[2]);
/* 189 */           dto.setInitial(parameter[3]);
/* 187 */           dto.setCommenttitle(parameter[4]);
/* 188 */           dto.setComment(parameter[5]);
/*     */         }
//<- shitamoto 20110629 add 

/* 191 */         scriptParameter.add(dto);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (FileNotFoundException e)
/*     */     {
/* 199 */       throw e;
/*     */     } catch (IOException e) {
/* 201 */       throw e;
/*     */     }
/*     */     finally {
/* 204 */       if (br != null) {
/* 205 */         br.close();
/*     */       }
/*     */     }
/* 208 */     return scriptParameter;
/*     */   }
//-> shitamoto add
/*     */   public static int getScriptIsFiles(String fileName,String groupid)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/* 144 */     String scripFileFullPath = Common.getScriptDir(groupid) + "/" + fileName;
/* 146 */     BufferedReader br = null;
			  int isFiles = 0;
/*     */     try {
/* 148 */       br = new BufferedReader(
/* 149 */         new InputStreamReader(new FileInputStream(scripFileFullPath), "UTF-8"));
/*     */       String line;

/* 152 */       while ((line = br.readLine()) != null)
/*     */       {
/*     */         //shitamoto String line;
/*     */ 
/* 155 */         if ((line.trim().length() <= 0) || (line.substring(0, 1).equals("#"))) {
/*     */           continue;
/*     */         }
/* 158 */         int pos1 = line.indexOf('@');
/*     */ 
/* 160 */         if (pos1 == -1)
/*     */           continue;
/* 162 */         int pos2 = line.indexOf('@', pos1 + 1);
/* 163 */         if (pos2 == -1)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 171 */         String parameters = line.substring(pos1 + 1, pos2);
/* 172 */         String[] parameter = parameters.split(":");
/* 173 */         String type = parameter[2];
/* 174 */         if (("files".equals(type))) {
/*     */           isFiles = 1;
					break;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (FileNotFoundException e)
/*     */     {
/* 199 */       throw e;
/*     */     } catch (IOException e) {
/* 201 */       throw e;
/*     */     }
/*     */     finally {
/* 204 */       if (br != null) {
/* 205 */         br.close();
/*     */       }
/*     */     }
/* 208 */     return isFiles;
/*     */   }
//<- shitamoto add
//-> shitamoto add 20110913
/*     */   public static StringBuffer getScriptData(String fileName,String groupid)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/* 144 */     String scripFileFullPath = Common.getScriptDir(groupid) + "/" + fileName;
			  StringBuffer scriptData = new StringBuffer();  
/* 146 */     BufferedReader br = null;
/*     */     try {
/* 148 */       br = new BufferedReader(
/* 149 */         new InputStreamReader(new FileInputStream(scripFileFullPath), "UTF-8"));
				String line;
				
/* 152 */       while ((line = br.readLine()) != null)
/*     */       {
/* 191 */         scriptData.append(line);
				  scriptData.append("\n");
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (FileNotFoundException e)
/*     */     {
/* 199 */       throw e;
/*     */     } catch (IOException e) {
/* 201 */       throw e;
/*     */     }
/*     */     finally {
/* 204 */       if (br != null) {
/* 205 */         br.close();
/*     */       }
/*     */     }
/* 208 */     return scriptData;
/*     */   }
/*     */   public static void saveScriptData(String fileName,StringBuffer scriptData,String groupid)
/*     */     throws IOException
/*     */   {
/* 144 */     String scripFileFullPath = Common.getScriptDir(groupid) + "/" + fileName;
/* 146 */     BufferedWriter bw = null;
/*     */     try {
/* 148 */       bw = new BufferedWriter(
/* 149 */         new OutputStreamWriter(new FileOutputStream(scripFileFullPath), "UTF-8"));
/* 121 */         
				bw.write((String)scriptData.toString());
/* 122 */       bw.newLine();
/* 123 */       bw.flush();
/*     */ 		bw.close();
/*     */     }catch (IOException e) {
/* 201 */       throw e;
/*     */     }
/* 208 */     return ;
/*     */   }

//<- shitamoto add 20110913 
/*     */   public static List<String> getFileList(int type,String groupid)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/* 220 */     String fileFullPath = "";
/* 221 */     List workList = new ArrayList();
/*     */ 
/* 223 */     switch (type)
/*     */     {
/*     */     case 1:
/* 226 */       fileFullPath = Common.getIndataDir(groupid);
/* 227 */       break;
/*     */     case 2:
/* 230 */       fileFullPath = Common.getScriptDir(groupid);
/* 231 */       break;
/*     */     case 3:
/* 234 */       fileFullPath = Common.getMasterDir(groupid);
/* 235 */       break;
/*     */     case 4:
/* 238 */       fileFullPath = Common.getOutdataDir(groupid);
/* 239 */       break;
/*     */     case 5:
/* 242 */       fileFullPath = Common.getInmasterDir(groupid);
/* 243 */       break;
/*     */     default:
/* 246 */       return workList;
/*     */     }
/*     */ 
/* 250 */     File dir = new File(fileFullPath);
/*     */ 
/* 252 */     if (!dir.exists()) {
/* 253 */       throw new FileNotFoundException();
/*     */     }
/* 255 */     File[] in = dir.listFiles();
/* 256 */     if ((in != null) && (in.length > 0)) {
/* 257 */       for (int i = 0; i < in.length; i++) {
/* 258 */         if (!in[i].isFile()) {
/*     */           continue;
/*     */         }
/* 261 */         workList.add(in[i].getName());
/*     */       }
/*     */     }
/*     */ 
/* 265 */     return workList;
/*     */   }
/*     */ }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.util.FileAccess
 * JD-Core Version:    0.6.0
 */