#!/usr/bin/env bash

in="./indat"
out="./outdat"

rm -f $out/*

#---------------------------------------------------------------
cmd="xt2html"
#---------------------------------------------------------------
# different keys
xt2html -i $in/dat9.xt -o $out/${cmd}01.html
xt2html -k key1 -i $in/dat9.xt -o $out/${cmd}02.html
xt2html -k key1,key2 -i $in/dat9.xt -o $out/${cmd}03.html
xt2html -k key1,key2,key3 -i $in/dat9.xt -o $out/${cmd}04.html
xt2html -k key1,key2,key3,key4 -i $in/dat9.xt -o $out/${cmd}05.html

# -C
xt2html -k key1,key2,key3,key4 -C 'key*' -R 'val*' -i $in/dat9.xt -o $out/${cmd}06.html

# -r
xt2html -k key1,key2,key3,key4 -C 'key*' -R 'val*' -b -i $in/dat9.xt -o $out/${cmd}07.html

#---------------------------------------------------------------
cmd="xt2gml"
#---------------------------------------------------------------
# All
xt2gml -k key -v nodeID -f att1,att2 -i $in/vtx.xt -b nodeID1 -e nodeID2 -F Eatt1,Eatt2 -I $in/edge.xt -d dir -o $out/${cmd}01.xml

# without -f,-F
xt2gml -k key -v nodeID -i $in/vtx.xt -b nodeID1 -e nodeID2 -I $in/edge.xt -d dir -o $out/${cmd}02.xml

# with -w
xt2gml -k key -v nodeID -i $in/vtx.xt -b nodeID1 -e nodeID2 -I $in/edge.xt -d dir -w -o $out/${cmd}03.xml

# with -D
xt2gml -k key -v nodeID -f att1,att2 -i $in/vtx.xt -b nodeID1 -e nodeID2 -F Eatt1,Eatt2 -I $in/edge.xt -D -o $out/${cmd}04.xml

# withoutkey
xtuniq -k nodeID -i $in/vtx.xt -o xxa
xt2gml -v nodeID -f att1,att2 -i xxa -b nodeID1 -e nodeID2 -F Eatt1,Eatt2 -I $in/edge.xt -d dir -o $out/${cmd}05.xml

# copyright, description
xt2gml -k key -v nodeID -f att1,att2 -i $in/vtx.xt -b nodeID1 -e nodeID2 -F Eatt1,Eatt2 -I $in/edge.xt -o $out/${cmd}06.xml --cr "test copy-right" --desc "description"

#---------------------------------------------------------------
cmd="xtbar"
#---------------------------------------------------------------
# All
xtbar  -k Brand -e Area -c Age -r Gender -f Purchase_Amount -i $in/dat8.xt -o $out/${cmd}01.svg

# without -c & %n
xtbar  -k Brand -e Area -c Age%nr -r Gender%r -f Purchase_Amount -i $in/dat8.xt -o $out/${cmd}02.svg

# without -c & --fix
xtbar  -k Brand -e Area -c Age -r Gender -f Purchase_Amount -i $in/dat8.xt --fix -o $out/${cmd}03.svg

# without -r
xtselstr -f Gender -v Male -i $in/dat8.xt |
xtbar  -k Brand -e Area -c Age -f Purchase_Amount -o $out/${cmd}04.svg

# without -c
xtselstr -f Gender -v Male -i $in/dat8.xt |
xtbar  -k Brand -e Area -r Age -f Purchase_Amount -o $out/${cmd}05.svg

# without -r & -c
xtselstr -f Gender -v Male -i $in/dat8.xt |
xtselstr -f Age    -v 40 |
xtbar  -k Brand -e Area -f Purchase_Amount -o $out/${cmd}06.svg

# without -r & -c & -e
xtselstr -f Gender -v Male -i $in/dat8.xt |
xtselstr -f Age    -v 40 |
xtselstr -f Area   -v Hokkaido |
xtbar  -k Brand -f Purchase_Amount -o $out/${cmd}07.svg

# withTitle1
xtheader -l "This is a title. ϥȥǤ." -i $in/dat8.xt |
xtbar  -k Brand -e Area -c Age -r Gender -f Purchase_Amount -o $out/${cmd}08.svg

# withTitle1
xtheader -l "This is a title. ϥȥǤ." -i $in/dat8.xt |
xtbar  -k Brand -e Area -c Age -r Gender -f Purchase_Amount --title 'aaaaaaƥȥץaaaaaaa' -o $out/${cmd}09.svg

#---------------------------------------------------------------
cmd="xtline"
#---------------------------------------------------------------
# All
xtline  -k Brand -e Area -c Age -r Gender -f Purchase_Amount -i $in/dat8.xt -o $out/${cmd}01.svg

# without -c & %n
xtline  -k Brand -e Area -c Age%nr -r Gender%r -f Purchase_Amount -i $in/dat8.xt -o $out/${cmd}02.svg

# without -c & --fix
xtline  -k Brand -e Area -c Age -r Gender -f Purchase_Amount -i $in/dat8.xt --fix -o $out/${cmd}03.svg

# without -r
xtselstr -f Gender -v Male -i $in/dat8.xt |
xtline  -k Brand -e Area -c Age -f Purchase_Amount -o $out/${cmd}04.svg

# without -c
xtselstr -f Gender -v Male -i $in/dat8.xt |
xtline  -k Brand -e Area -r Age -f Purchase_Amount -o $out/${cmd}05.svg

# without -r & -c
xtselstr -f Gender -v Male -i $in/dat8.xt |
xtselstr -f Age    -v 40 |
xtline  -k Brand -e Area -f Purchase_Amount -o $out/${cmd}06.svg

# without -r & -c & -e
xtselstr -f Gender -v Male -i $in/dat8.xt |
xtselstr -f Age    -v 40 |
xtselstr -f Area   -v Hokkaido |
xtline  -k Brand -f Purchase_Amount -o $out/${cmd}07.svg

# withTitle1
xtheader -l "This is a title. ϥȥǤ." -i $in/dat8.xt |
xtline  -k Brand -e Area -c Age -r Gender -f Purchase_Amount -o $out/${cmd}08.svg

# withTitle1
xtheader -l "This is a title. ϥȥǤ." -i $in/dat8.xt |
xtline  -k Brand -e Area -c Age -r Gender -f Purchase_Amount --title 'aaaaaaƥȥץaaaaaaa' -o $out/${cmd}09.svg

#---------------------------------------------------------------
cmd="xtfixlen"
#---------------------------------------------------------------
xtfixlen -k date,time -i $in/normal.xt -o $out/${cmd}01.xt
cp  $out/${cmd}01.xt $in/fixlen01.xt

xtfixlen -k time,date -i $in/normal.xt -o $out/${cmd}02.xt
cp  $out/${cmd}02.xt $in/fixlen02.xt

xtfixlen -i $in/normal.xt -o $out/${cmd}03.xt

xtfixlen -f time%10 -i $in/normal.xt -o $out/${cmd}04.xt

xtfixlen -f no%4,time%12 -i $in/normal.xt -o $out/${cmd}05.xt

#---------------------------------------------------------------
cmd="xtbsselstr"
#---------------------------------------------------------------
xtbsselstr -k date,time -v 20030105:120000 -i $in/fixlen01.xt -o $out/${cmd}01.xt

xtbsselstr -k date,time -v 20030105,20030108 -i $in/fixlen01.xt -o $out/${cmd}02.xt

xtbsselstr -k date,time -v 20030105~20030108 -i $in/fixlen01.xt -o $out/${cmd}03.xt

xtbsselstr -k date,time -v 20030101~20031231 -i $in/fixlen01.xt -o $out/${cmd}04.xt

xtbsselstr -k date,time -v 20030105:120000~160500 -i $in/fixlen01.xt -o $out/${cmd}05.xt

xtbsselstr -k date,time -v 20030105:120000~160500,20030101:100000 -i $in/fixlen01.xt -o $out/${cmd}06.xt

xtbsselstr -k date,time -v 20030105:120000~160500,20030101:000000~245959 -i $in/fixlen01.xt -o $out/${cmd}07.xt

xtbsselstr -k time -v 000000~245959 -i $in/fixlen02.xt -o $out/${cmd}08.xt

xtbsselstr -k time,date -v 100000:20030101~20030101,120000 -i $in/fixlen02.xt -o $out/${cmd}09.xt


#---------------------------------------------------------------
cmd="xtbsupdate"
#---------------------------------------------------------------
cp $in/fixlen01.xt $out/${cmd}01.xt
xtbsupdate -k date,time -v 20030105:120000 -f no%2 -i $out/${cmd}01.xt

cp $in/fixlen01.xt $out/${cmd}02.xt
xtbsupdate -k date,time -v 20030105,20030108 -f no%3 -i $out/${cmd}02.xt

cp $in/fixlen01.xt $out/${cmd}03.xt
xtbsupdate -k date,time -v 20030105~20030108 -f no%4 -i $out/${cmd}03.xt

cp $in/fixlen01.xt $out/${cmd}04.xt
xtbsupdate -k date,time -v 20030101~20031231 -f no%5 -i $out/${cmd}04.xt

cp $in/fixlen01.xt $out/${cmd}05.xt
xtbsupdate -k date,time -v 20030105:120000~160500 -f no%6 -i $out/${cmd}05.xt

cp $in/fixlen01.xt $out/${cmd}06.xt
xtbsupdate -k date,time -v 20030105:120000~160500,20030101:100000 -f no%7 -i $out/${cmd}06.xt

cp $in/fixlen01.xt $out/${cmd}07.xt
xtbsupdate -k date,time -v 20030105:120000~160500,20030101:000000~245959 -f no%8 -i $out/${cmd}07.xt

cp $in/fixlen02.xt $out/${cmd}08.xt
xtbsupdate -k time -v 000000~245959 -f no%9 -i $out/${cmd}08.xt

cp $in/fixlen02.xt $out/${cmd}09.xt
xtbsupdate -k time,date -v 100000:20030101~20030101,120000 -f no%A -i $out/${cmd}09.xt

#---------------------------------------------------------------
cmd="xtformat"
#---------------------------------------------------------------
xtformat -I $in/template.html -i $in/normal.xt -o $out/${cmd}01.txt

xtformat -I $in/template2.html -i $in/normal.xt -o $out/${cmd}02.txt

xtformat -I $in/template.html -i $in/null.xt -o $out/${cmd}03.txt

xtformat -I $in/template.html -n $in/whenNull.html -i $in/null.xt -o $out/${cmd}04.txt

#---------------------------------------------------------------
cmd="xml2xt"
#---------------------------------------------------------------
xml2xt -k /root/Ź// -f , -i $in/dat.xml -o $out/${cmd}01.xt

xml2xt -k /root/Ź// -f , -i $in/dat.xml -S '#SPACE#' -o $out/${cmd}02.xt

#---------------------------------------------------------------
cmd="xt2csv"
#---------------------------------------------------------------
xt2csv -i $in/dat4.xt -o $out/${cmd}01.txt

xt2csv -F -i $in/dat4.xt -o $out/${cmd}02.txt

xt2csv -q no1,no3 -F -i $in/dat4.xt -o $out/${cmd}03.txt

#---------------------------------------------------------------
cmd="csv2xt"
#---------------------------------------------------------------
csv2xt -i $in/dat4.csv -F -o $out/${cmd}01.xt

csv2xt -i $in/dat4.csv -a a,b,c -o $out/${cmd}02.xt

#---------------------------------------------------------------
cmd="xt2xml"
#---------------------------------------------------------------
xt2xml -k Ź,, -i $in/dat.xt -o $out/${cmd}01.xml

xt2xml -k Ź,, -i $in/dat.xt -R RootTag:year=2001 -o $out/${cmd}02.xml

xt2xml -k Ź, -i $in/dat.xt -L  -o $out/${cmd}03.xml

xt2xml -k Ź, -i $in/dat.xt -L  -q -o $out/${cmd}04.xml

xt2xml -i $in/xt2xml.xt -o $out/${cmd}05.xml

xt2xml -k month -i $in/xt2xml.xt -o $out/${cmd}06.xml

#---------------------------------------------------------------
cmd="xtaccum"
#---------------------------------------------------------------
#,߷
#,۹ܤΡ0Ѵ
xtnulto -f , -v 0 -i $in/dat.xt              |
#accumǿ,ۤ߷
xtaccum -k Ź -s %n -f :߷,:߷ -o $out/${cmd}01.xt


#,߷
#,۹ܤΡ0Ѵ
xtnulto -f , -v 0 -i $in/dat.xt              |
#accumǿ,ۤ߷
xtaccum -s %n -f :߷,:߷ -o $out/${cmd}02.xt

#---------------------------------------------------------------
cmd="xtagg"
#---------------------------------------------------------------
#˶ۤ(-k -f -c sum)ѻ
xtagg -k  -f , -c sum -i $in/dat.xt -o $out/${cmd}01.xt

#˶ۤ򥫥(-k -f -c cnt)ѻ
xtagg -k  -f , -c cnt -i $in/dat.xt -o $out/${cmd}02.xt

#˶ۤʿ(-k -f -c avg)ѻ
xtagg -k  -f , -c avg -i $in/dat.xt -o $out/${cmd}03.xt

#˶ۤκ(-k -f -c max)ѻ
xtagg -k  -f , -c max -i $in/dat.xt -o $out/${cmd}04.xt

#˶ۤκǾ(-k -f -c min)ѻ
xtagg -k  -f , -c min  -i $in/dat.xt -o $out/${cmd}05.xt

#˿,ۤ(-k -f -c sum)ѻ 󥷥뽸
xtagg -k  -f ,  -c sum -q -i $in/dat.xt -o $out/${cmd}06.xt

#˿,ۤ򥫥(-k -f -c cnt)ѻ 󥷥뽸
xtagg -k  -f , -q -c cnt -i $in/dat.xt -o $out/${cmd}07.xt

#˿,ۤʿ(-k -f -c avg)ѻ 󥷥뽸
xtagg -k  -f , -q -c avg -i $in/dat.xt -o $out/${cmd}08.xt

#˿,ۤκ(-k -f -c max)ѻ 󥷥뽸
xtagg -k  -f , -q -c max -i $in/dat.xt -o $out/${cmd}09.xt

#˿,ۤκǾ(-k -f -c min)ѻ 󥷥뽸
xtagg -k  -f , -q -c min -i $in/dat.xt -o $out/${cmd}10.xt

#,ۤ(-f -c sum)ѻ Kʤ
xtagg -f , -c sum -i $in/dat.xt -o $out/${cmd}11.xt

#,ۤ򥫥(-f -c cnt)ѻ Kʤ
xtagg -f , -c cnt -i $in/dat.xt -o $out/${cmd}12.xt

#,ۤʿ(-f -c avg)ѻ Kʤ
xtagg -f , -c cnt -i $in/dat.xt -o $out/${cmd}13.xt

#,ۤκ(-f -c max)ѻ Kʤ
xtagg -f , -c max -i $in/dat.xt -o $out/${cmd}14.xt

#,ۤκǾ(-f -c min)ѻ kʤ
xtagg -f , -c min -i $in/dat.xt -o $out/${cmd}15.xt

#,ۤ(-f -c sum)ѻ Kʤ󥷥뽸
xtagg -f , -c sum -i $in/dat.xt -o $out/${cmd}16.xt

#,ۤ򥫥(-f -c cnt)ѻ Kʤ󥷥뽸
xtagg -f , -c cnt -i $in/dat.xt -o $out/${cmd}17.xt

#ۤʿ(-f -c avg)ѻ Kʤ󥷥뽸
xtagg -f , -c avg -i $in/dat.xt -o $out/${cmd}18.xt

#,ۤκ(-f -c max)ѻ Kʤ󥷥뽸
xtagg -f , -c max -i $in/dat.xt -o $out/${cmd}19.xt

#,ۤκǾ(-f -c min)ѻ Kʤ󥷥뽸
xtagg -f , -c min -i $in/dat.xt -o $out/${cmd}20.xt

xtagg -k Ź -f  -c sum -i $in/dat.xt -o $out/${cmd}21.xt

#ʣǤν
xtagg -k Ź,, -f , -c sum -i $in/dat.xt -o $out/${cmd}22.xt
xtagg -k ,,Ź -f , -c sum -i $in/dat.xt -o $out/${cmd}23.xt

#---------------------------------------------------------------
cmd="xtbest"
#---------------------------------------------------------------
#ۤι⤤˥٥Ȥ
xtbest -k Ź -s %nr -R 2_3 -i $in/dat.xt -o $out/${cmd}01.xt

#ۤι⤤˥٥Ȥ(ȿž)
xtbest -k Ź -s %nr -r -R 2_3 -i $in/dat.xt -o $out/${cmd}02.xt

#ۤι⤤˥٥Ȥ(-kʤ)
xtbest  -s %nr -R 2_3 -i $in/dat.xt -o $out/${cmd}03.xt

#ۤι⤤˥٥Ȥ(ȿž,-kʤ)
xtbest -s %nr -r -R 2_3 -i $in/dat.xt -o $out/${cmd}04.xt

#ۤι⤤˥٥Ȥ(󥷥)
xtbest -k Ź -s %nr -R 1 -q -i $in/dat.xt -o $out/${cmd}05.xt

#ۤι⤤˥٥Ȥ(ȿž,󥷥)
xtbest -k Ź -s %nr -r -R 1 -q -i $in/dat.xt -o $out/${cmd}06.xt

#ۤι⤤˥٥Ȥ(-kʤ,󥷥)
xtbest  -s %nr -R 1 -q -i $in/dat.xt -o $out/${cmd}07.xt

#ۤι⤤˥٥Ȥ(ȿž,-kʤ,󥷥)
xtbest -s %nr -r -R 1 -q -i $in/dat.xt -o $out/${cmd}08.xt

#---------------------------------------------------------------
cmd="xtbucket"
#---------------------------------------------------------------
#,ۤΥХå
xtbucket -f :̥Хå,:ۥХå -n 2 -i $in/dat.xt -o $out/${cmd}01.xt

#դ
xtbucket -k Ź -f :̥Хå,:ۥХå -n 2 -i $in/dat.xt -o $out/${cmd}02.xt

#n礭
xtbucket -f :̥Хå,:ۥХå -n 10 -i $in/dat.xt -o $out/${cmd}03.xt

#ս
xtbucket -f :̥Хå,:ۥХå -r -n 2 -i $in/dat.xt -o $out/${cmd}04.xt

#եޥå1
xtbucket -f :̥Хå,:ۥХå -F 1 -n 2 -i $in/dat.xt -o $out/${cmd}05.xt

#եޥå2
xtbucket -f :̥Хå,:ۥХå -F 2 -n 2 -i $in/dat.xt -o $out/${cmd}06.xt

#ϰϥե
xtbucket -f :̥Хå,:ۥХå -F 2 -n 2 -i $in/dat.xt -o $out/${cmd}07.xt -O $out/${cmd}08.xt

#ϰ϶Хå
xtbucket -f :̥Хå,:ۥХå -c rng -n 3 -i $in/dat.xt -o $out/${cmd}09.xt -O $out/${cmd}10.xt

#դ
xtbucket -k Ź -f :̥Хå,:ۥХå -n 2 -i $in/dat.xt -o $out/${cmd}11.xt -O $out/${cmd}12.xt

#---------------------------------------------------------------
cmd="xtcal"
#---------------------------------------------------------------
#黻ҴϢ
#---------------------------------------------------------------

#ۤ100ˤ(§Ρ)
xtcal -c '$+100' -a ɴ -i $in/dat.xt -o $out/${cmd}01.xt

#ۤ100߰ˤ(§Ρ)
xtcal -c '$-100' -a ɴ߰ -i $in/dat.xt -o $out/${cmd}02.xt

#ۤ3ܤˤ(§Ρ)
xtcal -c '$*3' -a ܶ -i $in/dat.xt -o $out/${cmd}03.xt

#ñФ(§Ρ)
xtcal -c '$/$' -a ñ -i $in/dat.xt -o $out/${cmd}04.xt

#ۤ500ߤ꾯ʤФ(ӱ黻Ρ)
xtcal -c '$<=500' -a 500߰ʲ -i $in/dat.xt -o $out/${cmd}05.xt

#ۤ500̤ɤ(ӱ黻Ρ)
xtcal -c '$<500' -a 500̤ -i $in/dat.xt -o $out/${cmd}06.xt

#500߰ʾΤΤȴФ(ӱ黻Ρ)
xtcal -c '$>=500' -a 500߰ʾ -i $in/dat.xt -o $out/${cmd}07.xt

#500ߤ礭Τ(ӱ黻Ρ)
xtcal -c '$>500' -a 500ߤ礭 -i $in/dat.xt -o $out/${cmd}08.xt

#500ߤǤ̵Τ(ӱ黻Ρ)
xtcal -c '$<>500' -a 500ߤǤϤʤ -i $in/dat.xt -o $out/${cmd}09.xt

#500ߤΤΤ(ӱ黻Ρ)
xtcal -c '$==500' -a 500ߤΤ -i $in/dat.xt -o $out/${cmd}10.xt

#2002ǯξȾɤ(ʸӤle)
xtcal -c '$ -le"20020531"' -a Ⱦ -i $in/dat.xt -o $out/${cmd}11.xt

#2002ǯξȾɤ(ʸӤlt)
xtcal -c '$ -lt"20020601"' -a Ⱦ -i $in/dat.xt -o $out/${cmd}12.xt

#2002ǯβȾɤ(ʸӤge)
xtcal -c '$ -ge"20020601"' -a Ⱦ -i $in/dat.xt -o $out/${cmd}13.xt

#2002ǯβȾɤ(ʸӤgt)
xtcal -c '$ -gt"20020531"' -a Ⱦ -i $in/dat.xt -o $out/${cmd}14.xt

#2002ǯΣΤΤ(ʸӤeq)
xtcal -c '$ -eq"20020926"' -a  -i $in/dat.xt -o $out/${cmd}15.xt

#2002ǯΣǤʤΤ(ʸӤne)
xtcal -c '$ -ne"20020926"' -a ʳ -i $in/dat.xt -o $out/${cmd}16.xt

#ۤ300߰ʲޤ500߰ʾΤΤ(黻Ρá)
xtcal -c '$>=500 || $<=300' -a 300߰ʲ500߰ʾ -i $in/dat.xt -o $out/${cmd}17.xt

#ۤ300߰ʾ夫500߰ʲΤΤ(黻Ρ)
xtcal -c '$<=500 && $>=300' -a 300߰ʾ塢500߰ʲ -i $in/dat.xt -o $out/${cmd}18.xt

#AŹǤΤ(ɽˤӱ黻)
xtcal -c '$Ź =~A' -a AŹǤ뤫ɤ -i $in/dat.xt -o $out/${cmd}19.xt

#ζۤФ
xtcal -c '($/$)*12'  -a 1 -i $in/dat.xt -o $out/${cmd}20.xt

#-----------------------------------------------------------------------------
#ؿ(ջִϢ)
#-----------------------------------------------------------------------------

#ǯ׻
xtcal -c 'age($,"19791106")' -a ǯ -i $in/dat.xt -o $out/${cmd}21.xt

#դѴ
xtcal -c 'datefmt($,"%Yǯ%M%D%j")' -a ǯ -i $in/dat.xt -o $out/${cmd}22.xt

#׻
xtcal -c 'dayadd($,92)' -a Ⱦǯ -i $in/dat.xt -o $out/${cmd}23.xt

#21äƤ
xtcal -c 'day($,"20010101")' -a 21ʸ -i $in/dat.xt -o $out/${cmd}24.xt

#֤Ѵ
xtcal -c 'timefmt($,"%H%Mʬ%S")' -a ʬ -i $in/dat.xt -o $out/${cmd}25.xt

#ÿʤ
xtcal -c 'timeadd($,10)' -a 2 -i $in/dat.xt -o $out/${cmd}26.xt

#ַ׻
xtcal -c 'time("055015",$)' -a ֺ -i $in/dat.xt -o $out/${cmd}27.xt

#դФ
#xtcal -c 'today()' -a  -i $in/dat.xt -o $out/${cmd}28.xt

#ߤλФ
#xtcal -c 'now()' -a λ -i $in/dat.xt -o $out/${cmd}29.xt

#--------------------------------------------------------------------------
#ؿ(ʹϢ)
#--------------------------------------------------------------------------

#ۤΣΰڤ夲 
xtcal -c 'up($,10)' -a 1ΰ̤ڤ夲 -i $in/dat.xt -o $out/${cmd}30.xt

#ۤΣΰڤΤ
xtcal -c 'down($,10)' -a ΰ̤ڤΤ -i $in/dat.xt -o $out/${cmd}31.xt

#ۤ1ΰ̤ͼθ 
xtcal -c 'round($,10)' -a 1ΰ̻ͼθ -i $in/dat.xt -o $out/${cmd}32.xt

#ۤʿ
xtcal -c 'sqrt($)' -a ۤʿ  -i $in/dat.xt -o $out/${cmd}33.xt

#ۤͤФ
#ǡζۤ˥ޥʥ̵ΤǺ
xtcal -c '$-400' -a  -i $in/dat.xt            |
#ͤη׻
xtcal -c 'abs($)' -a  -o $out/${cmd}34.xt

#̤ζҾ裳Ф
xtcal -c 'power($,3)' -a ̶Ҿ -i $in/dat.xt -o $out/${cmd}35.xt

#ۤ˿ͤ­
xtcal -c 'sum($,10,20)' -a ۡ -i $in/dat.xt -o $out/${cmd}36.xt

#̤ζҾ
xtcal -c 'exp($)' -a ۶ -i $in/dat.xt -o $out/${cmd}37.xt

#̤μп
xtcal -c 'ln($)' -a ̼п -i $in/dat.xt -o $out/${cmd}38.xt

#̤LOGФ
xtcal -c 'log($,5)' -a п -i $in/dat.xt -o $out/${cmd}39.xt

#̤LOGФ(2)
xtcal -c 'log2($)' -a п2 -i $in/dat.xt -o $out/${cmd}40.xt

#̤LOGФ()
xtcal -c 'log10($)' -a п10 -i $in/dat.xt -o $out/${cmd}41.xt

#ФФ
xtcal -c 'pi()' -a  -i $in/dat.xt -o $out/${cmd}42.xt

#
xtcal -c 'rand(100,10,2)' -a  -i $in/dat.xt -o $out/${cmd}43.xt

#ʬۤ˴Ť
xtcal -c 'nrand(100,20,2)' -a  -i $in/dat.xt -o $out/${cmd}44.xt

#ʲη·1
xtcal -c 'fixdec($2,0)' -a  -i $in/dat3.xt -o $out/${cmd}44-1.xt

#ʲη·2
xtcal -c 'fixdec($2,3)' -a  -i $in/dat3.xt -o $out/${cmd}44-2.xt

#ʲη·3
xtcal -c 'fixdec($2,6)' -a  -i $in/dat3.xt -o $out/${cmd}44-3.xt

#ڤ겼1
xtcal -c 'down($2,0.1)' -a  -i $in/dat3.xt -o $out/${cmd}44-4.xt

#ڤ겼2
xtcal -c 'down($2,0.000001)' -a  -i $in/dat3.xt -o $out/${cmd}44-5.xt

#ڤ겼3
xtcal -c 'down($2,1)' -a  -i $in/dat3.xt -o $out/${cmd}44-6.xt

#ڤ겼4
xtcal -c 'down($2,10)' -a  -i $in/dat3.xt -o $out/${cmd}44-7.xt

#ڤ겼5
xtcal -c 'down($2,1000)' -a  -i $in/dat3.xt -o $out/${cmd}44-8.xt

#ڤ夲1
xtcal -c 'up($2,0.1)' -a  -i $in/dat3.xt -o $out/${cmd}44-9.xt

#ڤ夲2
xtcal -c 'up($2,0.000001)' -a  -i $in/dat3.xt -o $out/${cmd}44-10.xt

#ڤ夲3
xtcal -c 'up($2,1)' -a  -i $in/dat3.xt -o $out/${cmd}44-11.xt

#ڤ夲4
xtcal -c 'up($2,10)' -a  -i $in/dat3.xt -o $out/${cmd}44-12.xt

#ڤ夲5
xtcal -c 'up($2,1000)' -a  -i $in/dat3.xt -o $out/${cmd}44-13.xt

#λͼθ1
xtcal -c 'round($2,0.1)' -a  -i $in/dat3.xt -o $out/${cmd}44-14.xt

#λͼθ2
xtcal -c 'round($2,0.000001)' -a  -i $in/dat3.xt -o $out/${cmd}44-15.xt

#λͼθ3
xtcal -c 'round($2,1)' -a  -i $in/dat3.xt -o $out/${cmd}44-16.xt

#λͼθ4
xtcal -c 'round($2,10)' -a  -i $in/dat3.xt -o $out/${cmd}44-17.xt

#λͼθ5
xtcal -c 'round($2,1000)' -a  -i $in/dat3.xt -o $out/${cmd}44-18.xt

#minؿ
xtcal -c 'min($1,$2)' -a min -i $in/dat3.xt -o $out/${cmd}44-19.xt
xtcal -c 'min($?)' -a min -i $in/dat3.xt -o $out/${cmd}44-20.xt

#maxؿ
xtcal -c 'max($1,$2)' -a max -i $in/dat3.xt -o $out/${cmd}44-21.xt
xtcal -c 'max($(*))' -a max -i $in/dat3.xt -o $out/${cmd}44-22.xt

#---------------------------------------------------------------
# ʸϢ
#---------------------------------------------------------------
#ջ֤礵
xtcal -c 'cat($,$,"/")' -a  -i $in/dat.xt -o $out/${cmd}45.xt

#ʸΥХȿФ
xtcal -c 'length($)' -a ʥХȿ -i $in/dat.xt -o $out/${cmd}46.xt

#Ĺʸˤ
xtcal -c 'fix("N","5","R","Y")' -a Ĺʸ -i $in/dat.xt -o $out/${cmd}47.xt

#ɽγϰ֥ޥå
xtcal -c 'regexStart($,BB)' -a ޥå -i $in/regedat.xt -o $out/${cmd}48.xt

#ɽνü֥ޥå
xtcal -c 'regexEnd($,AC)' -a ޥå -i $in/regedat.xt -o $out/${cmd}49.xt

#ɽΥޥåʸ
xtcal -c 'regexLen($,AC)' -a ޥåʸ -i $in/regedat.xt -o $out/${cmd}50.xt

#---------------------------------------------------------------
#Ϣ
#---------------------------------------------------------------
#IF
xtcal -c 'if($>400,Y,N)' -a 400ߤ礭ݤ -i $in/dat.xt -o $out/${cmd}51.xt

#NOT
xtcal -c 'not($>400)' -a 400ߤ礭 -i $in/dat.xt -o $out/${cmd}52.xt

#---------------------------------------------------------------
#ԹܴϢ
#---------------------------------------------------------------
#ιֹФ
xtcal -c 'line()' -a ֹ -i $in/dat.xt -o $out/${cmd}53.xt

#ܤοФ
xtcal -c 'fldCnt()' -a ܿ -i $in/dat.xt -o $out/${cmd}54.xt

#Կ
xtcal -k Ź -c 'keyLine()' -a  -i $in/dat.xt -o $out/${cmd}55.xt

#
xtcal -k Ź -c 'keyCnt()' -a  -i $in/dat.xt -o $out/${cmd}56.xt

#ʥС
xtcal -k Ź -c 'keyNo()' -a Ϣ -i $in/dat.xt -o $out/${cmd}57.xt

#йֹ(A)
xtcal -k Ź -c 'topField($)' -a Ƭξ -i $in/dat.xt -o $out/${cmd}58.xt


#йֹ(R)
xtcal -k Ź -c 'prvField($)' -a ξ -i $in/dat.xt -o $out/${cmd}59.xt

#йֹα黻
xtcal -k Ź -c 'if(keyLine()==1,1,prvResult()+1)' -a η̡ܣ -i $in/dat.xt -o $out/${cmd}60.xt

#йֹα黻
xtcal -k Ź -c 'if(keyLine()==1,1,topResult())' -a ƬԤη  -i $in/dat.xt -o $out/${cmd}61.xt

#---------------------------------------------------------------
cmd="xtcat"
#---------------------------------------------------------------
#ɸϢ
xtcat -n -i $in/dat.xt,$in/dat.xt -o $out/${cmd}01.xt

#ܿΰ㤦VER
xtcat -n -i $in/dat.xt,$in/dat1.xt -o $out/${cmd}02.xt

#Ⱦޤǡcat
xtcat -i $in/dat2.xt,$in/dat3.xt -o $out/${cmd}03.xt

#---------------------------------------------------------------
cmd="xtchgnum"
#---------------------------------------------------------------
#ۤ100̤,100~500̤,500ʾѴ
xtchgnum -f :ϰ -R MIN,300,500,MAX -v Low,Midium,High -i $in/dat.xt -o $out/${cmd}01.xt

#ۤ100̤,100~500̤,500ʾѴ(ʾ塢ʲǰ)
xtchgnum -f :ϰ -R MIN,300,500,MAX -v Low,Midium,High -r -i $in/dat.xt -o $out/${cmd}02.xt

#ۤ100̤,100~500̤,500ʾѴ(ܽ)
xtchgnum -f :ϰ -R MIN,300,500,MAX -v Low,Midium,High -A  -i $in/dat.xt -o $out/${cmd}03.xt

#ۤ100̤,100~500̤,500ʾѴ(ʾ塢ʲǰ,ܽ)
xtchgnum -f :ϰ -R MIN,300,500,MAX -v Low,Midium,High -r -A -i $in/dat.xt -o $out/${cmd}04.xt

#ۤ100̤,100~500̤,500ʾѴ(ϰϳ򤽤Τޤޤ)
xtchgnum -f :ϰ -R MIN,300,500 -v Low,High -F -i $in/dat.xt -o $out/${cmd}05.xt

#ۤ100̤,100~500̤,500ʾѴ(ʾ塢ʲǰ,ϰϳ򤽤Τޤޤ)
xtchgnum -f :ϰ -R MIN,300,500 -v Low,High -r -F -i $in/dat.xt -o $out/${cmd}06.xt

#ۤ100̤,100~500̤,500ʾѴ(ܽ,ϰϳ򤽤Τޤޤ)
xtchgnum -f :ϰ -R MIN,300,500 -v Low,High -A -F -i $in/dat.xt -o $out/${cmd}07.xt

#ۤ100̤,100~500̤,500ʾѴ(ʾ塢ʲǰ,ܽ,ϰϳ򤽤Τޤޤ)
xtchgnum -f :ϰ -R MIN,300,500 -v Low,High -r -A -F -i $in/dat.xt -o $out/${cmd}08.xt

#ۤ100̤,100~500̤,500ʾѴ(ϰϳ)
xtchgnum -f :ϰ -R MIN,300,500 -v Low,High -O  -i $in/dat.xt -o $out/${cmd}09.xt

#ۤ100̤,100~500̤,500ʾѴ(ʾ塢ʲǰ,ϰϳ)
xtchgnum -f :ϰ -R MIN,300,500 -v Low,High -r -O  -i $in/dat.xt -o $out/${cmd}10.xt

#ۤ100̤,100~500̤,500ʾѴ(ܽ,ϰϳ)
xtchgnum -f :ϰ -R MIN,300,500 -v Low,High -A  -O  -i $in/dat.xt -o $out/${cmd}11.xt

#ۤ100̤,100~500̤,500ʾѴ(ʾ塢ʲǰ,ܽ,ϰϳ)
xtchgnum -f :ϰ -R MIN,300,500 -v Low,High -r -A -O  -i $in/dat.xt -o $out/${cmd}12.xt

#---------------------------------------------------------------
cmd="xtchgstr"
#---------------------------------------------------------------
#Ź̾ѹ
xtchgstr -f Ź -c A:ŹNO1,B:ŹNO2,C:ŹNO3,D:ŹNO4 -i $in/dat.xt -o $out/${cmd}01.xt

#Ź̾ѹ(-OǳʤѴ)
xtchgstr -f Ź -c A:ŹNO1,B:ŹNO2,C:ŹNO3,D:ŹNO4 -O Ź -i $in/dat.xt -o $out/${cmd}02.xt

#Ź̾ѹ(-AǿܤȤƽ)
xtchgstr -f Ź:Ź̾ -c A:ŹNO1,B:ŹNO2,C:ŹNO3,D:ŹNO4 -A  -i $in/dat.xt -o $out/${cmd}03.xt

#Ź̾ѹ(-OǳʤѴ,AǿܤȤƽ))
xtchgstr -f Ź:Ź̾ -c A:ŹNO1,B:ŹNO2,C:ŹNO3,D:ŹNO4 -O Ź -A -i $in/dat.xt -o $out/${cmd}04.xt

#Ź̾ѹ
xtchgstr -f Ź -c A:ŹNO1,B:ŹNO2,C:ŹNO3,D:ŹNO4 -F  -i $in/dat.xt -o $out/${cmd}05.xt

#---------------------------------------------------------------
cmd="xtcombi"
#---------------------------------------------------------------
#ʥ2̤
xtcombi -k Ź -f  -n 2 -a 1,2 -i $in/dat.xt -o $out/${cmd}01.xt

#ʥ2̤
xtcombi -k Ź -f  -n 2 -a 1,2 -p -i $in/dat.xt -o $out/${cmd}02.xt

#ʥ2̤(ʤ)
xtcombi -f  -n 2 -a 1,2 -i $in/dat.xt -o $out/${cmd}03.xt

#ʥ2̤(ʤ)
xtcombi -f  -n 2 -a 1,2 -p -i $in/dat.xt -o $out/${cmd}04.xt

#ʥ2̤(󥷥)
xtcombi -k Ź -f  -n 2 -a 1,2 -q -i $in/dat.xt -o $out/${cmd}05.xt

#ʥ2̤
xtcombi -k Ź -f  -n 2 -a 1,2 -p -q -i $in/dat.xt -o $out/${cmd}06.xt

#ʥ2̤(ʤ)
xtcombi -f  -n 2 -a 1,2 -q -i $in/dat.xt -o $out/${cmd}07.xt

#ʥ2̤(ʤ)
xtcombi -f  -n 2 -a 1,2 -p -q -i $in/dat.xt -o $out/${cmd}08.xt

#---------------------------------------------------------------
cmd="xtcommon"
#---------------------------------------------------------------
#դ򥭡ˤƥ쥯
xtcommon -k  -m $in/dat1.xt -i $in/dat.xt -o $out/${cmd}01.xt

#դ򥭡ˤƥ쥯(ȿž)
xtcommon -k  -r -m $in/dat1.xt -i $in/dat.xt -o $out/${cmd}02.xt

#դ򥭡ˤƥ쥯()
xtcommon -k  -m $in/dat1.xt -u $out/${cmd}03u.xt -i $in/dat.xt -o $out/${cmd}03.xt

#դ򥭡ˤƥ쥯(,ȿž)
xtcommon -k  -r -m $in/dat1.xt -u $out/${cmd}04u.xt -i $in/dat.xt -o $out/${cmd}04.xt

#---------------------------------------------------------------
cmd="xtcount"
#---------------------------------------------------------------
#ʥ(Kꤢ)
xtcount -k  -a ʥ -i $in/dat.xt -o $out/${cmd}01.xt

#ʥ
xtcount  -a ʥ  -i $in/dat.xt -o $out/${cmd}02.xt

#ʥ(Kꤢ) 󥷥뽸
xtcount -k  -a ʥ -q -i $in/dat.xt -o $out/${cmd}03.xt

#ʥ 󥷥뽸
xtcount  -a ʥ -q -i $in/dat.xt -o $out/${cmd}04.xt

#---------------------------------------------------------------
cmd="xtcut"
#---------------------------------------------------------------
#ѥ᡼-fΤ
xtcut -f Ź, -i $in/dat.xt -o $out/${cmd}01.xt

#ѥ᡼-rդ
xtcut -f Ź, -r -i $in/dat.xt -o $out/${cmd}02.xt

#ѥ᡼-zդ
xtcut -f Ź, -i $in/dat.xt -z -o $out/${cmd}03.xt.gz

#ѥ᡼-f,-zդ
xtcut -f Ź, -r -i $in/dat.xt  -z -o $out/${cmd}04.xt.gz

#̾ν
xtcut -f Ź:Ź,: -i $in/dat.xt -o $out/${cmd}05.xt

#ȾȿǤ뤫1
xtsort -k Ź,%rn -i $in/dat.xt |
xtcut -f Ź,, -o $out/${cmd}06.xt

#ȾȿǤ뤫2
xtsort -k Ź,%rn -i $in/dat.xt |
xtcut -f , -o $out/${cmd}07.xt

#ȾȿǤ뤫2
xtsort -k Ź,%rn -i $in/dat.xt |
xtcut -f Ź,, -o $out/${cmd}08.xt

#---------------------------------------------------------------
cmd="xtdelnul"
#---------------------------------------------------------------
#̡ۤΡ
xtdelnul -f , -i $in/dat.xt -o $out/${cmd}01.xt

#̡ۤΡ()
xtdelnul -f , -r -i $in/dat.xt -o $out/${cmd}02.xt

#̡ۤΡ(ܴAND)
xtdelnul -f , -F -i $in/dat.xt -o $out/${cmd}03.xt

#̡ۤΡ(,ܴAND)
xtdelnul -f , -r -F -i $in/dat.xt -o $out/${cmd}04.xt

#̡ۤΡ(ԴAND)
xtdelnul -f , -R -i $in/dat.xt -o $out/${cmd}05.xt

#̡ۤΡ(,ԴAND)
xtdelnul -f , -r -R -i $in/dat.xt -o $out/${cmd}06.xt

#̡ۤΡ(,-kǻ)
xtdelnul -k Ź -f , -i $in/dat.xt -o $out/${cmd}07.xt

#̡ۤΡ(,-kǻ)
xtdelnul -k Ź -f , -r -i $in/dat.xt -o $out/${cmd}08.xt

#̡ۤΡ(ܴAND,-kǻ)
xtdelnul -k Ź -f , -F -i $in/dat.xt -o $out/${cmd}09.xt

#̡ۤΡ(,ܴAND,-kǻ)
xtdelnul -k Ź -f , -r -F -i $in/dat.xt -o $out/${cmd}10.xt

#̡ۤΡ(ԴAND,-kǻ)
xtdelnul -k Ź -f , -R -i $in/dat.xt -o $out/${cmd}11.xt

#̡ۤΡ(,ԴAND,-kǻ)
xtdelnul -k Ź -f , -r -R -i $in/dat.xt -o $out/${cmd}12.xt

#̡ۤΡ(󥷥)
xtdelnul -f , -q -i $in/dat.xt -o $out/${cmd}13.xt

#̡ۤΡ(,󥷥)
xtdelnul -f , -r -q -i $in/dat.xt -o $out/${cmd}14.xt

#̡ۤΡ(ܴAND,󥷥)
xtdelnul -f , -F -q -i $in/dat.xt -o $out/${cmd}15.xt

#̡ۤΡ(,ܴAND,󥷥)
xtdelnul -f , -r -F -q -i $in/dat.xt -o $out/${cmd}16.xt

#̡ۤΡ(ԴAND,󥷥)
xtdelnul -f , -R -i $in/dat.xt -o $out/${cmd}17.xt

#̡ۤΡ(,ԴAND,󥷥)
xtdelnul -f , -r -R -q -i $in/dat.xt -o $out/${cmd}18.xt

#̡ۤΡ(󥷥,-kǻ)
xtdelnul -k Ź -f , -q -i $in/dat.xt -o $out/${cmd}19.xt

#̡ۤΡ(,-kǻ,󥷥)
xtdelnul -k Ź -f , -q -r -i $in/dat.xt -o $out/${cmd}20.xt

#̡ۤΡ(ܴAND,-kǻ,󥷥)
xtdelnul -k Ź -f , -F -q -i $in/dat.xt -o $out/${cmd}21.xt

#̡ۤΡ(,ܴAND,-kǻ,󥷥)
xtdelnul -k Ź -f , -r -F -q -i $in/dat.xt -o $out/${cmd}22.xt

#̡ۤΡ(ԴAND,-kǻ,󥷥)
xtdelnul -k Ź -f , -R -q -i $in/dat.xt -o $out/${cmd}23.xt

#̡ۤΡ(,ԴAND,-kǻ,󥷥)
xtdelnul -k Ź -f , -r -R -q -i $in/dat.xt -o $out/${cmd}24.xt

#---------------------------------------------------------------
cmd="xtduprec"
#---------------------------------------------------------------
xtduprec -f  -i $in/dat.xt -o $out/${cmd}01.xt 

#---------------------------------------------------------------
cmd="xtheader"
#---------------------------------------------------------------
#إåդ
xtcut -f Ź,  -i $in/dat.xt                     |
xtheader -a Ź, -l "ȥ" -c "" -o $out/${cmd}01.xt

#---------------------------------------------------------------
cmd="xtjoin"
#---------------------------------------------------------------
#祤󤹤
xtjoin -k Ź -m $in/dat1.xt -f 뺧,Ҷ -i $in/dat.xt -o $out/${cmd}01.xt

#---------------------------------------------------------------
cmd="xtmkdata"
#---------------------------------------------------------------
#ǡο
xtmkdata -c 'rand(0,100,1)' -a ̾ -l 100 -o $out/${cmd}01.xt

#---------------------------------------------------------------
cmd="xtnrcommon"
#---------------------------------------------------------------
#ϰ
#ϰϷ
xtnrcommon -k no1 -v no2%n -m $in/dat6.xt -R r1,r2 -i $in/dat5.xt -o $out/${cmd}01.xts

#ȿž
xtnrcommon -k no1 -v no2%n -m $in/dat6.xt -R r1%n,r2%e -i $in/dat5.xt -o $out/${cmd}02.xts -u $out/${cmd}03.xts

#ξ
xtnrcommon -k no1 -v no2%n -m $in/dat6.xt -R r1%e,r2%e -i $in/dat5.xt -o $out/${cmd}04.xts -u $out/${cmd}05.xts

#ξnot
xtnrcommon -k no1 -v no2%n -m $in/dat6.xt -R r1%n,r2%n -i $in/dat5.xt -o $out/${cmd}06.xts -u $out/${cmd}07.xts

#ʸϰϷ
xtnrcommon -k no1 -v no2   -m $in/dat6.xt -R r1,r2 -i $in/dat5.xt -o $out/${cmd}08.xts -u $out/${cmd}09.xts

#ȿž
xtnrcommon -k no1 -v no2   -m $in/dat6.xt -R r1%n,r2%e -i $in/dat5.xt -o $out/${cmd}10.xts -u $out/${cmd}11.xts

#ȿž(-r)
xtnrcommon -k no1 -v no2%n -m $in/dat6.xt -R r1,r2 -i $in/dat5.xt -o $out/${cmd}11.xts -u $out/${cmd}12.xts -r



#---------------------------------------------------------------
cmd="xtrjoin"
#---------------------------------------------------------------
#ϰϼ
#ϰϷ
xtrjoin -k no1 -v no2%n -m $in/dat7.xt -R r -f v1,v2 -i $in/dat5.xt -o $out/${cmd}01.xt

# -n
xtrjoin -k no1 -v no2%n -m $in/dat7.xt -R r -f v1,v2 -i $in/dat5.xt -n -o $out/${cmd}02.xt

# -N
xtrjoin -k no1 -v no2%n -m $in/dat7.xt -R r -f v1,v2 -i $in/dat5.xt -N -o $out/${cmd}03.xt

# -nN
xtrjoin -k no1 -v no2%n -m $in/dat7.xt -R r -f v1,v2 -i $in/dat5.xt -nN -o $out/${cmd}04.xt

#ʸȤ
xtrjoin -k no1 -v no2 -m $in/dat7.xt -R r -f v1,v2 -i $in/dat5.xt -nN -o $out/${cmd}05.xt

#ʤ
xtrjoin -v no2%n -m $in/dat7.xt -R r -f v1,v2 -i $in/dat5.xt -o $out/${cmd}06.xt

#ʤ(ʸȤ)
xtrjoin -v no2 -m $in/dat7.xt -R r -f v1,v2 -i $in/dat5.xt -o $out/${cmd}07.xt

#---------------------------------------------------------------
cmd="xtnrjoin"
#---------------------------------------------------------------
#ϰϼ
#ϰϷ
xtnrjoin -k no1 -v no2%n -m $in/dat6.xt -R r1,r2 -f v1,v2 -i $in/dat5.xt -o $out/${cmd}01.xts

#ȿž
xtnrjoin -k no1 -v no2%n -m $in/dat6.xt -R r1%n,r2%e -f v1,v2 -i $in/dat5.xt -o $out/${cmd}02.xts

#ξ
xtnrjoin -k no1 -v no2%n -m $in/dat6.xt -R r1%e,r2%e -f v1,v2 -i $in/dat5.xt -o $out/${cmd}03.xts

#ξnot
xtnrjoin -k no1 -v no2%n -m $in/dat6.xt -R r1%n,r2%n -f v1,v2 -i $in/dat5.xt -o $out/${cmd}04.xts


# -n
xtnrjoin -k no1 -v no2%n -m $in/dat6.xt -R r1,r2 -f v1,v2 -i $in/dat5.xt -o $out/${cmd}05.xts -n

# -nN
xtnrjoin -k no1 -v no2%n -m $in/dat6.xt -R r1,r2 -f v1,v2 -i $in/dat5.xt -o $out/${cmd}06.xts -nN

# -N
xtnrjoin -k no1 -v no2%n -m $in/dat6.xt -R r1,r2 -f v1,v2 -i $in/dat5.xt -o $out/${cmd}07.xts -N

# ʤ
xtnrjoin -v no2%n -m $in/dat6.xt -R r1,r2 -f v1,v2 -i $in/dat5.xt -o $out/${cmd}08.xts

#ʸȤ
xtnrjoin -k no1 -v no2 -m $in/dat6.xt -R r1,r2 -f v1,v2 -i $in/dat5.xt -o $out/${cmd}09.xts

#---------------------------------------------------------------
cmd="xtnjoin"
#---------------------------------------------------------------
#礵
xtnjoin -k Ź -m $in/dat1.xt -f 뺧,Ҷ -i $in/dat.xt -o $out/${cmd}01.xt

#---------------------------------------------------------------
cmd="xtnulto"
#---------------------------------------------------------------
#NULLѴ
xtnulto -f , -v 0 -i $in/dat.xt -o $out/${cmd}01.xt

#-O
xtnulto -f , -v NULL -O notNULL -i $in/dat.xt -o $out/${cmd}02.xt

#-A
xtnulto -f :NULL,:NULL -v NULL -A -i $in/dat.xt -o $out/${cmd}03.xt

#-O,-A
xtnulto -f :NULL,:NULL -v NULL -O notNULL -A -i $in/dat.xt -o $out/${cmd}04.xt

#---------------------------------------------------------------
cmd="xtnumber"
#---------------------------------------------------------------
#ۤι⤤˥
#ۤФֹդ
xtnumber -s %nr -a ۽ -i $in/dat.xt -o $out/${cmd}01.xt

#ۤι⤤˥
#ۤФֹդ
xtnumber -q  -a ۽ -i $in/dat.xt -o $out/${cmd}02.xt

#Ʊ̤Ʊֹ
xtnumber -e same -k Ź -s 1%n -a new -i $in/dat3.xt -o $out/${cmd}03.xt

#Ʊ̤Ʊֹǡν̤Ͻʣʬå
xtnumber -e skip -k Ź -s 1%n -a new -i $in/dat3.xt -o $out/${cmd}04.xt

#Ʊ̤Ʊֹ
xtnumber -e same -k 1 -s Ź%r -a new -i $in/dat3.xt -o $out/${cmd}05.xt

#Ʊ̤Ʊֹǡν̤Ͻʣʬå
xtnumber -e skip -k 1 -s Ź%r -a new -i $in/dat3.xt -o $out/${cmd}06.xt

#Ϣ
xtnumber -k Ź -B -a new -i $in/dat3.xt -o $out/${cmd}07.xt

#---------------------------------------------------------------
cmd="xtpattern"
#---------------------------------------------------------------
#ʤϢ뤷ƣĤʸˤ
xtpattern -s Ź -f :ʥѥ -i $in/dat.xt -o $out/${cmd}01.xt

#ʤϢ뤷ƣĤʸˤ(󥷥)
xtpattern -s Ź -f :ʥѥ -q -i $in/dat.xt -o $out/${cmd}02.xt

#---------------------------------------------------------------
cmd="xtproduct"
#---------------------------------------------------------------
#ľѷ
xtproduct -m $in/dat1.xt -f 뺧,Ҷ -i $in/dat.xt -o $out/${cmd}01.xt

#---------------------------------------------------------------
cmd="xtrand"
#---------------------------------------------------------------
#ȯ
xtrand -S 10 -a  -i $in/dat.xt -o $out/${cmd}01.xt

#ȯ
xtrand -S 10 -M 10000 -a  -i $in/dat.xt -o $out/${cmd}02.xt

#ȯ
xtrand -S 10 -M 10000 -C 10 -a  -i $in/dat.xt -o $out/${cmd}03.xt

#---------------------------------------------------------------
cmd="xtsed"
#---------------------------------------------------------------
#ʥɤ18Ѵ
xtsed -f  -c 'AA*' -v '##' -i $in/regedat.xt -o $out/${cmd}01.xt

#ʥɤ18Ѵ
xtsed -f  -c '^A' -v '(&)' -i $in/regedat.xt -o $out/${cmd}02.xt

xtsed -f  -c 'A.A' -v 'A' -g -i $in/regedat.xt -o $out/${cmd}03.xt

#---------------------------------------------------------------
cmd="xtsel"
#---------------------------------------------------------------
#Ｐ==ȤäVER.
xtsel -k Ź -c '$==500' -i $in/dat.xt -o $out/${cmd}01.xt

#Ｐ<ȤäVER
xtsel -k Ź -c '$<500' -i $in/dat.xt -o $out/${cmd}02.xt

#Ｐ<=ȤäVER
xtsel -k Ź -c '$<=500' -i $in/dat.xt -o $out/${cmd}03.xt

#Ｐ>ȤäVER.
xtsel -k Ź -c '$>500' -i $in/dat.xt -o $out/${cmd}04.xt

#Ｐ>=ȤäVER
xtsel -k Ź -c '$>=500' -i $in/dat.xt -o $out/${cmd}05.xt

#Ｐ<>ȤäVER
xtsel -k Ź -c '$<>500' -i $in/dat.xt -o $out/${cmd}06.xt

#Ｐ-eqȤäVER
xtsel -k Ź -c '$-eq500' -i $in/dat.xt -o $out/${cmd}07.xt

#Ｐ-gtȤäVER
xtsel -k Ź -c '$-gt500' -i $in/dat.xt -o $out/${cmd}08.xt

#Ｐ-geȤäVER
xtsel -k Ź -c '$-ge500' -i $in/dat.xt -o $out/${cmd}09.xt

#Ｐ-ltȤäVER
xtsel -k Ź -c '$-lt500' -i $in/dat.xt -o $out/${cmd}10.xt

#Ｐ-leȤäVER
xtsel -k Ź -c '$-le500' -i $in/dat.xt -o $out/${cmd}11.xt

#Ｐ-neȤäVER
xtsel -k Ź -c '$-ne500' -i $in/dat.xt -o $out/${cmd}12.xt

#Ｐ||ȤäVER
xtsel -k Ź -c '$<300 || $>=500' -i $in/dat.xt -o $out/${cmd}13.xt

#Ｐ&&ȤäVER
xtsel -k Ź -c '$>300 && $<=500' -i $in/dat.xt -o $out/${cmd}14.xt

#Ｐ=~ȤäVER
xtsel  -c '$=~5' -r -i $in/dat.xt -o $out/${cmd}15.xt

#Ｐ==ȤäVER.-Rդ
xtsel -k Ź -c '$==1,==459' -R -i $in/dat.xt -o $out/${cmd}16.xt

#---------------------------------------------------------------
cmd="xtselstr"
#---------------------------------------------------------------
#ꤷʸޤԤ
xtselstr -f 뺧 -v O -i $in/dat1.xt -o $out/${cmd}01.xt

#ꤷʸޤԤ(ܴAND)
xtselstr -f 뺧,Ҷ -v O  -F -i $in/dat1.xt -o $out/${cmd}02.xt

#ꤷʸޤԤ(ԴAND)
xtselstr -f 뺧 -v O  -R -i $in/dat1.xt -o $out/${cmd}03.xt

#ꤷʸޤԤ(ץKդVER)
xtselstr -k Ź -f 뺧 -v O -i $in/dat1.xt -o $out/${cmd}04.xt

#ꤷʸޤԤ(ܴAND,ץKդVER)
xtselstr -k Ź -f 뺧,Ҷ -v O -i $in/dat1.xt -o $out/${cmd}05.xt

#ꤷʸޤԤ(ԴAND,ץKդVER)
xtselstr -k Ź -f 뺧 -v O -i $in/dat1.xt -o $out/${cmd}06.xt

#ꤷʸޤԤ(-rդVER.)
xtselstr -f 뺧 -v O -r -i $in/dat1.xt -o $out/${cmd}07.xt

#ꤷʸޤԤ(ܴAND,-rդVER.)
xtselstr -f 뺧,Ҷ -v O -r -F -i $in/dat1.xt -o $out/${cmd}08.xt

#ꤷʸޤԤ(ԴAND,-rդVER)
xtselstr -f 뺧 -v O  -R -i $in/dat1.xt -o $out/${cmd}09.xt

#ꤷʸޤԤ(ץKդVER-rդVER.)
xtselstr -k Ź -f 뺧 -v O -i $in/dat1.xt -o $out/${cmd}10.xt

#ꤷʸޤԤ(ܴAND,ץKդVER-rդVER.)
xtselstr -k Ź -f 뺧,Ҷ -v O -i $in/dat1.xt -o $out/${cmd}11.xt

#ꤷʸޤԤ(ԴAND,ץKդVER -rդVER)
xtselstr -k Ź -f 뺧 -v O -i $in/dat1.xt -o $out/${cmd}12.xt

#ꤷʸޤԤ(󥷥)
xtselstr -f 뺧 -v O -q -i $in/dat1.xt -o $out/${cmd}13.xt

#ꤷʸޤԤ(ܴAND,󥷥)
xtselstr -f 뺧,Ҷ -v O  -F -q -i $in/dat1.xt -o $out/${cmd}14.xt

#ꤷʸޤԤ(ԴAND,󥷥)
xtselstr -f 뺧 -v O  -R -q -i $in/dat1.xt -o $out/${cmd}15.xt

#ꤷʸޤԤ(ץKդVER,󥷥)
xtselstr -k Ź -f 뺧 -v O -q -i $in/dat1.xt -o $out/${cmd}16.xt

#ꤷʸޤԤ(ܴAND,ץKդVER󥷥)
xtselstr -k Ź -f 뺧,Ҷ -v O -q -i $in/dat1.xt -o $out/${cmd}17.xt

#ꤷʸޤԤ(ԴAND,ץKդVER󥷥)
xtselstr -k Ź -f 뺧 -v O -q -i $in/dat1.xt -o $out/${cmd}18.xt

#ꤷʸޤԤ(-rդVER.󥷥)
xtselstr -f 뺧 -v O -r -q -i $in/dat1.xt -o $out/${cmd}19.xt

#ꤷʸޤԤ(ܴAND,-rդVER.󥷥)
xtselstr -f 뺧,Ҷ -v O -r -F -q -i $in/dat1.xt -o $out/${cmd}20.xt

#ꤷʸޤԤ(ԴAND,-rդVER󥷥)
xtselstr -f 뺧 -v O  -R -q -i $in/dat1.xt -o $out/${cmd}21.xt

#ꤷʸޤԤ(ץKդVER-rդVER.󥷥)
xtselstr -k Ź -f 뺧 -v O -q -i $in/dat1.xt -o $out/${cmd}22.xt

#ꤷʸޤԤ(ܴAND,ץKդVER-rդVER.󥷥)
xtselstr -k Ź -f 뺧,Ҷ -v O -q -i $in/dat1.xt -o $out/${cmd}23.xt

#ꤷʸޤԤ(ԴAND,ץKդVER -rդVER󥷥)
xtselstr -k Ź -f 뺧 -v O -q -i $in/dat1.xt -o $out/${cmd}24.xt

#---------------------------------------------------------------
cmd="xtsep"
#---------------------------------------------------------------
#եʬ
xtsep -d $out/${cmd}01-'$(Ź).xt' -i $in/dat.xt   

#եʬ(2)
xtsep -d $out/${cmd}02-'$(Ź)-$().xt' -i $in/dat.xt   

#եʬ(2ܤäĤ)
xtsep -d $out/${cmd}03-'$(Ź)$().xt' -i $in/dat.xt   

#եʬ(2̤ܳʤ)
xtsep -d $out/${cmd}04-'$Ź$().xt' -i $in/dat.xt   

#---------------------------------------------------------------
cmd="xtsetchr"
#---------------------------------------------------------------
#ʸɲä
xtsetchr -v 2002ǯ1010 -a  -i $in/dat.xt -o $out/${cmd}01.xt

#---------------------------------------------------------------
cmd="xtshare"
#---------------------------------------------------------------
#Źο̶ۥ
xtshare -k Ź -f :̥,:ۥ -i $in/dat.xt -o $out/${cmd}01.xt

#Źο̶ۥ(NULLVER)
xtnulto -f , -v 0 -i $in/dat.xt |
xtshare -k Ź -f :̥,:ۥ  -o $out/${cmd}02.xt

#---------------------------------------------------------------
cmd="xtslide"
#---------------------------------------------------------------
#ե饤
xtslide -k Ź -f : -s  -i $in/dat.xt -o $out/${cmd}01.xt

#ե饤(-nȤäVER)
xtslide -k Ź -f : -s  -n -i $in/dat.xt -o $out/${cmd}02.xt

#---------------------------------------------------------------
cmd="xtsort"
#---------------------------------------------------------------
#-kΥѥ᡼ʤVER
xtsort -k ,  -i $in/dat.xt -o $out/${cmd}01.xt

#%nͿVER
xtsort -k %n,%n  -i $in/dat.xt -o $out/${cmd}02.xt

#%rͿVER.
xtsort -k %r,%r  -i $in/dat.xt -o $out/${cmd}03.xt

#ξ%nrVER.
xtsort -k %nr,%nr  -i $in/dat.xt -o $out/${cmd}04.xt

#%nrVER.
xtsort -k ,%nr  -i $in/dat.xt -o $out/${cmd}05.xt

#---------------------------------------------------------------
cmd="xtstatistics"
#---------------------------------------------------------------
#VAR
xtstatistics -k Ź -f , -c var -i $in/dat.xt -o $out/${cmd}01.xt

#std
xtstatistics -k Ź -f , -c std -i $in/dat.xt -o $out/${cmd}02.xt

#VAR(󥷥)
xtstatistics -k Ź -f , -q -c var -i $in/dat.xt -o $out/${cmd}03.xt

#std(󥷥)
xtstatistics -k Ź -f , -q -c std -i $in/dat.xt -o $out/${cmd}04.xt

#---------------------------------------------------------------
cmd="xtsubstr"
#---------------------------------------------------------------
#֤ʬˤ
xtsubstr -f :ʬ -R 1_4 -i $in/dat.xt -o $out/${cmd}01.xt

#ϰϻʣVER.
xtsubstr -f :ʬ -R 1_2,4_6 -i $in/dat.xt -o $out/${cmd}02.xt

#ϰϻMAXĤäVER
xtsubstr -f :ʬ -R 1_2,4_MAX -i $in/dat.xt -o $out/${cmd}03.xt

#֤ʬˤ
xtsubstr -f :ʬ -R 1_4 -A -i $in/dat.xt -o $out/${cmd}04.xt

#ϰϻʣVER.
xtsubstr -f :ʬ -R 1_2,4_6 -A -i $in/dat.xt -o $out/${cmd}05.xt

#ϰϻMAXĤäVER
xtsubstr -f :ʬ -R 1_2,4_MAX -A -i $in/dat.xt -o $out/${cmd}06.xt

#---------------------------------------------------------------
cmd="xtuniq"
#---------------------------------------------------------------
#ŹUNIQ
xtuniq -k Ź -i $in/dat.xt -o $out/${cmd}01.xt

#ŹUNIQ(ʣVER.)
xtuniq -k Ź, -i $in/dat.xt -o $out/${cmd}02.xt

#ŹUNIQ(󥷥)
xtuniq -k Ź -q -i $in/dat.xt -o $out/${cmd}03.xt

#ŹUNIQ(ʣVER.,󥷥)
xtuniq -k Ź, -q -i $in/dat.xt -o $out/${cmd}04.xt

#---------------------------------------------------------------
#̾λˤĤƤΤޤޤʥå
cmd="fldchk"
#---------------------------------------------------------------
#̾
xtcut -f '*:val(&)' -i $in/dat3.xt -o $out/${cmd}01.xt

##===============================================================
