#!/usr/bin/env bash

#実行ビットが落ちる問題を修正 2004/10/12

echo 'UTF-8に変換するスクリプト'
#==============================================================================
#圧縮ファイルは変換できないので解凍し変換後,再圧縮
#==============================================================================
find ./ -type f        |
sed '/euc2utf8/d' >xmaster

echo '#gzファイルを抽出'
grep .gz <xmaster     |
sed 's/^[0-9].* //g' >gzfile

sed 's/.gz//g' <gzfile |
sed 's/^/> /g' >xxb1sub

sed 's/^/gunzip -c </g' <gzfile >xxbsub

paste -d ' ' xxbsub xxb1sub >xgun.sh

rm xx*

echo '#圧縮ファイルを解凍する'
bash xgun.sh

echo '#解凍前の圧縮ファイル削除'
sed 's/^/rm /g'<gzfile  >xxrm.sh

bash xxrm.sh
rm x*

#==============================================================================
echo '#encoding="euc-jp"をencoding="UTF-8"に変換'
#==============================================================================
#euc-jpを含むファイル名を出力
grep -lr euc-jp * |
sed '/euc2utf8.sh/d' >xmaster2

sed "s/^/sed \'s\/encoding=\"euc-jp\"\/encoding=\"UTF-8\"\/g' </g" <xmaster2 >xsedfront
sed 's/^/>/g' <xmaster2  |
sed 's/$/taka/g' >xsedback

paste -d ' ' xsedfront xsedback >xsed.sh

bash xsed.sh

sed 's/^/rm /g' <xmaster2 >xsedrm.sh

echo '#変換前のファイルを削除'
bash xsedrm.sh

sed 's/$/taka/g' <xmaster2 |
sed 's/^/mv /g' >xmvfront

paste -d ' ' xmvfront xmaster2 >xmvchg.sh
bash xmvchg.sh

rm x*
#==============================================================================
echo '#文字コードEUCからUTF8の変換'
#==============================================================================
#ディレクトリを省くファイル全てのパス
find ./ -type f |
sed '/euc2utf8/d' |
sed '/master/d'   >master

#nkf -Ew <./file >./filetakaのような形式に変換
sed 's/^/nkf -Ew </g' <master >xxfront

sed 's/$/taka/g' <master          |
sed 's/^/> /g' >xxbmback

paste -d ' ' xxfront xxbmback  >xchgchar.sh

echo '#UTF8に変換'
bash xchgchar.sh

#変換前のファイルを削除
sed 's/^/rm /' <master > xrmast.sh

bash xrmast.sh

rm x*

#変換後のファイルを元のファイル名に変換
sed 's/$/taka/g' <master               |
sed 's/^/mv /g' >xxbmfront2

paste -d ' ' xxbmfront2 master  >xchgmv.sh
bash xchgmv.sh

rm xx*
#==============================================================================
echo '#解凍したファイルを再圧縮'
#==============================================================================
sed 's/^/> /g' <gzfile >gzback

sed 's/.gz//g' <gzfile |
sed 's/^/gzip -c </g' > xgzfront

paste -d ' ' xgzfront gzback >xgzchg.sh
bash xgzchg.sh

sed 's/^/rm /g' <gzfile |
sed 's/.gz//g' >xrmgz.sh

bash xrmgz.sh

rm x*
rm gz*
rm master

#==============================================================================
#アクセス権を755に変換
#==============================================================================
find ./ -name "*sh" -exec chmod 755 {} \;

