#!/usr/bin/env bash
 
#*****************************************************************************
# xtabc.sh version 1.0b
# ABCʬϥץ
# Y.Hamuro
# 2004/05/17
# 2004/12/06 -k б,ȥåɲ(1.0)
#*****************************************************************************
 
function help {
cat >/dev/stderr <<EOF
--------------------------
xtabc.sh version 1.0
--------------------------
) ABCʬϤԤ
) xtabc.sh [-k ܥꥹ] -f оݹ̾ [-R ϰ] [-v ̾]
                  [-d Ϥͭ]
                  [-i ϥե̾] [-oϥե̾]
                  [-T ǥ쥯ȥ̾] [-V] [-h]
        -V : ޥɤδλåɽ롣
        -h : إפɽ
        -RΥǥե : MIN,70,90,MAX
        -vΥǥե : A,B,C 
        -dΥǥե : 0.01

1) xtabc.sh -f  -i input.xt -o output.xt
1) xtabc.sh -k Ź -f  -i input.xt -o output.xt
2) xtabc.sh -f  -R 0,0.4,0.6,0.9,MAX -v A,B,C,D -i input2.xt -o output2.xt

1ϥǡ
--------------
input.xt
--------------
ܵID 
a 10
b 50
c 20
d 30
e 12
f 15
--------------
output.xt
--------------
ܵID  accmCnt accmCntShr accmVal accmValShr rank
b 50 1 16.67  50 36.5  A
d 30 2 33.33  80 58.39 A
c 20 3 50    100 72.99 B
f 15 4 66.67 115 83.94 B
e 12 5 83.33 127 92.7  C
a 10 6 100   137 100   C
--------------
EOF
exit 1
}

#ǥեȤǤϡޥɤΥåOFF
export mssQuiet=1

#λåѤ˥ޥɥ饤¸
cmdLine="$0 $*"

#ʥˤ뽪λ
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

KEY="#same#"

#ѥ᡼Υåå
while getopts ":k:f:R:v:i:o:T:Vh" opt; do
  case $opt in
    k  ) KEY=$OPTARG ;;
    f  ) FLD=$OPTARG ;;
    R  ) RNG=$OPTARG ;;
    v  ) VAL=$OPTARG ;;
    d  ) DEC=$OPTARG ;;
    i  ) INPUT=$OPTARG ;;
    o  ) OUTPUT=$OPTARG ;;
    T  ) TMPD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))
                                                                                
if [ "$FLD" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$RNG" = "" ]; then
  RNG=MIN,70,90,MAX
fi
if [ "$VAL" = "" ]; then
  VAL=A,B,C
fi
if [ "$NAM" = "" ]; then
  NAM=ѷ,ѷ,$FLD,$FLD,
fi
if [ "$DEC" = "" ]; then
  DEC=0.01
fi
if [ "$INPUT" = "" ]; then
   INPUT=/dev/stdin
fi
if [ "$OUTPUT" = "" ]; then
 OUTPUT=/dev/stdout
fi
if [ "$TMPD" = "" ]; then
   TMPD=/tmp
fi

# ̾Υå
NAM1=accmCnt
NAM2=accmCntShr
NAM3=accmVal
NAM4=accmValShr
NAM5=rank

#ե̾
TD=$TMPD/xtabc-$$

#ȥåȯư
trap endByInt INT QUIT TERM HUP

#=====================================================
# ڥƥåף
# ǡԤѤȽ̤Ƥ
#-----------------------------------------------------
#ܵҤΥǡֹѤȽ̤Ƥ
xtsetchr -v 1 -a "##seq##" -i $INPUT |
xtaccum  -k $KEY -s "$FLD%rn" -f "$FLD:##fldAccm##,##seq##:##seqAccm##" -o $TD-xxa

#ȥιפȺǽ(ܵҿ)
xtagg -k $KEY -f "$FLD:##fldSum##,##seq##:##seqSum##" -c sum -i $TD-xxa -o $TD-xxs

#嵭ĤJOINȥѡΣ󤭤ߤˤܵҤ򣱣ʬ䤹
xtjoin -k $KEY -m $TD-xxs -f "##fldSum##,##seqSum##" -i $TD-xxa |
xtcal -c 'round(100*$##seqAccm##/$##seqSum##,'$DEC')' -a "##seqRatio##" |
xtcal -c 'round(100*$##fldAccm##/$##fldSum##,'$DEC')' -a "##fldRatio##" |
xtchgnum -f "##fldRatio##:##rank##" -R $RNG -v $VAL -A -o $TD-xxb

if [ "$KEY" = "#same#" ] ; then
  xtcal -q -k $FLD -c 'if(keyLine()==1,$##rank##,if(prvField($'$FLD') -eq $'$FLD' && prvResult() -ne $##rank##,prvResult(),$##rank##))' -a "##rank2##" -i $TD-xxb -o $TD-xxc
else
  xtcal -q -k $KEY,$FLD -c 'if(keyLine()==1,$##rank##,if(prvField($'$FLD') -eq $'$FLD' && prvResult() -ne $##rank##,prvResult(),$##rank##))' -a "##rank2##" -i $TD-xxb -o $TD-xxc
fi

xtcut -f '*,##seqAccm##:'$NAM1',##seqRatio##:'$NAM2',##fldAccm##:'$NAM3',##fldRatio##:'$NAM4',##rank2##:'$NAM5 -i $TD-xxc |
xtcut -r -f '##seq##,##seqAccm##,##fldAccm##,##fldSum##,##seqSum##,##seqRatio##,##fldRatio##,##rank##,##rank2##' -o $OUTPUT

rm -rf $TD-xx*

#λåɽ
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
