#!/usr/bin/env bash

#*****************************************************************************
# xtbseq.sh
# Ʊ֥Ϣ³󥹤κ
# Y.Hamuro
# 1.0b 2004/03/08
# 1.0  -u ɲ,ȥåб 2004/11/26
#*****************************************************************************

#顼å
function help {
cat >/dev/stderr <<EOF
----------------------
xtbseq.sh version 1.0
----------------------
) Ʊ֥Ϣ³󥹤롣

) xtbseq.sh -c ܵҹ̾ -d չ̾ -b ֥ɹ̾
                -B Ϣ³ [-u]
                [-A 򤹤Ϣ³Ź(default=0)]
                [-C 򤹤Ϣ³Ź(default=0)]
                [-iե] [-oϥե̾] [-T ǥ쥯ȥ̾]
                [-V] [-h]
      -u : ֥ɤϢ³ˡϢ³Τߤ˸ꤹ
      -V : ޥɤδλåɽ롣
      -h : إפɽ

) ϥեι̾Ȥ"targetBrand","seqNo","term"3ĤԲġ

1) xtbseq.sh -c ܵ -d  -b ֥ -B 3 -i dat.xt -o rsl.xt
2) xtbseq.sh -c ܵ -d  -b ֥ -B 3 -u -i dat.xt -o rsl.xt
3) xtbseq.sh -c ܵ -d  -b ֥ -B 3 -A 5 -C 3 -i dat.xt -o rsl.xt
EOF
exit 1
}

#λåѤ˥ޥɥ饤¸
cmdLine="$0 $*"

#ǥեȤǤϡޥɤΥåOFF
export mssQuiet=1

#ʥˤ뽪λ
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}


brandUniq="0"
#ѥ᡼Υåå
  while getopts ":c:d:b:B:A:C:i:o:uVh" opt; do
    case $opt in
      c  ) CUST=$OPTARG ;;
      d  ) DATE=$OPTARG ;;
      b  ) BRAND=$OPTARG ;;
      B  ) minSeqCnt=$OPTARG ;;
      A  ) aVisit=$OPTARG ;;
      C  ) cVisit=$OPTARG ;;
      i  ) input=$OPTARG ;;
      o  ) output=$OPTARG ;;
      T  ) tmpD=$OPTARG ;;
      u  ) brandUniq="1" ;;
      V  ) mssQuiet=0 ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$tmpD" = "" ]; then
    tmpD=/tmp
  fi
  if [ "$input" = "" ]; then
    input=/dev/stdin
  fi
  if [ "$output" = "" ]; then
    output=/dev/stdout
  fi
  if [ "$CUST" = "" ]; then
    echo "#ERROR# $$ \"$0\" \"option -c is mandatory\"" >/dev/stderr
    exit 1
  fi
  if [ "$DATE" = "" ]; then
    echo "#ERROR# $$ \"$0\" \"option -d is mandatory\"" >/dev/stderr
    exit 1
  fi
  if [ "$BRAND" = "" ]; then
    echo "#ERROR# $$ \"$0\" \"option -b is mandatory\"" >/dev/stderr
    exit 1
  fi
  if [ "$minSeqCnt" = "" ]; then
    echo "#ERROR# $$ \"$0\" \"option -B is mandatory\"" >/dev/stderr
    exit 1
  fi
  if [ "$aVisit" = "" ]; then
    aVisit=0
  fi
  if [ "$cVisit" = "" ]; then
    cVisit=0
  fi

#ե̾
TD=$tmpD/mss-xtbseq1-$$

#ȥåȯư
trap endByInt INT QUIT TERM HUP

# ==============================================================================
# 磰) ΥץȤѤܰʳι̾ꥹȺ
# ------------------------------------------------------------------------------
# ex)
# ϥǡι : ܵ,,֥,,
#     Ѥ : ܵ,,֥
#  OTHERFIELD=",,"
# ==============================================================================
echo "#MSG# $$ \"$0\" \"preprocessing\"" >/dev/stderr
mkfifo $TD-xxfifo

echo "$CUST,$DATE,$BRAND" |
tr ',' '\n' |
gawk '{print $1,NR}' |
sort >$TD-xxfld2

xtbest -R 0 <$TD-xxfifo |
xt2txt -F |
tr ' ' '\n' |
gawk '{print $1,NR}' |
sort >$TD-xxfld1 &

function setOtherField {
  xtcommon -t -r -k 1 -m $TD-xxfld2 -i $TD-xxfld1 -o $TD-xxfld3

  if [ -s  $TD-xxfld3 ] ; then
    xtsort -t -k 2%n -i $TD-xxfld3 |
    xtcut -t -f 1 |
    tr '\n' ',' |
    sed 's/,$//' >$TD-xxfld4
    OTHERFIELD=",`cat $TD-xxfld4`"
  else
    OTHERFIELD=""
  fi
}

# ==============================================================================
# 磱) Ϣ(custDateSeqNo)κ
# ------------------------------------------------------------------------------
# ǡ᡼
#  ܵ,,֥,֥Ϣ
# a 20030101 A 1
# a 20030104 A 2
# a 20030108 A 3
# a 20030112 B 4
# a 20030113 A 5 +
# a 20030113 B 5 +->ƱդƱֹ
# a 20030115 B 6
# a 20030118 B 7
# ==============================================================================
echo "#MSG# $$ \"$0\" \"creating date sequence number\"" >/dev/stderr

tee $TD-xxfifo <$input |

# ƱƱ֥ʣϹθʤ(ˡˤ)
xtuniq -k $CUST,$DATE,$BRAND |

# ܵդϢ֤դ
xtnumber -k $CUST,$DATE -B -a '##custDateSeqNo##' -o $TD-xxds

# ==============================================================================
# 磲) ֥Ϣ³ϰϥޥκ
# ------------------------------------------------------------------------------
#   (aVisit)  Ʊ֥minSeqCntʾϢ³  (cVisit)
#
# Ʊ֥Ϣ³Ȥ
#   ƱʣΥ֥ɤƤƤϢ³ȥȤ
#
# ex1)  AA(AB)(AC)A A򣵲Ϣ³Ƥ(Ʊι)
#
# ------------------------------------------------------------------------------
# ǡ᡼
# :1.ܵ 2.Ϣ 3.λϢ 4.֥ 5.seqNo 6.term
# a -4 0 A 2 a   -> -40ܤޤ(ϤʤäȤ)
# a  1 3 A 2 b   -> a15ŹA֥ɤϢ³ä
# a  4 8 A 2 c   -> 48ܤޤ
# ==============================================================================
echo "#MSG# $$ \"$0\" \"creating range master file\"" >/dev/stderr

# ܵҥ֥̤Ϣ³(custDateSeqNo)ƱֹĤ
# (custDateSeqNoȤǤȤȤϡƱ֥ɤϢ³Ǥʤ)
xtcal -k $CUST,$BRAND -s $DATE%r -c \
  'if(keyLine()==1,
     1,
     if((prvField($##custDateSeqNo##)-1)==$##custDateSeqNo##,
       prvResult(),
       prvResult()+1))' -a seqNo -i $TD-xxds |

# Ʊ֥Ϣ³ˤƱseqNoդƤΤǡιԿminSeqCnt
# ʾΤΤΤ򤹤(Ʊ֥Ϣ³)
xtsel -k $CUST,$BRAND,seqNo -c 'keyCnt()>='$minSeqCnt -o $TD-xxc

#嵭ǵ᤿Ʊ֥Ϣ³κǽȺǸcustDateSeqNo
xtbest -k $CUST,$BRAND,seqNo -s '##custDateSeqNo##%n'  -R 1 -i $TD-xxc -o $TD-xxmin
xtbest -k $CUST,$BRAND,seqNo -s '##custDateSeqNo##%nr' -R 1 -i $TD-xxc -o $TD-xxmax

# Ʊ֥Ϣ³aVisitϰϥޥ(term="a")
xtcal  -c '$##custDateSeqNo##-1'           -a to -i $TD-xxmin |
xtcal  -c '$##custDateSeqNo##-'$aVisit -a from |
xtcut  -f $CUST,from,to,$BRAND:targetBrand,seqNo |
xtsetchr -v a -a term -o $TD-xxd

# Ʊ֥Ϣ³ϰϥޥ(term="b")
xtjoin -k $CUST,$BRAND,seqNo -m $TD-xxmax -f '##custDateSeqNo##':to -i $TD-xxmin |
xtcut  -f $CUST,'##custDateSeqNo##':from,to,$BRAND:targetBrand,seqNo |
xtsetchr -v b -a term -o $TD-xxe

# Ʊ֥Ϣ³θcVisitϰϥޥ(term="c")
xtcal  -c '$##custDateSeqNo##+1'           -a from -i $TD-xxmax |
xtcal  -c '$##custDateSeqNo##+'$cVisit -a to |
xtcut  -f $CUST,from,to,$BRAND:targetBrand,seqNo |
xtsetchr -v c -a term -o $TD-xxf

#嵭ĤΥեʻ礷ϰϥޥȤ롣
xtcat -i $TD-xxd,$TD-xxe,$TD-xxf |
xtsort -k $CUST,from,to,targetBrand,seqNo,term -o $TD-xxm

# ==============================================================================
# 磳) 嵭磱ȣǺ줿եȤ
#         Ϣ³֥ɥ󥹥ǡ
# ------------------------------------------------------------------------------
#  ܵ,,֥,Ϣ
# a 20030101 A 1
# a 20030104 A 2
# a 20030108 A 3
# a 20030112 B 4
# a 20030113 A 5
# a 20030113 B 5
# a 20030115 B 6
# a 20030118 B 7
#
# 嵭ΥեϢ֤ȲΥեϢ֤ϰϤͤ碌
# ϰäƤ(closed range)Υե4-6join롣
# ֥Ϣ֤ĤϰϤ°ϡԽϤ롣
#
# :1.ܵ 2.Ϣ 3.λϢ 4.֥ 5.seqNo 6.term
# a -4 0 A 2 a
# a  1 3 A 2 b
# a  4 8 A 2 c
#
# ̤ϰʲ̤ꡣȤŬ¤ٴ
#  
# a 20030101 A 1 A 2 b
# a 20030104 A 2 A 2 b
# a 20030108 A 3 A 2 b
# a 20030112 B 4 A 2 c
# a 20030113 A 5 A 2 c
# a 20030113 B 5 A 2 c
# a 20030115 B 6 A 2 c
# a 20030118 B 7 A 2 c
# ==============================================================================
echo "#MSG# $$ \"$0\" \"creating brand sequence pattern\"" >/dev/stderr

# ܥץȤѤƤʤ̾Υå
setOtherField

if [ "$brandUniq" = "0" ]; then

# ֥Ϣ֤ϰϤͤ碌åֹ礹
xtnrjoin -k $CUST -v '##custDateSeqNo##%n' -m $TD-xxm -R from,to%e -f targetBrand,seqNo,term -i $TD-xxds |

# ɬ׹ܤȴ
xtcut -f $CUST,targetBrand,seqNo,term,$DATE,$BRAND$OTHERFIELD |

# 䤹ΤΥ
xtsort -k $CUST,targetBrand,seqNo,term,$DATE >$output

else

# ֥Ϣ֤ϰϤͤ碌åֹ礹
xtnrjoin -k $CUST -v '##custDateSeqNo##%n' -m $TD-xxm -R from,to%e -f targetBrand,seqNo,term -i $TD-xxds |

# ɬ׹ܤȴ
xtcut -f $CUST,targetBrand,seqNo,term,$DATE,$BRAND$OTHERFIELD -o $TD-xxrsl

#ˡǤʤϢ³ޥκ
xtselstr -f term -v b -i $TD-xxrsl |
xtcut -f custID,targetBrand,seqNo,$BRAND |
xtuniq -k custID,targetBrand,seqNo,$BRAND |
xtcount -k custID,targetBrand,seqNo -a '##cnt##' |
xtsel -c '$##cnt##>1' -o $TD-xxbunq

xtcommon -k custID,targetBrand,seqNo -m $TD-xxbunq -r -i $TD-xxrsl |

# 䤹ΤΥ
xtsort -k $CUST,targetBrand,seqNo,term,$DATE >$output
fi

#ե
rm -f $TD-xx*

#λåɽ
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
# ==============================================================================
