#!/usr/bin/env bash

#*****************************************************************************
# xtcross.sh
# NXWvf[^̍쐬
# Y.Hamuro
# 1.0b 2003/01/07
# 1.0  gbvǉ, 2004/11/09
#*****************************************************************************

#G[bZ[W
function help {
cat >/dev/stderr <<EOF
------------------------
xtcross.sh version 1.0
------------------------
Tv)NXWv\\쐬B
) xtcross.sh -k sɂȂ鍀ږ -f ɂȂ鍀ږ -d Z̒l̍ږ
                [-i ̓t@C] [-oo̓t@C]
                [-T [NfBNg] [-V] [-h]

      -V : R}h̊bZ[W\B
      -h : wv̕\


) xtcross.sh -k ڋq -f  -d z -i dat.xt -o rsl.xt
EOF
exit 1
}

#ftHgł́AR}h̃bZ[WOFF
export mssQuiet=1

#bZ[WpɃR}hCۑ
cmdLine="$0 $*"

#VOiɂI
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
} 

#p[^̃`FbNZbg
rName='fold##.data'
sName='fold##.test'
while getopts ":k:f:d:i:o:Vh" opt; do
  case $opt in
    k  ) row=$OPTARG ;;
    f  ) col=$OPTARG ;;
    d  ) dat=$OPTARG ;;
    i  ) input=$OPTARG ;;
    o  ) output=$OPTARG ;;
    T  ) tmpD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$tmpD" = "" ]; then
   tmpD=/tmp
fi
if [ "$input" = "" ]; then
  input=/dev/stdin
fi
if [ "$output" = "" ]; then
  output=/dev/stdout
fi
if [ "$row" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -k is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$col" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
   exit 1
fi
if [ "$dat" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -d is mandatory\"" >/dev/stderr
  exit 1
fi

#[Nt@C
TD=$tmpD/xtcross-$$

#gbv
trap endByInt INT QUIT TERM HUP

#Kvڂ؂oAtmpt@CŕۑB
xtcut -f $row,$col,$dat -i $input |
xtdelnul -f $row,$col,$dat -o $TD-xxbase

#j[Nڋq̃Xg쐬
xtcut -f $row -i $TD-xxbase |
xtuniq -k $row -o $TD-xxcust

#j[NރXg̍쐬 -> XNvg쐬
xtcut -f $col -i $TD-xxbase |
xtuniq -k $col |
xt2txt |
gawk '{print "joinCls",$1}' > $TD-xxsh

#ޖɃt@C𕪊
xtsep -d $TD-xxsep-'$('$col')' -i $TD-xxbase

#ޖ̃t@CڋqL[join֐
function joinCls {
  xtjoin -n -k $row -m $TD-xxsep-$1 -f $dat:$1 -i $TD-xxcust -o $TD-xxp
  cp $TD-xxp $TD-xxcust
}

#ŃXNvgs
. $TD-xxsh

cat <$TD-xxcust >$output

rm -rf $TD-xx*

#bZ[W\
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
