#!/usr/bin/env bash
 
#*****************************************************************************
# xtabc.sh version 1.0b
# ABC分析スクリプト
# Y.Hamuro
# 2004/05/17
# 2004/12/06 -k 対応,トラップ追加(1.0)
#*****************************************************************************
 
function help {
cat >/dev/stderr <<EOF
--------------------------
xtabc.sh version 1.0
--------------------------
概要) ABC分析を行う。
書式) xtabc.sh [-k キー項目リスト] -f 対象項目名 [-R ランク範囲] [-v ランク名]
                  [-d 出力する有効小数点桁数]
                  [-i 入力ファイル名] [-o出力ファイル名]
                  [-T ワークディレクトリ名] [-V] [-h]
        -V : コマンドの完了メッセージを表示させる。
        -h : ヘルプの表示
        -Rのデフォルト : MIN,70,90,MAX
        -vのデフォルト : A,B,C 
        -dのデフォルト : 0.01

例1) xtabc.sh -f 金額 -i input.xt -o output.xt
例1) xtabc.sh -k 店 -f 金額 -i input.xt -o output.xt
例2) xtabc.sh -f 金額 -R 0,0.4,0.6,0.9,MAX -v A,B,C,D -i input2.xt -o output2.xt

例1の入出力データ例
--------------
input.xtの内容
--------------
顧客ID 数量
a 10
b 50
c 20
d 30
e 12
f 15
--------------
output.xtの内容
--------------
顧客ID 数量 accmCnt accmCntShr accmVal accmValShr rank
b 50 1 16.67  50 36.5  A
d 30 2 33.33  80 58.39 A
c 20 3 50    100 72.99 B
f 15 4 66.67 115 83.94 B
e 12 5 83.33 127 92.7  C
a 10 6 100   137 100   C
--------------
EOF
exit 1
}

#デフォルトでは、コマンドのメッセージはOFF
export mssQuiet=1

#完了メッセージ用にコマンドラインを保存
cmdLine="$0 $*"

#シグナルによる終了
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

KEY="#same#"

#パラメータのチェック＆セット
while getopts ":k:f:R:v:i:o:T:Vh" opt; do
  case $opt in
    k  ) KEY=$OPTARG ;;
    f  ) FLD=$OPTARG ;;
    R  ) RNG=$OPTARG ;;
    v  ) VAL=$OPTARG ;;
    d  ) DEC=$OPTARG ;;
    i  ) INPUT=$OPTARG ;;
    o  ) OUTPUT=$OPTARG ;;
    T  ) TMPD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))
                                                                                
if [ "$FLD" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$RNG" = "" ]; then
  RNG=MIN,70,90,MAX
fi
if [ "$VAL" = "" ]; then
  VAL=A,B,C
fi
if [ "$NAM" = "" ]; then
  NAM=累積件数,累積件数構成比,累積$FLD,累積$FLD構成比,ランク
fi
if [ "$DEC" = "" ]; then
  DEC=0.01
fi
if [ "$INPUT" = "" ]; then
   INPUT=/dev/stdin
fi
if [ "$OUTPUT" = "" ]; then
 OUTPUT=/dev/stdout
fi
if [ "$TMPD" = "" ]; then
   TMPD=/tmp
fi

# 新項目名のセット
NAM1=accmCnt
NAM2=accmCntShr
NAM3=accmVal
NAM4=accmValShr
NAM5=rank

#ワークファイル名
TD=$TMPD/xtabc-$$

#トラップ発動
trap endByInt INT QUIT TERM HUP

#=====================================================
# 【ステップ１】
# データ行の累積と順位を求めておく
#-----------------------------------------------------
#顧客のデータ行番号件数累積と順位を求めておく
xtsetchr -v 1 -a "##seq##" -i $INPUT |
xtaccum  -k $KEY -s "$FLD%rn" -f "$FLD:##fldAccm##,##seq##:##seqAccm##" -o $TD-xxa

#トラ件数の合計と最終順位(顧客数)を求める
xtagg -k $KEY -f "$FLD:##fldSum##,##seq##:##seqSum##" -c sum -i $TD-xxa -o $TD-xxs

#上記２つをJOINし、トラの累積％の１０％きざみにより顧客を１０分割する
xtjoin -k $KEY -m $TD-xxs -f "##fldSum##,##seqSum##" -i $TD-xxa |
xtcal -c 'round(100*$##seqAccm##/$##seqSum##,'$DEC')' -a "##seqRatio##" |
xtcal -c 'round(100*$##fldAccm##/$##fldSum##,'$DEC')' -a "##fldRatio##" |
xtchgnum -f "##fldRatio##:##rank##" -R $RNG -v $VAL -A -o $TD-xxb

if [ "$KEY" = "#same#" ] ; then
  xtcal -q -k $FLD -c 'if(keyLine()==1,$##rank##,if(prvField($'$FLD') -eq $'$FLD' && prvResult() -ne $##rank##,prvResult(),$##rank##))' -a "##rank2##" -i $TD-xxb -o $TD-xxc
else
  xtcal -q -k $KEY,$FLD -c 'if(keyLine()==1,$##rank##,if(prvField($'$FLD') -eq $'$FLD' && prvResult() -ne $##rank##,prvResult(),$##rank##))' -a "##rank2##" -i $TD-xxb -o $TD-xxc
fi

xtcut -f '*,##seqAccm##:'$NAM1',##seqRatio##:'$NAM2',##fldAccm##:'$NAM3',##fldRatio##:'$NAM4',##rank2##:'$NAM5 -i $TD-xxc |
xtcut -r -f '##seq##,##seqAccm##,##fldAccm##,##fldSum##,##seqSum##,##seqRatio##,##fldRatio##,##rank##,##rank2##' -o $OUTPUT

rm -rf $TD-xx*

#完了メッセージ表示
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
