#!/usr/bin/env bash

#*****************************************************************************
# xtcross.sh
# クロス集計データの作成
# Y.Hamuro
# 1.0b 2003/01/07
# 1.0  トラップ追加,清書 2004/11/09
#*****************************************************************************

#エラーメッセージ
function help {
cat >/dev/stderr <<EOF
------------------------
xtcross.sh version 1.0
------------------------
概要)クロス集計表を作成する。
書式) xtcross.sh -k 行になる項目名 -f 列になる項目名 -d セルの値の項目名
                [-i 入力ファイル名] [-o出力ファイル名]
                [-T ワークディレクトリ名] [-V] [-h]

      -V : コマンドの完了メッセージを表示させる。
      -h : ヘルプの表示


例) xtcross.sh -k 顧客 -f 分類 -d 金額 -i dat.xt -o rsl.xt
EOF
exit 1
}

#デフォルトでは、コマンドのメッセージはOFF
export mssQuiet=1

#完了メッセージ用にコマンドラインを保存
cmdLine="$0 $*"

#シグナルによる終了
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
} 

#パラメータのチェック＆セット
rName='fold##.data'
sName='fold##.test'
while getopts ":k:f:d:i:o:Vh" opt; do
  case $opt in
    k  ) row=$OPTARG ;;
    f  ) col=$OPTARG ;;
    d  ) dat=$OPTARG ;;
    i  ) input=$OPTARG ;;
    o  ) output=$OPTARG ;;
    T  ) tmpD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$tmpD" = "" ]; then
   tmpD=/tmp
fi
if [ "$input" = "" ]; then
  input=/dev/stdin
fi
if [ "$output" = "" ]; then
  output=/dev/stdout
fi
if [ "$row" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -k is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$col" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
   exit 1
fi
if [ "$dat" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -d is mandatory\"" >/dev/stderr
  exit 1
fi

#ワークファイル名
TD=$tmpD/xtcross-$$

#トラップ発動
trap endByInt INT QUIT TERM HUP

#必要項目を切り出し、tmpファイルで保存。
xtcut -f $row,$col,$dat -i $input |
xtdelnul -f $row,$col,$dat -o $TD-xxbase

#ユニーク顧客のリスト作成
xtcut -f $row -i $TD-xxbase |
xtuniq -k $row -o $TD-xxcust

#ユニーク分類リストの作成 -> スクリプト作成
xtcut -f $col -i $TD-xxbase |
xtuniq -k $col |
xt2txt |
gawk '{print "joinCls",$1}' > $TD-xxsh

#分類毎にファイルを分割する
xtsep -d $TD-xxsep-'$('$col')' -i $TD-xxbase

#分類毎のファイルを顧客をキーにjoinする関数
function joinCls {
  xtjoin -n -k $row -m $TD-xxsep-$1 -f $dat:$1 -i $TD-xxcust -o $TD-xxp
  cp $TD-xxp $TD-xxcust
}

#ここでスクリプト実行
. $TD-xxsh

cat <$TD-xxcust >$output

rm -rf $TD-xx*

#完了メッセージ表示
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
