#!/usr/bin/env bash

#*****************************************************************************
# xtnfold version 1.1
# 交差検定用のデータセットの作成
# T.Nakahara
# 2002/01/12
# Y.Hamuro
# 2002/01/29 -tの追加, -dのディレクトリが最後/で終っている必用をなくす
# 2003/02/03 現在のコマンドに対応(1.0.1)
# 2004/01/21 top行 /bin/bash -> /usr/bin/env bash に変更(増田氏のご指摘)
# 2004/01/21 ヘルプでバージョン情報を表示するように変更(1.0.2)
# 2004/11/29 トラップ追加(1.1), -t削除 
#*****************************************************************************
#エラーメッセージ
function help {
cat >/dev/stderr <<EOF
------------------------
xtnfold.sh version 1.1
------------------------
概要) 交差検定用のデータセットを作成する。
書式) xtnfold.sh -i ファイル -d 出力ディレクトリ -n fold数 -c クラス項目
                 [-o トレーニングファイル名] [-O テストファイル名]
                 [-S 乱数の種] [-t] [-V]
       -V : コマンドの完了メッセージを表示させる。
       -h : ヘルプの表示
解説) -cで指定された項目により層化される。
      -oもしくは-Oが省略されれば、"##.train","##.test"というファイル名になる。
例) xtnfold.sh -i dat -d fold -n 5 -c Class -o fold##.train -O fold##.test
EOF
exit 1
}

#完了メッセージ用にコマンドラインを保存
cmdLine="$0 $*"

#デフォルトでは、コマンドのメッセージはOFF
export mssQuiet=1

#シグナルによる終了
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

#パラメータのセット
rName='##-train.xt'
sName='##-test.xt'
while getopts ":i:d:n:c:S:k:o:O:Vh" opt; do
  case $opt in
    i  ) input=$OPTARG ;;
    d  ) path=$OPTARG ;;
    n  ) fold=$OPTARG ;;
    c  ) cls=$OPTARG ;;
    S  ) sed=$OPTARG ;;
    o  ) rName=$OPTARG ;;
    O  ) sName=$OPTARG ;;
    T  ) tmpD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$input" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -i is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$path" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -d is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$fold" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -n is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$cls" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -c is mandatory\"" >/dev/stderr
fi
if [ "$sed" = "" ]; then
   sed=-1
fi
if [ "$tmpD" = "" ]; then
  tmpD=/tmp
fi


#トレーニングとテストの同一名チェック
if [ "$rName" = "$sName" ]; then
  echo "#ERROR# $$ \"$0\" \"file names for training and test must be different\"" >/dev/stderr
  exit 1
fi

#入力ファイルチェック
if [ ! -f $input ]; then
  echo "#ERROR# $$ \"$0\" \"file not found : $input\"" >/dev/stderr
  exit 1
fi

#-dのおけつ"/"をとる
path=`echo $path | sed 's/\/*$//'`

#ワークファイルのプレフィックスの設定
wf=$tmpD/mss-xtnfold-$$

#トラップ発動
trap endByInt INT QUIT TERM HUP

#出力ディレクトリが存在しないなら作成する
if [ ! -d $path ]; then
   mkdir -p $path
fi

#clsを分けるためにfold数にあわせてcls番号をふる
xtrand -a "##rand##" -S $sed -i $input |
xtcal  -k$cls -s "##rand##%n" -c 'down(keyLine()/(keyCnt()/'$fold'+0.00001),1)' -a "##val##" >$wf-03

#cls番号にあわせてそれぞれのファイルに出力する
loop=0
while [ "$loop" -lt "$fold" ]; do
  xtsel -c'$##val## -eq '$loop -i$wf-03\
        -u$wf-trn-$(($loop+1)) -o $wf-tst-$(($loop+1))
  loop=$((loop+1)) 
done;

loop=1
while [ $loop -le $fold ] ; do
  trnName=`echo $rName | sed 's/##/'$loop'/'`
  tstName=`echo $sName | sed 's/##/'$loop'/'`
  tprName=$wf-trn-$loop
  tpsName=$wf-tst-$loop

  xtcut -rf "##val##,##rand##" -i$tprName -o"$path"/$trnName
  xtcut -rf "##val##,##rand##" -i$tpsName -o"$path"/$tstName

  loop=$((loop+1)) 
done;

#ワークファイル削除
rm $wf-*

#完了メッセージ表示
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
# ==============================================================================
