<?php
	require("../__common__/__define_common.php");
	if (!defined("GOOGLE_API_KEY")) {
		define("GOOGLE_API_KEY", "ABQIAAAA1XbMiDxx_BTCY2_FkPh06RRaGTYH6UMl8mADNa0YKuWNNa8VNxQEerTAUcfkyrr6OwBovxn7TDAH5Q");
	}
	if (!defined("GETLATLNG_SLEEP_TIME")) {
		define("GETLATLNG_SLEEP_TIME", 200000);	// 0.2秒
	}
	if (!defined("MAPS_FIX_HEIGHT")) {
		define("MAPS_FIX_HEIGHT", 50);
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<meta name="author" content="ok.2nd">
<script language="javascript" src="../scripts/encodeURL.js" type="text/javascript"></script>
<title>Google Maps & Earth (Multi Positions)</title>
<style type="text/css">
/* * {margin: 0px; padding: 0px; } */
/*	↓ input 除く */
body, div, img, dl, dt, dd, ul, ol, li, h1, h2, h3, h4, h5, h6, pre, form, fieldset, textarea, p, blockquote, th, td, caption {
	margin: 0; 
	padding: 0;
}
input {
	margin: 0;
	padding: 0 3px;
	*padding: 0;
}
input[type="submit"] {
	background-color: #e0e0e0;
}
input[type="reset"] {
	background-color: #e0e0e0;
}
input[type="button"] {
	background-color: #e0e0e0;
}
button {
	background-color: #e0e0e0;
	margin: 0;
	padding: 0 3px;
	*padding: 0;
}
textarea,input,button {
	font-family: "ＭＳ Ｐゴシック",arial,helvetica,clean,sans-serif;
	line-height: 1.3;
	*line-height: 1.0;
	font-size: 100%;
}
select {
	font-family: "ＭＳ Ｐゴシック",arial,helvetica,clean,sans-serif;
	line-height: 1.3;
	*line-height: 1.0;
	font-size: 100%;
}
textarea {
	padding: 2px;
	_padding: 0px;
	/padding: 0px;
}
html {
	width: 100%;
	height: 100%;
	overflow: hidden;
}
body {
	margin: 0;
	width: 100%;
	height: 100%;
	font-size: 84%;
}
#form {
	margin: 5px 0 0 5px;
}
#map3d {
	width: 100%;
	height: 100%;
}
input.text {
	margin: 0px;
	padding: 1px 0 1px 0;
}
a { color: blue; }
.error_msg { color: red; margin: 20px; padding: 0; }
.noramal_msg { color: #000000; margin: 20px; padding: 0; }
</style>
</head>
<?php
	if ($_POST) {
		$addresses = $_POST['address'];
	} elseif (isset($_GET['addr'])) {
		$addresses = $_GET['addr'];
	}
	$addresses = str_replace(',', ' ', $addresses);
	$addresses = str_replace('　', ' ',  $addresses);
	$addresses = trim($addresses);
	if ($addresses <> '') {
		maps_body($addresses);
	} else {
		init_body();
	}
?>
</body>
</html>
<?php
// -----------------------------------------------------
function maps_body($addresses) {
?>
<body onload="init()" onunload="GUnload()">
<?php
	form_div($addresses);
	google_maps($addresses)
?>
<div id="map3d"></div>
<div>Not found: <span id="not_found" style="color: red;"></span></div>
<div>Installed Plugin Version: <span id="installed-plugin-version" style="font-weight: bold;">Loading...</span></div>
<?php
}
?>
<?php
// -----------------------------------------------------
function init_body() {
?>
<body>
<script type="text/javascript">
function markerClear() {
}
function addressClear() {
	document.getElementById("address").value = '';
}
</script>
<?php
	form_div('');
}
?>
<?php
// -----------------------------------------------------
function form_div($addresses) {
?>
<div>
<form id="form" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
	<input id="address" class="text" type="text" size="80" name="address" value="<?= $addresses ?>">
	<input type="submit" value="地図を検索" style="background-color: #e0e0e0;">
	<button onclick="addressClear(); return false" style="margin-left:2px;">クリア</button>
	<button onclick="markerClear(); return false" style="margin-left:2px;">マーカー削除</button>
	<a href="http://maps.google.co.jp/" target="_blank" style="margin-left:16px;">Google マップ</a>
	<a href="http://code.google.com/intl/ja/apis/earth/" target="_blank" style="margin-left:8px;">Google Earth API</a>
</form>
</div>
<?php
}
// -----------------------------------------------------
function google_maps($addresses) {
?>
<script src="http://www.google.com/jsapi?key=<?= GOOGLE_API_KEY ?>"></script>
<script type="text/javascript">
var map;
var ge;
var geocoder = null;
var maxLat=-999, minLat=999, maxLng=-999, minLng=999;
var notFound = '';
google.load("maps", "2.x");
function setHeightPercent(elementID, fixHeight) {
	// マップの高さ設定
	if (document.all) {	// IE
		fixHeight += 40;
	}
	mapsWinHeight = 100 - Math.ceil( fixHeight * 100 / screen.availHeight );
	document.getElementById(elementID).style.height = mapsWinHeight + "%";
}
function init() {
	setHeightPercent('map3d', <?= MAPS_FIX_HEIGHT ?>);
	map = new GMap2(document.getElementById('map3d'));
	var mapui = map.getDefaultUI();
	mapui.maptypes.physical = true;
	map.setUI(mapui);
	map.addMapType(G_SATELLITE_3D_MAP);
	GEvent.addListener(map, 'maptypechanged', function() {
		if (ge) return;
		map.getEarthInstance(function(pluginInstance) {
			ge = pluginInstance;
			doStuffWithEarth();
		});
	});
	geocoder = new GClientGeocoder();
	maxLat = -999;
	minLat = 999;
	maxLng = -999;
	minLng = 999;
	var vpoint = Array();
<?php
	$ary = explode(" ", $addresses);
	$adr_cnt = 0;
	foreach ($ary as $address) {
		$status = getLatLng($address, $lat, $lng);
?>
	vpoint[<?= $adr_cnt ?>] = Array();
	vpoint[<?= $adr_cnt ?>]["address"] = '<?= $address ?>';
	vpoint[<?= $adr_cnt ?>]["lat"] = <?= $lat ?>;
	vpoint[<?= $adr_cnt ?>]["lng"] = <?= $lng ?>;
	vpoint[<?= $adr_cnt ?>]["status"] = <?= $status ?>;
<?php
		++$adr_cnt;
	//	usleep(GETLATLNG_SLEEP_TIME);
	}
?>
	showMarker(vpoint, <?= $adr_cnt ?>);
}
function createMarker(point, addr, lat, lng) {
	var marker = new GMarker(point);
	GEvent.addListener(marker, "click", function() {
		html = addr + '<br><br>';
		html += '緯度：' + lat + '<br>';
		html += '経度：' + lng + '<br><br>';
		html += '<a href="http://maps.google.com/maps?q=' + encodeURL(addr);
		html += '" target="_blank">Googleマップ ≪' + addr + '≫</a>';
		map.openInfoWindowHtml(point, html);
	});
	return marker;
}
function showMarker(vpoint, cnt) {
	if (geocoder) {
		for (var ix=0; ix<cnt; ix++) {
			if (vpoint[ix]["status"] == 200) {
				var lat = vpoint[ix]["lat"];
				var lng = vpoint[ix]["lng"];
				var point = new GLatLng(lat, lng);
				if (maxLat < lat) maxLat = lat;
				if (minLat > lat) minLat = lat;
				if (maxLng < lng) maxLng = lng;
				if (minLng > lng) minLng = lng;
				map.addOverlay(createMarker(point, vpoint[ix]["address"], lat, lng));
			} else {
				notFound += vpoint[ix]["address"] + '&nbsp;';
			}
		}
		bounds = new GLatLngBounds(new GLatLng(minLat,minLng), new GLatLng(maxLat,maxLng));
		zoomlevel = map.getBoundsZoomLevel(bounds);
		if (zoomlevel > 15) zoomlevel = 15;
		map.setCenter(bounds.getCenter(), zoomlevel);
		document.getElementById('not_found').innerHTML = notFound;
	}
}
function doStuffWithEarth() {
	document.getElementById('installed-plugin-version').innerHTML = ge.getPluginVersion().toString();
}
function markerClear() {
	map.clearOverlays();
}
function addressClear() {
	document.getElementById("address").value = '';
}
</script>
<div id="map3d"></div>
<div>Not found: <span id="not_found" style="color: red;"></span></div>
<div>Installed Plugin Version: <span id="installed-plugin-version" style="font-weight: bold;">Loading...</span></div>
<?php
}
function getLatLngV2($address, &$lat, &$lng) {		// Geocoding API V2
	$latLng = my_file_get_contents('http://maps.google.com/maps/geo?q='.urlencode($address).'&output=csv&sensor=false&key='.GOOGLE_API_KEY);
	$ary = explode(',', $latLng);
	$lat = $ary[2];
	$lng = $ary[3];
	return $ary[0];
}
function getLatLng($address, &$lat, &$lng) {		// Geocoding API V3
	$json = my_file_get_contents('http://maps.google.com/maps/api/geocode/json?address='.urlencode($address).'&sensor=false');
	$latLng = json_decode($json, true);
	if ($latLng['status'] <> 'OK') return 0;
	$lat = $latLng['results'][0]['geometry']['location']['lat'];
	$lng = $latLng['results'][0]['geometry']['location']['lng'];
	return 200;	// getLatLngV2() との互換性のため
}
function my_file_get_contents($url) {
	static $me_called = False;
	static $proxy_context;
	if (!$me_called) {
		if (HTTP_PROXY_HOST.'' <> '') {
			$proxy = array(
				'http' => array(
					'proxy' => 'tcp://'.HTTP_PROXY_HOST.':'.HTTP_PROXY_PORT,
					'request_fulluri' => true,
				),
			);
			$proxy_context = stream_context_create($proxy);
		} else	{
			$proxy_context = False;
		}
	}
	$me_called = True;
	// httpsはエラーになる
	if ($proxy_context) {
		$html = @file_get_contents($url, False, $proxy_context);
	} else {
		$html = @file_get_contents($url);
	}
	return $html;
}
?>
