<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (photo_JPEG_RESIZE <> 'YES') {
		exit;
	}
	if ($_POST['path'] <> '') {
		$path = form_str_filepath($_POST['path']);
	} elseif ($_GET['path'] <> '') {
		$path = my_GET('path');
	}
	set_time_limit(0);		//実行時間制御なし　max_execution_time
	ob_implicit_flush();		//自動フラッシュをオン(出力をバッファリングしない)
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta name="author" content="ok.2nd">
<title>JPEG画像 一括縮小</title>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110622" type="text/css">
<style type="text/css">
span.result {
	padding: 0 0 0 5px;
}
span.warning {
	padding: 0 0 0 18px;
	color: red;
}
span#rotate_only {
	padding: 0 0 0 160px;
}
</style>
</head>
<body>
<span id="tool_title" style="color: #b8860b;">JPEG画像 一括縮小 (EXIF縦位置画像回転)</span>
<br><br>
<?php
	if ($path == '') {
		error_exit('ディレクトリ指定がありません。');
	}
	$path_SJIS = myfile_ENCODE($path);
	if (!($dir =@opendir($path_SJIS))) {
		error_exit('指定ディレクトリが開けません。');
	}
	closedir($dir);
	define("S_SIZE_STR", '<span style="color: red;">'.photo_RESIZE_SIZE_SMALL.'×'.photo_RESIZE_SIZE_SMALL.'</span>');
	define("T_SIZE_STR", '<span style="color: red;">'.photo_RESIZE_SIZE_THUMB.'×'.photo_RESIZE_SIZE_THUMB.'</span>');
?>
<form method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
<div style="margin: 10px; ">
<p style="margin: 5px 0 5px 0; ">
	ディレクトリ「<a href="../tools/file-manager.php?path=<?= urlencode($path) ?>" target="_blank" style="margin: 0 2px;"><?= $path ?></a>」の下の、<br>
	JPEG画像ファイルを、縮小して以下のディレクトリに格納します。<br>
	<?= S_SIZE_STR ?> ==> 「<span style="color: blue;"><?= $path.photo_RESIZE_DIR_SMALL ?></span>」<br>
	<?= T_SIZE_STR ?> ==> 「<span style="color: blue;"><?= $path.photo_RESIZE_DIR_THUMB ?></span>」
</p>
<p style="margin: 10px 0 5px 0; ">
<input type="hidden" name="path" value="<?= my_htmlspecialchars($path) ?>">
<input type="submit" name="resize" value="一括縮小実行">
<span id="rotate_only"><input type="submit" name="rotateOnly" value="縦位置撮影画像回転のみ実行"></span>
<br>
<label><input type="checkbox" name="overwrite" value="YES"<?= $_POST['overwrite']=='YES' ? ' checked' : '' ?>>既に縮小画像がある場合、再変換して縮小画像を上書きする。</label><br>
<label><input type="checkbox" name="rotate" value="YES"<?= $_POST['rotate']=='YES' ? ' checked' : '' ?>>一括縮小と合わせて縦位置撮影画像回転を実行する。</label><br>
<span class="warning">縦位置撮影画像回転：EXIF縦位置情報が含まれている画像を回転します。</span><br>
<span class="warning">縦位置撮影画像回転：元画像を上書きします。画像以外の何らかの属性情報が失われる可能性があります。</span><br><br>
</p>
</form>
<?php
	if (isset($_POST['resize'])) {
		done_proc($path, $small_count, $thumb_count, $rotate_count);
?>
	<br>縮小 ==> <?= S_SIZE_STR ?> ： <span style="color: red; font-weight: bold;"><?= $small_count ?></span> 個
	<br>縮小 ==> <?= T_SIZE_STR ?> ： <span style="color: red; font-weight: bold;"><?= $thumb_count ?></span> 個
<?php		if ($_POST['rotate'] == 'YES') { ?>
	<br>回転 ==> <span style="color: red; font-weight: bold;"><?= $rotate_count ?></span> 個
<?php
		}
	} elseif (isset($_POST['rotateOnly'])) {
		done_proc($path, $small_count, $thumb_count, $rotate_count, 'rotateOnly');
?>
	<br>回転 ==> <span style="color: red; font-weight: bold;"><?= $rotate_count ?></span> 個
<?php
	}
?>
</div>
</body>
</html>
<?php
function done_proc($path, &$small_count, &$thumb_count, &$rotate_count, $mode='resize') {
	echo '<p>処理開始........</p>';
	$path_SJIS = myfile_ENCODE($path);
	$small_dir_SJIS = $path_SJIS.photo_RESIZE_DIR_SMALL;
	if (!@opendir($small_dir_SJIS)) {
		@mkdir($small_dir_SJIS);
	}
	$thumb_dir_SJIS = $path_SJIS.photo_RESIZE_DIR_THUMB;
	if (!@opendir($thumb_dir_SJIS)) {
		@mkdir($thumb_dir_SJIS);
	}
	$small_count = 0;
	$thumb_count = 0;
	$rotate_count = 0;
	if ($dir=opendir($path_SJIS)) {
		$files_SJIS = scandir($path_SJIS);
		foreach ($files_SJIS as $file_SJIS) {
			$file = myfile_DECODE($file_SJIS);
			if (is_ext_filename_str($file, 'jpg,jpeg')) {
				$img_file = $path.'/'.$file;
				if ($mode == 'resize') {
					resize_main($img_file, $small_count, $thumb_count, $rotate_count);
				} else {
					rotate_main($img_file, $rotate_count);
				}
			}
		}
		closedir($dir);
	}
}
function resize_main($img_file, &$small_count, &$thumb_count, &$rotate_count) {	// UTF-8
	$attr = getimagesize(myfile_ENCODE($img_file));
	$width = $attr[0];
	$height = $attr[1];
	if ($width > $height) {
		$checksize = $width;
	} else {
		$checksize = $height;
	}
	if ($checksize <= photo_RESIZE_SIZE_SMALL and $checksize <= photo_RESIZE_SIZE_THUMB) {
		return;
	}
	echo '<p>'.$img_file.' : ';
	if ($checksize > photo_RESIZE_SIZE_SMALL) {
		$small_count += img_resize($img_file, photo_RESIZE_SIZE_SMALL, photo_RESIZE_DIR_SMALL, S_SIZE_STR);
	}
	if ($checksize > photo_RESIZE_SIZE_THUMB) {
		$thumb_count += img_resize($img_file, photo_RESIZE_SIZE_THUMB, photo_RESIZE_DIR_THUMB, T_SIZE_STR);
	}
	if ($_POST['rotate'] == 'YES') {
		if ($msg = img_rotate($img_file, $rotate_count)) {
			echo $msg;
		}
	}
	echo '</p>';
}
function img_resize($img_file, $size, $dir, $type) {		// UTF-8
	$resize_file = resize_filename($img_file, $dir);
	$resize_SJIS = myfile_ENCODE(str_replace('/', DIRECTORY_SEPARATOR, $resize_file));
	if ($_POST['overwrite'] == 'YES' or !@file_exists($resize_SJIS)) {
		$img_SJIS = myfile_ENCODE(str_replace('/', DIRECTORY_SEPARATOR, $img_file));
		$ret = resize_jpeg($img_SJIS, $size, $resize_SJIS);
		if ($ret <> 0) {
			write_error_log(PHOTO_ERROR_LOG_FILE, 'exec(resize)', 'Err_file='.$img_file);
			echo '<span class="result">Error</span>';
			return 0;
		}
		echo '<span class="result">'.$type.'</span>';
		return 1;
	}
	echo '<span class="result">-----</span>';
	return 0;
}
function resize_filename($img_file, $dir) {		// UTF-8
	$resize_dir = up_folder_path($img_file).$dir;
	return ($resize_dir.basename($img_file));
}
function resize_jpeg($src, $size, $tgt) {		// SJIS-win
	exec('i_view32 "'.$src.'" /resize=('.$size.','.$size.') /aspectratio /silent /convert="'.$tgt.'"', $o, $ret);
	return $ret;
}
function rotate_main($img_file, &$rotate_count) {	// UTF-8
	if ($msg = img_rotate($img_file, $rotate_count)) {
		echo '<p>'.$img_file.' : '.$msg.'</p>';
	}
}
function img_rotate($img_file, &$rotate_count) {		// UTF-8
	if (photo_EXIF_AUTO_ROTATE <> 'YES') {
		return false;
	}
	$exif = @exif_read_data(myfile_ENCODE($img_file));
	if (!$exif) {
		return false;
	}
	$orientation = $exif['Orientation'];
	if (!$orientation) {
		return false;
	}
	if ($orientation <> 6 and $orientation <> 8) {
//		1 => 'nothing',
//		2 => 'horizontal flip',
//		3 => '180 rotate left',
//		4 => 'vertical flip',
//		5 => 'vertical flip + 90 rotate right',
//		6 => '90 rotate right',
//		7 => 'horizontal flip + 90 rotate right',
//		8 => '90 rotate left'
		return false;
	}
	$img_SJIS = myfile_ENCODE(str_replace('/', DIRECTORY_SEPARATOR, $img_file));
	rotate_jpeg($img_SJIS);
	$attr = getimagesize($img_SJIS);
	$width = $attr[0];
	$height = $attr[1];
	if ($width > $height) {
		write_error_log(PHOTO_ERROR_LOG_FILE, 'exec(rotate)', 'Err_file='.$img_file);
		return '<span class="result">Error</span>';
	}
	$rotate_count++;
	return '<span class="result" style="color: blue;">rotate</span>';
}
function rotate_jpeg($src) {		// SJIS-win
	// auto rotate, optimize, keep current date, keep all markers
	exec('i_view32 "'.$src.'" /jpg_rotate=(6,1,0,1,0,0,0,15) /silent /convert=', $o, $ret);
	return $ret;
}
function img_rotate_OOOOLD($img_file, &$rotate_count) {		// UTF-8
	if (photo_EXIF_AUTO_ROTATE <> 'YES') {
		return;
	}
	$resize_file = resize_filename($img_file, photo_RESIZE_DIR_SMALL);
	$resize_SJIS = myfile_ENCODE(str_replace('/', DIRECTORY_SEPARATOR, $resize_file));
	if (!file_exists($resize_SJIS)) {
		echo '<span class="result">縮小なし</span>';
		return;
	}
	$attr = getimagesize($resize_SJIS);
	$width = $attr[0];
	$height = $attr[1];
	if ($width > $height) {
		echo '<span class="result">-----</span>';
		return;
	}
	$img_SJIS = myfile_ENCODE(str_replace('/', DIRECTORY_SEPARATOR, $img_file));
	$attr = getimagesize($img_SJIS);
	$width = $attr[0];
	$height = $attr[1];
	if ($height > $width) {
		echo '<span class="result">-----</span>';
		return;
	}
	rotate_jpeg($img_SJIS);
/*
	if ($ret <> 0) {	// 成功しても0以外が返る
		write_error_log(PHOTO_ERROR_LOG_FILE, 'exec(rotate)', 'Err_file='.$img_file);
		echo '<span class="result">Error</span>';
		return;
	}
*/
	$attr = getimagesize($img_SJIS);
	$width = $attr[0];
	$height = $attr[1];
	if ($width > $height) {
		write_error_log(PHOTO_ERROR_LOG_FILE, 'exec(rotate)', 'Err_file='.$img_file);
		echo '<span class="result">Error</span>';
		return;
	}
	$rotate_count++;
	echo '<span class="result" style="color: blue;">rotate</span>';
}
?>
