<?php
function file_cipher($src_file, $cipher_seed, $enc_mode='2') {
	$ext = strtolower(strrchr($src_file, '.'));
	if ($ext == '.encode3') {
		$target_file = substr($src_file, 0, strlen($src_file)-8);	// 復号化
		$mode = 'decode3';
	} else if ($ext == '.encode2') {
		$target_file = substr($src_file, 0, strlen($src_file)-8);	// 復号化
		$mode = 'decode2';
	} else if ($ext == '.encode') {
		$target_file = substr($src_file, 0, strlen($src_file)-7);	// 復号化
		$mode = 'decode';
	} else if ($enc_mode == '3') {
		$target_file = $src_file.'.encode3';				// 暗号化
		$mode = 'encode3';
	} else {
		$target_file = $src_file.'.encode2';				// 暗号化
		$mode = 'encode2';
	}
	$src_file_SJIS = myfile_ENCODE($src_file);
	$target_file_SJIS = myfile_ENCODE($target_file);
	if (strncmp($mode, 'decode', 6) == 0 and file_exists($target_file_SJIS)) {
		return ('復号化先のファイル['.$target_file.']が存在します。');
	}
	$fp1 = fopen($src_file_SJIS, 'rb');
	if (!$fp1) {
		return ('元ファイルが開けません。');
	}
	set_time_limit(0);			//実行時間制御なし　max_execution_time
	if ($mode == 'decode' or $mode == 'decode2' or $mode == 'encode2') {
		$fp2 = fopen($target_file_SJIS, 'w');
		fclose($fp2);
		$fp2 = fopen($target_file_SJIS, 'a');
		$seed_len = strlen($cipher_seed);
		while (!feof($fp1)) {
			$src_data = fread($fp1, $seed_len);
			$enc_data = $src_data ^ substr($cipher_seed, 0, strlen($src_data));	// XOR(排他的論理和)で暗号化
			if ($mode == 'decode2' or $mode == 'encode2') {
				$enc_data = ~ $enc_data;	//ビット反転
			}
			if(!$fp2){
				return ('ファイルの書き込みに失敗。');
			}
			fwrite($fp2, $enc_data);
		}
		fclose($fp1);
		fclose($fp2);
	} else {
		include_once 'Crypt/Blowfish.php';
		ini_set('memory_limit', '-1');		//メモリ制限なし (←を設定しても、Out of memoryになる)
		$file_size = filesize($src_file_SJIS);
		if (!defined("CIPHER_FILE_MAX_SIZE")) {
			define("CIPHER_FILE_MAX_SIZE", 100000000);	// 約100MB
		}
		if ($mode == 'encode3' and $file_size > CIPHER_FILE_MAX_SIZE) {
			return ('ファイルサイズが大きすぎるため、暗号化できません。XORで暗号化ならば処理可能です。');
		}
		$src_data = fread($fp1, $file_size);
		fclose($fp1);
		if ($mode == 'encode3') {
			$blowfish = new Crypt_Blowfish($cipher_seed);
			$enc_data = $blowfish->encrypt((base64_encode($src_data)));
		} else if ($mode == 'decode3') {
			$blowfish = new Crypt_Blowfish($cipher_seed);
			$enc_data = base64_decode($blowfish->decrypt($src_data));
		}
		$fp2 = fopen($target_file_SJIS, 'w');
		if (!$fp2) {
			return ('ファイルの書き込みに失敗。');
		}
		fwrite($fp2, $enc_data);
		fclose($fp2);
	}
	return '';
}
?>
