<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("../account/__logincheck.php");
	if (isset($_POST['reset'])) {
		$_SESSION['html_text_url'] = '';
		$_SESSION['html_text_addstr'] = '';
		session_2_cookie();
	} elseif (empty($_POST['gethtml']) && isset($_COOKIE['html_text_url'])) {
		$_SESSION['html_text_url'] = $_COOKIE['html_text_url'];
		$_SESSION['html_text_separator'] = $_COOKIE['html_text_separator'];
		$_SESSION['html_text_addstr'] = $_COOKIE['html_text_addstr'];
		$_SESSION['html_text_minsize'] = $_COOKIE['html_text_minsize'];
		$_SESSION['html_text_table'] = $_COOKIE['html_text_table'];
	} elseif (isset($_POST['gethtml'])) {
		$_SESSION['html_text_url'] = $_POST['url'];
		$_SESSION['html_text_separator'] = $_POST['separator'];
		$_SESSION['html_text_addstr'] = $_POST['addstr'];
		$_SESSION['html_text_minsize'] = $_POST['minsize'];
		$_SESSION['html_text_table'] = $_POST['table'];
		session_2_cookie();
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110622" type="text/css">
<title>HTML テキスト抽出 複数一括</title>
<style type="text/css">
body {
	background-color: #ffffff;
	margin: 10px;
	padding: 0px;
}
#title{
	font-size: 120%;
	font-weight: bold;
}
</style>
<script language="JavaScript">
function textareaBigSmall(obj, bigSmall, min) {
	if (bigSmall == "大") {
		document.getElementById(obj).rows = document.getElementById(obj).rows + 10;
	} else {
		if (document.getElementById(obj).rows > min) {
			document.getElementById(obj).rows = document.getElementById(obj).rows - 10;
		}
	}
}
</script>
</head>
<body>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">HTML テキスト抽出 複数一括</span>
</p>
<form method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
	URL：<br>
	<div class="block_left">
	<textarea id="url" name="url" style="width:560px;" rows="8"><?= $_SESSION['html_text_url'] ?></textarea><br>
	</div>
	<div class="block_left">
		<input type="button" value="小" OnClick="textareaBigSmall('url','小', 5)"><br>
		<input type="button" value="大" OnClick="textareaBigSmall('url','大', 5)">
	</div>
	<div style="clear: both;">
	<span style="color:#8b4513; margin-left:5px;">
	テーブルデータ・セパレータ：<input class="text" type="text" name="separator" size=5 value="<?= $_SESSION['html_text_separator'] ?>">
	テーブル行先頭挿入：<input class="text" type="text" name="addstr" size=16 value="<?= $_SESSION['html_text_addstr'] ?>"><br>
	<label><input type="checkbox" name="table" value="only"<?php if ($_SESSION['html_text_table'] == 'only') echo ' checked'; ?>>テーブルのみ(階層構造には未対応)</label>&nbsp;
	テーブルサイズ：<input class="text" type="text" name="minsize" size=8 value="<?= $_SESSION['html_text_minsize'] ?>">文字以上
	</span>
	<br>
	<input type="submit" name="gethtml" value="テキスト抽出">
	<input type="submit" name="reset" value="リセット">
	</div>
</form>
<?php
	if (isset($_POST['gethtml']) and $_POST['url'] <> '') {
		if (left($_POST['url'],7) <> 'http://') {
			error_exit('http://以外は取得できません。');
		}
		if (HTTP_PROXY_HOST.'' <> '') {
			$proxy = array(
				'http' => array(
					'proxy' => 'tcp://'.HTTP_PROXY_HOST.':'.HTTP_PROXY_PORT,
					'request_fulluri' => true,
				),
			);
			$proxy_context = stream_context_create($proxy);
		} else {
			$proxy_context = NULL;
		}
		$urlary = explode("\n", str_replace(' ','',$_POST['url']));
		$html = '';
		$title = '';
		foreach ($urlary as $url_1) {
			if ($url_1 <> '') {
				$html_1 = get_html(trim($url_1), $proxy_context);
				if ($html_1) {
					if ($title == '') {
						$title = get_intag($html_1,'<title>','</title>',$pos=0);
					}
					if ($_POST['table'] == 'only') {
						$pos = 0;
						while (($table = get_intag_span($html_1, '<table', '</table>', $pos)) <> '') {
							if ($_POST['minsize'] == '') {
								$html .= $table;
							} elseif (mb_strlen($table) > $_POST['minsize']) {
								$html .= $table;
							}
						}
					} else {
						$html .= $html_1;
					}
				}
			}
		}
		if ($html) {
			view_textarea($title, my_strip_tags($html), $url);
		} else {
			error_exit('取得できませんでした。');
		}
	} elseif (isset($_POST['sendmail']) and $_POST['text'] <> '') {
		$title = form_str_filepath(mb_convert_kana($_POST['title'], 'KV', 'UTF-8'));
		$text = form_str_filepath(mb_convert_kana($_POST['text'], 'KV', 'UTF-8'));
		view_textarea($title, $text, $url);
		post_sendmail($title, $text);
	}
?>
<div id="footer" style="margin: 10px 0 0 0;">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function view_textarea($title, $text, $url='') {
//	echo '<p>'.str_replace(chr(10), '<br>', $text).'</p>';
	if (($line = substr_count($text, chr(10))) < 10) {
		$line = 10;
	}
?>
	<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>?#end">
	<input type="hidden" name="url" value="<?= $url ?>">
	件名：<input class="text" type="text" name="title" value="<?= my_htmlspecialchars($title) ?>" size=80><br>
	<div class="block_left">
		<textarea id="text" name="text" style="width:560px;" rows="<?= $line+2 ?>"><?= $text ?></textarea>
	</div>
	<div class="block_left">
		<input type="button" value="小" OnClick="textareaBigSmall('text','小', 15)"><br>
		<input type="button" value="大" OnClick="textareaBigSmall('text','大', 15)">
	</div>
	<a name="end"></a>
	<div style="clear: both; ">
	<p><input type="submit" name="sendmail" value="メール送信"></p>
	</div>
	</form>
<?php
}
function my_strip_tags($str) {
	if ($_SESSION['html_text_addstr'] <> '') {
		$str = str_ireplace('<tr', '__addstr__<tr', $str);
	}
	$str = str_ireplace('<br>', '--(br)--', $str);
	if ($_SESSION['html_text_separator'] <> '') {
		$str = str_ireplace('</td>', $_SESSION['html_text_separator'], $str);
		$str = str_ireplace('</th>', $_SESSION['html_text_separator'], $str);
	} else {
		$str = str_ireplace('</td>', ' ', $str);
		$str = str_ireplace('</th>', ' ', $str);
	}
	$str = str_ireplace('</li>', '--(br)--', $str);
	$str = str_ireplace('</p>', '--(br)--', $str);
	$str = str_ireplace('</div>', '--(br)--', $str);
	$str = str_ireplace('</tr>', '--(br)--', $str);
	$str = preg_replace('@<script[^>]*?>.*?</script>@si', '', $str);	// javascriptを削除
	$str = preg_replace('@<style[^>]*?>.*?</style>@si', '', $str);		// styleを削除
	$str = preg_replace("/\s\s+/", ' ', $str);				// 連続したスペースをスペースに
	$str = str_ireplace("\n", '', $str);					// 改行を除去
	$str = strip_tags($str);
	$search = array ('@&(quot|#34);@i',
			 '@&(amp|#38);@i',
			 '@&(lt|#60);@i',
			 '@&(gt|#62);@i',
			 '@&(nbsp|#160);@i',
			 '@&(iexcl|#161);@i',
			 '@&(cent|#162);@i',
			 '@&(pound|#163);@i',
			 '@&(copy|#169);@i');
	$replace = array ('"',
			  '&',
			  '<',
			  '>',
			  ' ',
			  chr(161),
			  chr(162),
			  chr(163),
			  chr(169));
	$str = preg_replace($search, $replace, $str);
	$str = preg_replace('/\s\s+/', ' ', $str);
	$str = str_ireplace('--(br)--', "\n", $str);
	$str = str_ireplace("\n ", chr(10), $str);
	$str = str_ireplace(" \n", chr(10), $str);
	$str = preg_replace("/\n\n+/", chr(10), $str);				// 連続した改行を1個に
	$str = str_replace('__addstr__ ', '__addstr__', $str);
	$str = str_replace(', ', ',', $str);
	if ($_SESSION['html_text_addstr'] <> '') {
		$str = str_replace('__addstr__', $_SESSION['html_text_addstr'], $str);
	}
	$str = str_replace(",\n", "\n", $str);
	return $str;
}
function post_sendmail($subject, $body) {
	$con = my_mysql_connect(_DB_ACCOUNT_SCHEMA);
	$sql = "SELECT * FROM m_account WHERE id_account = '" . $_SESSION['login_id'] . "' and c_delete = 0";
	$rs_account = my_mysql_query($sql);
	$row = mysql_num_rows($rs_account);
	if ($row == 0) {
		error_exit('アカウントがみつかりません。');
	}
	$rec_account = mysql_fetch_array($rs_account);
	if (($to = $rec_account['c_email_calendar']) == '') {
		error_exit('電子メールアドレスが登録されていません。');
	}
	$con = mysql_close($con);
	$header_from = _SENDMAIL_EMAIL_NAME . ' <'._SENDMAIL_EMAIL_ADDR.'>';
	$ret = my_send_mail(_SENDMAIL_EMAIL_ADDR, $header_from, $to, $subject, $body, _SENDMAIL_HOST, _SENDMAIL_PORT, _SENDMAIL_AUTH_USE, _SENDMAIL_EMAIL_USER, _SENDMAIL_EMAIL_PASS);
	if ($ret) {
		echo '<p class="noramal_msg">メール送信しました。</p>';
	} else {
		error_exit('<p>メール送信でエラーが発生しました。</p>');
	}
}
function get_html($url, $proxy_context) {
	$html = @file_get_contents($url, false, $proxy_context);
	if ($html) {
		return mb_convert_encoding($html, 'UTF-8', MB_CONVERT_ENCODING_AUTO);
	} else {
		return '';
	}
}
function session_2_cookie() {
	setcookie("html_text_url", $_POST['url'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie("html_text_separator", $_POST['separator'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie("html_text_addstr", $_POST['addstr'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie('html_text_minsize', $_SESSION['html_text_minsize'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie('html_text_table', $_SESSION['html_text_table'], time() + LOGIN_COOKIE_EXPIRE, "/");
}
?>
