<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	// 実運用定義ファイルでMeCabのインストールパスを"MECAB_EXE_PATH"で定義してください。
	// 例：	define("MECAB_EXE_PATH", "C:\Program Files\MeCab\bin\mecab.exe");
	if (isset($_POST['reset'])) {
		$str = '';
	} else {
		$str = $_POST['str'];
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110622">
<title>MeCab：漢字読み変換</title>
<style type="text/css">
body {
	background-color: #ffffff;
	margin: 10px;
	padding: 0px;
}
#title{
	font-size: 120%;
	font-weight: bold;
}
</style>
</head>
<body>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">MeCab：漢字読み変換</span>
</p>
<?php
	if (!defined("MECAB_EXE_PATH") || MECAB_EXE_PATH == '') {
		echo '<br><br>MeCabのインストールパスが設定されていません。';
		exit;
	}
?>
<form method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>" style="margin:10px 0;">
	文字列：<input class="text" type="text" name="str" value="<?= $str ?>" style="width:400px;">
	<input type="submit" name="gethtml" value="読み変換">
	<input type="submit" name="reset" value="リセット">
</form>
<?php
	if ($str == '') return;
	$cmd = 'echo ' . myfile_ENCODE($str) .' | "' . MECAB_EXE_PATH . '" -Oyomi';
	$ret = shell_exec($cmd);
?>
<p>読み：<input class="text" type="text" name="str" value="<?= myfile_DECODE($ret) ?>" style="width:700px;"></p>
</body>
</html>
