<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("__define_excel-graph.php");
	my_session_start();
	require("../account/__logincheck.php");
	require("__include-common-excel-graph.php");

	if (!defined("GOOGLE_CHART_COLORS")) {
		define("GOOGLE_CHART_COLORS", "1E90FF,6B8E23,00BFFF,32CD32,4169E1,008080,FF69B4,FF4500,FF8C00,8A2BE2,D2691E,483D8B");
	}
	if ($_GET['g'].'' <> '') {
		$_SESSION['excel_graph_google_type'] = $_GET['g'];
	} elseif ($_SESSION['excel_graph_google_type'].'' == '') {
		$_SESSION['excel_graph_google_type'] = 'vbar';
	}
	if ($_GET['xy'].'' <> '') {
		$_SESSION['excel_graph_data_matrix'] = $_GET['xy'];
	} elseif ($_SESSION['excel_graph_data_matrix'].'' == '') {
		$_SESSION['excel_graph_data_matrix'] = 'row';
	}
	if ($_GET['bs'].'' <> '') {
		$_SESSION['excel_graph_google_bar_shape'] = $_GET['bs'];
	} elseif ($_SESSION['excel_graph_google_bar_shape'].'' == '') {
		$_SESSION['excel_graph_google_bar_shape'] = 'bvs';
	}
	if ($_GET['ps'].'' <> '') {
		$_SESSION['excel_graph_google_pie_shape'] = $_GET['ps'];
	} elseif ($_SESSION['excel_graph_google_pie_shape'].'' == '') {
		$_SESSION['excel_graph_google_pie_shape'] = 'p';
	}
	if ($_GET['rs'].'' <> '') {
		$_SESSION['excel_graph_google_radar_shape'] = $_GET['rs'];
	} elseif ($_SESSION['excel_graph_google_radar_shape'].'' == '') {
		$_SESSION['excel_graph_google_radar_shape'] = 'polygon';
	}
	if ($_GET['w'].'' <> '') {
		$_SESSION['excel_graph_google_width'] = $_GET['w'];
	} elseif ($_SESSION['excel_graph_google_width'].'' == '') {
		$_SESSION['excel_graph_google_width'] = GRAPH_WIDTH;
	}
	$_SESSION['excel_graph_google_height'] = floor(intval($_SESSION['excel_graph_google_width'])*3/4)-50;
?>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER_COMMON ?>/common.css?20120323" type="text/css">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools-excel-graph.css?20110622" type="text/css">
<title>Excel to グラフ by Google Chart API</title>
<script language="javascript" src="scripts/cookie.js" type="text/javascript"></script>
<script type="text/javascript">
function optChange(key, val) {
	window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?" + key + "=" + val;
}
</script>
</head>
<?php	if (($excel_file = post_check('filename')) == True) { ?>
<body>
<?php	} else { ?>
<body>
<?php	} ?>
<h1></h1>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>" enctype="multipart/form-data">
<table id="form_table">
<tr>
	<td align=right>ファイル：</td>
	<td>
		<input type="file" size=40 name="filename" style="button-font-size:small">
		<a href="excel-graph-bluff.php" style="margin-left:16px">by Bluff</a>
		<a href="excel-graph-html5.php" style="margin-left:16px">by HTML5</a>
		<span id="current_title" style="margin-left:16px">by Google</span>
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="submit" name="upload" value="アップロード">
		<input type="submit" name="clear" value="クリア">
		<input type="submit" name="redraw" value="再描画">
	</td>
</tr>
<tr>
	<td align=right>グラフ横幅：</td>
	<td>
		<select name="zoomsize" onChange="optChange('w', this.options[this.selectedIndex].value);">
		<?php 	for ($val=300; $val<=650; $val+=50) { ?>
			<option value="<?= $val ?>"<?= $val==$_SESSION['excel_graph_google_width'] ? ' selected' : '' ?>><?= $val ?></option>
		<?php	} ?>
		</select>
	</td>
</tr>
<tr>
	<td align=right>データ系列：</td>
	<td>
		<input type="button" value="　行　" onClick="optChange('xy','row')">
		<input type="button" value="　列　" onClick="optChange('xy','col')">
	</td>
</tr>
<tr>
	<td align=right>グラフ種類：</td>
	<td>
		<input type="button" value="棒グラフ" onClick="optChange('g','vbar')">
		<input type="button" value="折線グラフ" onClick="optChange('g','line')">
		<input type="button" value="円グラフ(合計)" onClick="optChange('g','pie')">
	</td>
</tr>
<?php	if ($_SESSION['excel_graph_google_type'] == 'vbar') { ?>
<tr>
	<td align=right>棒グラフ：</td>
	<td>
		<input type="button" value="積み上げ" onClick="optChange('bs','bvs')">
		<input type="button" value="重ね合わせ" onClick="optChange('bs','bvg')">
	</td>
</tr>
<?php	} elseif ($_SESSION['excel_graph_google_type'] == 'pie') { ?>
<tr>
	<td align=right>円グラフ：</td>
	<td>
		<input type="button" value="　2D　" onClick="optChange('ps','p')">
		<input type="button" value="　3D　" onClick="optChange('ps','p3')">
	</td>
</tr>
<?php	} ?>
</table>
</form>
<?php
	if ($excel_file) {
		post_done_proc($excel_file);
	}
?>
<div id="footer">
<a href="http://code.google.com/intl/ja/apis/charttools/index.html" target="_blank" style="color:#b0b0ff;">Powered by Google Chart API</a><br />
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function post_done_proc($excel_file) {
	if ($excel_file == EXCEL_FILE_UPLOAD) {
		$attachFile = file_upload_to_name('filename', ATTACH_FILE_FOLDER, EXCEL_FILE_NAME);
		$readFile = ATTACH_FILE_FOLDER.$attachFile;
	} else {
		$readFile = ATTACH_FILE_FOLDER.EXCEL_FILE_NAME;
	}
	require 'phpExcelReader/Excel/Reader.php';
	$excel = new Spreadsheet_Excel_Reader();
	$excel->setUTFEncoder('mb');
	$excel->setOutputEncoding('UTF-8');
	$excel->read($readFile);
	if (!list_table($excel, $dMatrix, $xNums, $yNums, $xNames, $yNames)) {
		return;
	}
	$xLabels = '';
	foreach ($xNames as $name) {
		if ($xLabels <> '') $xLabels .= '|';
		$xLabels .= urlencode($name);
	}
	$yLabels = '';
	foreach ($yNames as $name) {
		if ($yLabels <> '') $yLabels .= '|';
		$yLabels .= urlencode($name);
	}
	$function = 'chart_'.$_SESSION['excel_graph_google_type'];
	if ($_SESSION['excel_graph_data_matrix'] == 'col') {
		$function(swap_matrix($dMatrix), $yNums, $xNums, $yLabels, $xLabels);
	} else {
		$function($dMatrix, $xNums, $yNums, $xLabels, $yLabels);
	}
}
function chart_vbar($dMatrix, $xNums, $yNums, $xLabels, $yLabels) {
	$chData = '';
	$max = 0;
	for ($iy = 0; $iy < $yNums; $iy++) {
		if ($chData <> '') $chData .= '|';
		$xdata = '';
		for ($ix = 0; $ix < $xNums; $ix++) {
			if ($xdata <> '') $xdata .= ',';
			$xdata .= $dMatrix[$iy][$ix];
			if ($dMatrix[$iy][$ix] > $max) $max = $dMatrix[$iy][$ix];
		}
		$total[] = $dMatrix[$iy][$xNums];
		$chData .= $xdata;
	}
	if ($_SESSION['excel_graph_google_bar_shape'] == 'bvs') {
		$markers = 'N,ff0000,-1,,12';
		for ($iy=0; $iy<$yNums; $iy++) {
			$markers .= '|'.'N,ffffff,'.$iy.',,12,,c';
		}
		$total = array();
		for ($ix = 0; $ix < $xNums; $ix++) {
			$total[] = $dMatrix[$yNums][$ix];
		}
		$yMax = max($total) * 1.1;	// Y軸合計の最大値
	} elseif ($_SESSION['excel_graph_google_bar_shape'] == 'bvg') {
		$markers = 'N,000000,0,,12,,c';
		for ($iy=1; $iy<$yNums; $iy++) {
			$markers .= '|'.'N,000000,'.$iy.',,12,,c';
		}
		$yMax = $max * 1.1;
	}
?>
	<div id="chart">
	<img src="http://chart.apis.google.com/chart?cht=<?= $_SESSION['excel_graph_google_bar_shape'] ?>&chs=<?= $_SESSION['excel_graph_google_width'] ?>x<?= $_SESSION['excel_graph_google_height'] ?>&chds=0,<?= $yMax ?>&chxt=x&chts=000000,15&chd=t:<?= $chData ?>&chco=<?= GOOGLE_CHART_COLORS ?>&chbh=r,.6&chm=<?= $markers ?>&chxl=0:|<?= $xLabels ?>&chdl=<?= $yLabels ?>" />
	</div>
<?php
}
function chart_line($dMatrix, $xNums, $yNums, $xLabels, $yLabels) {
	$xup = 100 / ($xNums - 1);
	$xdata = '0';
	for ($ix=1; $ix<$xNums; $ix++) {
		$xdata .= ','.($xup*$ix);
	}
	$chData = '';
	for ($iy = 0; $iy < $yNums; $iy++) {
		if ($chData <> '') $chData .= '|';
		$ydata = '';
		for ($ix = 0; $ix < $xNums; $ix++) {
			if ($ydata <> '') $ydata .= ',';
			$ydata .= $dMatrix[$iy][$ix];
		}
		$chData .= $xdata . '|' . $ydata;
	}
	$markers = 'N,000000,0,,12,,c';
	for ($iy=1; $iy<$yNums; $iy++) {
		$markers .= '|'.'N,000000,'.$iy.',,12,,c';
	}
?>
	<div id="chart">
	<img src="http://chart.apis.google.com/chart?cht=lxy&chs=<?= $_SESSION['excel_graph_google_width'] ?>x<?= $_SESSION['excel_graph_google_height'] ?>&chxt=x&chts=000000,15&chd=t:<?= $chData ?>&chco=<?= GOOGLE_CHART_COLORS ?>&chbh=r,.6&chm=<?= $markers ?>&chxl=0:|<?= $xLabels ?>&chdl=<?= $yLabels ?>" />
	</div>
<?php
}
function chart_pie($dMatrix, $xNums, $yNums, $xLabels, $yLabels) {
	$chData = '';
	for ($ix = 0; $ix < $xNums; $ix++) {
		if ($chData <> '') $chData .= ',';
		$chData .= $dMatrix[$yNums][$ix] / $dMatrix[$yNums][$xNums] * 100;
	}
	$markers = 'N,000000,0,,12,,c';
	for ($iy=1; $iy<$yNums; $iy++) {
		$markers .= '|'.'N,ffffff,'.$iy.',,12,,c';
	}
	if ($_SESSION['excel_graph_google_pie_shape'] == 'p3') {
		$height = floor($_SESSION['excel_graph_google_height']*3/4);
	} else {
		$height = $_SESSION['excel_graph_google_height'];
	}
?>
	<div id="chart">
	<img src="http://chart.apis.google.com/chart?cht=<?= $_SESSION['excel_graph_google_pie_shape'] ?>&chs=<?= $_SESSION['excel_graph_google_width'] ?>x<?= $height ?>&chxt=x&chd=t:<?= $chData ?>&chco=<?= GOOGLE_CHART_COLORS ?>&chm=<?= $markers ?>&chxl=0:|<?= $xLabels ?>&chp=4.71238898" /><!-- chp=4.71238898 : 円グラフを0時から開始させる-->
	</div>
<?php
}
?>
