<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	if ($_SESSION['photo_open_path'] == '') {
		header("Location: index.php");
	}
	if (empty($_SESSION['photo'])) {
		header("Location: index.php");
	}
	if (empty($_SESSION['photo_img_count'])) {
		header("Location: index.php");
	}
	if ($_SESSION['photo_img_count'] < 1) {
		header("Location: index.php");
	}
	$open_path = $_SESSION['photo_open_path'];
	if (defined("photo_LIMITED_IMAGES_FOLDER") and photo_LIMITED_IMAGES_FOLDER <> '') {
		if ($_SESSION['システム管理者'] <> 'YES' or photo_LIMITED_ADMIN_NOLIMIT <> 'YES') {
			$len = strlen(photo_LIMITED_IMAGES_FOLDER);
			if (substr($open_path.'/', 0, $len+1) <> photo_LIMITED_IMAGES_FOLDER.'/') {
				header("Location: index.php");
			}
		}
	}
	if (!defined("MAPS_LINEPATH_COLOR")) {
		define("MAPS_LINEPATH_COLOR", "#ff4500");
	}
	if (!defined("MAPS_LINEPATH_WEIGHT")) {
		define("MAPS_LINEPATH_WEIGHT", 3);
	}
	if (!defined("ALBUM_MAPS_PHOTO_ICON_MARKER_SIZE")) {
		define("ALBUM_MAPS_PHOTO_ICON_MARKER_SIZE", "40,40");
	}
	if (!defined("MAPS_PHOTO_MARKER_DRAGGABLE")) {
		define("MAPS_PHOTO_MARKER_DRAGGABLE", "YES");
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<meta name="description" content="abook">
<meta name="keywords" content="アルバム, マップ">
<title>MyHome アルバム マップ</title>
<script src="../scripts/URLencode.js"></script>
<style>
* { margin: 0px; padding: 0px; }
html {
	width: 100%;
	height: 100%;
	overflow: hidden;
}
form { margin: 0px; }
img { border: 0px; }
body {
	background-color: #ffffff;
	text-align: left;
	font-size: 84%;
	font-family: "ＭＳ Ｐゴシック",arial,helvetica,clean,sans-serif;
	margin: 0;
	width: 100%;
	height: 100%;
}
#page_body {
	width: 100%;
	height: 100%;
}
#page_contents {
	width: 100%;
	height: 100%;
}
#map_canvas {
	width: 100%;
	height: 100%;
}
#maps_filter {
	clear: both;
	margin: 0 0 0 10px;
	padding: 0;
}
.block {
	clear: both;
}
.block_left {
	float: left;
	text-align: left;
	padding: 0;
}
a:link { color: #2128e0; font-weight: normal; }
a:visited { color: #2128e0; font-weight: normal; }
a:hover { color: #f43316; font-weight: normal; background-color: #ffffc0; }
a:active { color: #f43316; font-weight: normal; background-color: #ffffc0; }
#option_box {
	position: absolute; top: 4px; right: 130px; width: 190px; height:11px;
	border: 1px solid #666; padding: 6px; overflow: visible;
	background: #ffffff;
	white-space: nowrap;
	padding: 2px 4px 8px 4px;
}
@media print {
	#option_box { display: none; }
	#map_canvas { position: absolute; top: 0px; left: 0px; }
}
</style>
</head>
<body onload="initialize()">
<?
	google_maps($open_path);
?>
</body>
</html>
<?php
	exit();
?>
<?php
function google_maps($open_path) {
?>
<script src="../scripts/jquery.js"></script>
<script src="http://maps.google.com/maps/api/js?sensor=false&libraries=panoramio,geometry"></script>
<script src="../scripts/encodeURL.js"></script>
<script>
var map;
var geocoder = null;
var maxLat=-999, minLat=999, maxLng=-999, minLng=999;
var notFound = '';
var current_infowin = null;
var panoramioView = false;
var panoramio;
var LinePathUse = false;
var latLngWin;
function initialize() {
	maxLat = -999;
	minLat = 999;
	maxLng = -999;
	minLng = 999;
	var vpoint = Array();
<?php
	$popstr = '';
	$address = '';
	$point_tbl = array();
	$adr_cnt = 0;
	$img_count = $_SESSION['photo_img_count'];
	for ($ix = 0; $ix < $img_count; $ix++) {
		$img_file = $open_path.'/'.$_SESSION['photo'][$ix]['file'];
		if ($lat_lng = exif_gps($img_file)) {
?>
	vpoint[<?= $adr_cnt ?>] = Array();
	vpoint[<?= $adr_cnt ?>]["lat"] = <?= $lat_lng[0] ?>;
	vpoint[<?= $adr_cnt ?>]["lng"] = <?= $lat_lng[1] ?>;
	vpoint[<?= $adr_cnt ?>]["time"] = '<?= $lat_lng[2] ?>';
	vpoint[<?= $adr_cnt ?>]["photo"] = '<?= $img_file ?>';
<?php
			$adr_cnt++;
		}
	}
?>
	geocoder = new google.maps.Geocoder();
	for (var ix=0; ix<<?= $adr_cnt ?>; ix++) {
		var lat = vpoint[ix]["lat"];
		var lng = vpoint[ix]["lng"];
		if (maxLat < lat) maxLat = lat;
		if (minLat > lat) minLat = lat;
		if (maxLng < lng) maxLng = lng;
		if (minLng > lng) minLng = lng;
	}
	if (minLat == maxLat && minLng == maxLng) {
		minLat -= 0.002;		// 1地点の場合、拡大されすぎるのを抑止するため
		minLng -= 0.002;		// initialize()時点では
		maxLat += 0.002;		// map.fitBounds()後にsetZoom()が効かないため
		maxLng += 0.002;		// Lat, Lngを調整してからfitBounds()する
	}
	southWest = new google.maps.LatLng(minLat,minLng);
	northEast = new google.maps.LatLng(maxLat,maxLng);
	bounds = new google.maps.LatLngBounds(southWest,northEast);
	var myOptions = {
		zoom: 15,
		center: new google.maps.LatLng(minLat + maxLat / 2, minLng + maxLng / 2),
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		disableDoubleClickZoom: false,
		streetViewControl: true
	}
	map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
	panoramio = new google.maps.panoramio.PanoramioLayer();
	latLngWin = new google.maps.InfoWindow();
	google.maps.event.addListener(map, 'click', viewLatLngAddress);
	var lineOptions = {
		strokeColor: "<?= MAPS_LINEPATH_COLOR ?>",
		strokeOpacity: 1.0,
		strokeWeight: <?= MAPS_LINEPATH_WEIGHT ?>
	}
	polyline = new google.maps.Polyline(lineOptions);
	polyline.setMap(map);
	google.maps.event.addListener(map, "click", drawLinePath);
	map.fitBounds(bounds);
	showMarker(vpoint, <?= $adr_cnt ?>);
}
function viewLatLngAddress (e) {
	if (LinePathUse) return;
	var latlng = e.latLng;
	var lat = e.latLng.lat().toString();
	var lng = e.latLng.lng().toString();
	geocoder.geocode({'latLng': latlng}, function(results, status) {
		if (status == google.maps.GeocoderStatus.OK) {
			if (results[1]) {
				 address = results[1].formatted_address;
			} else {
				 address = ""
			}
		} else {
			address = ""
		}
		// 標高取得
		var elevation = '';
		var locations = [latlng];
		var elevator = new google.maps.ElevationService();
		elevator.getElevationForLocations({
			locations: locations
		}, function(results, status) {
			if (status == google.maps.ElevationStatus.OK) {
				if (results[0].elevation) {
					elevation = results[0].elevation.toFixed(1);
				}
			}
			html = '緯度：' + lat + '<br>';
			html += '経度：' + lng + '<br><br>';
			html += '住所：' + address + '<br><br>';
			html += '<a href="http://maps.google.com/maps?q=' + encodeURL(lat) + ',' + encodeURL(lng);
			html += '" target="_blank">→ Googleマップ</a>&nbsp;&nbsp;&nbsp;&nbsp;';
			html += '<a href="../tools/google-maps-earth-v3.php?addr=' + encodeURL(lat) + ',' + encodeURL(lng);
			html += '" target="_blank">→ MAP V3</a><br><br>';
			html += '標高：' + elevation + 'm<br><br>';
			latLngWin.setContent(html);
			latLngWin.setPosition(latlng);
			latLngWin.open(map);
		});
	 });
}
var markers = [];
var markerCnt = 0;
function showMarker(vpoint, cnt) {
	for (var ix=0; ix<cnt; ix++) {
		createMarker(vpoint[ix]["lat"], vpoint[ix]["lng"], vpoint[ix]["time"], vpoint[ix]["photo"]);
	}
}
function createMarker(lat, lng, datetime, photo) {
	var icon = null;
	img_src = 'http://<?= $_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']) ?>/img-view.php?img='+photo;
	var html = '<b>' + datetime + '</b><br>';
	html += '緯度：' + lat + '<br>';
	html += '経度：' + lng + '<br>';
	html += '<a href="http://maps.google.com/maps?q=' + lat + ',' + lng;
	html += '" target="_blank">Googleマップ</a><br><br>';
	html += '<a href="'+img_src+'" target="_blank"><img src="'+img_src+'" height="128"></a>';
	icon = new google.maps.MarkerImage(
		img_src,
		new google.maps.Size(<?= ALBUM_MAPS_PHOTO_ICON_MARKER_SIZE ?>),	// size
		new google.maps.Point(0,0),	// origin
		new google.maps.Point(16,16),	// anchor
		new google.maps.Size(<?= ALBUM_MAPS_PHOTO_ICON_MARKER_SIZE ?>)	// scaledSize
	);
	var infowindow = new google.maps.InfoWindow({
		content: html
	});
	var position = new google.maps.LatLng(lat, lng);
	var marker = new google.maps.Marker({
		icon: icon,
		map: map,
		position: position
<?php if (MAPS_PHOTO_MARKER_DRAGGABLE == 'YES') { ?>
		, draggable: true
<?php	 } ?>
	});
	google.maps.event.addListener(marker, 'click', function() {
		if (current_infowin) {
			current_infowin.close();
		}
		infowindow.open(map,marker);
		current_infowin = infowindow;
	});
	markerCnt++;
	markers[markerCnt] = marker;
}
function LinePathOnOff() {
	if (LinePathUse) {
		LinePathUse = false;
	} else {
		LinePathUse = true;
	}
}
function drawLinePath(event) {
	if (LinePathUse) {
		lpath = polyline.getPath();
		lpath.push(event.latLng);
		kyori = google.maps.geometry.spherical.computeLength(lpath.getArray());
	//	document.getElementById("lineLength").value = kyori.toFixed(1);
		document.getElementById("lineLength").value = num_format(kyori,1);
	}
}
function clearLinePath() {
	polyline.setMap(null);
	var lineOptions = {
		strokeColor: "<?= MAPS_LINEPATH_COLOR ?>",
		strokeOpacity: 1.0,
		strokeWeight: <?= MAPS_LINEPATH_WEIGHT ?>
	}
	polyline = new google.maps.Polyline(lineOptions);
	polyline.setMap(map);
	google.maps.event.addListener(map, "click", drawLinePath);
	document.getElementById("lineLength").value = "";
}
function num_format(num, col) {
	if (col) {	// 小数点以下表示桁数
		multiple = 1;
		for (ix=1;ix<=col;ix++) {
			multiple *= 10;
		}
		num = Math.round(num * multiple) / multiple;
	} else {
		num = Math.round(num);
	}
	var str = new String(num).replace(/,/g/"");
	while(str != (str = str.replace(/^(-?\d+)(\d{3})/,"$1,$2")));
	return str;
}
</script>
<div id="map_canvas"></div>
<div id="option_box">
	<label><input id="cb_path" type="checkbox" value="on" onclick="LinePathOnOff()" style="margin:3px 0 0 0;"><span style="vertical-align:top;line-height:18px;">距離:</span></label><span style="font-size:10px;line-height:1.0;margin:0;padding:0;"><input type="text" id="lineLength" style="width:60px;font-size:10px;vertical-align:top;">m</span>
	<input onclick="clearLinePath();" type="button" value="クリア" style="font-size:10px;font-size:8px\9;line-height:1.0;vertical-align:top;">
	<label><input type="checkbox" value="on" onclick="PanoramioOnOff(this)" style="margin:3px 0 0 0;"><span style="vertical-align:top;line-height:18px;">写真</span></label>
<script>
function PanoramioOnOff(my) {
	if (my.checked) {
		panoramio.setMap(map);
	} else {
		panoramio.setMap(null);
	}
}
</script>
</div>
<?php
}
function exif_gps($file) {
	$exif = @exif_read_data(myfile_ENCODE($file));
	if (!$exif) {
		return false;
	}
	if ($exif['GPSLatitude'] and $exif['GPSLongitude']) {
		$lat = gps_degree($exif['GPSLatitude'], $exif['GPSLatitudeRef']);
		$lng = gps_degree($exif['GPSLongitude'], $exif['GPSLongitudeRef']);
		if ($lat and $lng) {
			return array($lat, $lng, $exif['DateTimeOriginal']);
		} else {
			return false;
		}
	}
	return false;
}
function gps_degree($gps, $ref) {
	if (count($gps) != 3) return false;
	if ($ref == 'S' or $ref == 'W') {
		$pm = -1;
	} else {
		$pm = 1;
	}
	$degree = fraction2number($gps[0])*1;
	$minute = fraction2number($gps[1])*1;
	$second = fraction2number($gps[2])/100;
	return ($degree + $minute/60 + $second/3600) * $pm;
}
function fraction2number($value) {
	$fraction = explode('/', $value);
	if (count($fraction) != 2) return 0;
	return (double)$fraction[0] / (double)$fraction[1];
}
?>
