/*
 * AJAX-enabled Sticky Notes With PHP & jQuery
 * http://tutorialzine.com/2010/01/sticky-notes-ajax-php-jquery/
 * 
 * Edited by ok.2nd
*/
$(document).ready(function(){
	var tmp;
	$('.note').each(function(){
		tmp = $(this).css('z-index');
		if(tmp>zIndex) zIndex = tmp;
	})
	make_draggable($('.note'));
	$("#addButton").fancybox({
		'zoomSpeedIn'		: 600,
		'zoomSpeedOut'		: 500,
		'easingIn'		: 'easeOutBack',
		'easingOut'		: 'easeInBack',
		'hideOnContentClick'	: false,
		'padding'		: 15
	});
	$(".editButton").fancybox({
		'zoomSpeedIn'		: 600,
		'zoomSpeedOut'		: 500,
		'easingIn'		: 'easeOutBack',
		'easingOut'		: 'easeInBack',
		'hideOnContentClick'	: false,
		'padding'		: 15
	});
	$('.pr-body').live('keyup',function(e){
		if(!this.preview)
			this.preview=$('#fancy_ajax .note');
		this.preview.find($(this).attr('class').replace('pr-','.')).html($(this).val().replace(/<[^>]+>/ig,'').replace(/\n/ig,"<br>"));
	});
	$('.color').live('click',function(){
		$('#fancy_ajax .note').removeClass('yellow green blue pink orange').addClass($(this).attr('class').replace('color',''));
	});
	$('#note-submit-add').live('click',function(e){
		$(this).replaceWith('<img src="img/ajax_load.gif" style="margin:30px auto;display:block" />');
		var data = {
			'zindex'	: ++zIndex,
			'cat'		: $('#cat').val(),
			'body'		: $('.pr-body').val(),
			'color'		: $.trim($('#fancy_ajax .note').attr('class').replace('note',''))
		};
		$.post('insert.php',data,function(msg){
			if(parseInt(msg)) {
				var tmp = $('#fancy_ajax .note').clone();
				tmp.find('span.data').text(msg).end().css({'z-index':zIndex,top:0,left:0});
				tmp.appendTo($('#board'));
				make_draggable(tmp)
			}
			$("#addButton").fancybox.close();
		});
		$(".editButton").css("display","inline");
		e.preventDefault();
	})
	$('#note-submit-update').live('click',function(e){
		$(this).replaceWith('<img src="img/ajax_load.gif" style="margin:30px auto;display:block" />');
		id = $('.id').val();
		body = $('.pr-body').val();
		color = $.trim($('#fancy_ajax .note').attr('class').replace('note',''));
		var data = {
			'zindex'	: ++zIndex,
			'id'		: id,
			'body'		: body,
			'color'		: color
		};
		$.post('update.php',data,function(msg){
			if(parseInt(msg)) {
				$('#t'+id).html(body.replace(/\n/ig,"<br>"));
			}
			$(".editButton").fancybox.close();
		});
		$('#s'+id).removeClass('yellow green blue pink orange').addClass(color);
		e.preventDefault();
	})
	$('#note-submit-delete').live('click',function(e){
		$(this).replaceWith('<img src="img/ajax_load.gif" style="margin:30px auto;display:block" />');
		id = $('.id').val();
		var data = {
			'id'	: $('.id').val()
		};
		$.post('delete.php',data,function(msg){
			if(parseInt(msg)) {
				$('#s'+id).css("display","none");
			}
			$(".editButton").fancybox.close();
		});
		e.preventDefault();
	})
	$('.note-form').live('submit',function(e){e.preventDefault();});
});
var zIndex = 0;
function make_draggable(elements) {
	elements.draggable({
		containment:'parent',
		start:function(e,ui){ ui.helper.css('z-index',++zIndex); },
		stop:function(e,ui){
			$.get('update_position.php',{
				  x	: ui.position.left,
				  y	: ui.position.top,
				  z	: zIndex,
				  id	: parseInt(ui.helper.find('span.data').html())
			});
		}
	});
}
