<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("__define_code-file.php");
	require("__include-common-code-file.php");
	my_session_start();
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (FILE_MANAGER_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
	if (!defined("FILE_MANAGER_DEFAULT_FOLDER")) {
		define("FILE_MANAGER_DEFAULT_FOLDER", $_SERVER['DOCUMENT_ROOT']);
	}
	if ($_POST['path'].'' <> '') {
		$open_path = form_str_filepath($_POST['path']);
	} elseif ($_GET['path'].'' <> '') {
		$open_path = my_GET('path');
	}
	$open_path = str_replace(DIRECTORY_SEPARATOR, "/", right_slash_strip($open_path));
	if ($open_path == "") {
		$open_path = FILE_MANAGER_DEFAULT_FOLDER;
	}
	if (isset($_POST['search_key']) && $_POST['search_key'].'' <> '') {
		$_SESSION['file_manager_search_key'] = $_POST['search_key'];
	} elseif ($_GET['key'].'' <> '') {
		$_SESSION['file_manager_search_key'] = $_GET['key'];
	}
	if (isset($_POST['search_reset'])) {
		$_SESSION['file_manager_search_key'] = '';
	}
	if ($_GET['sort'].'' <> '') {
		$_SESSION['file_manager_sort'] = $_GET['sort'];
	}
	if ($_GET['order'].'' <> '') {
		$_SESSION['file_manager_sort_order'] = $_GET['order'];
	}
	$file_mode = folder_check($open_path, $path_SJIS, $error_msg);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<meta name="description" content="ファイルマネージャー,ファイル暗号化">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20120406">
<style>
div#header {
	margin: 5px;
}
div#body {
	margin: 0px;
}
div#footer {
	margin: 5px;
}
div#print_dir {
	margin: 5px;
}
div#print_file {
	margin: 5px;
}
div#change_file_type {
	margin: 5px;
}
#selected_type {
	background-color: #ffc080;
}
.file_list {
	font-family: arial,sans-serif;
}
.file_list a:link { color: #101010; }
.file_list a:visited { color: #101010; }
.file_list a:hover { color: #ff0000; }
.file_list a:active { color: #ff0000; }
ul.file_list {
	margin: 10px 0 5px 10px;
}
td.file_list {
	padding-left: 10px;
}
td.file_size {
	padding: 1px 0 1px 10px;
	text-align: right;
}
td.file_time {
	padding: 1px 0 1px 10px;
}
td.file_type {
	padding: 1px 0 1px 0;
}
th.file_list {
	padding-left: 34px;
	background-color: #e0e0ff;
}
th.file_size {
	padding: 1px 0 1px 10px;
	text-align: right;
	color: #101010;
	background-color: #e0e0ff;
}
th.file_time {
	padding: 1px 0 1px 10px;
	background-color: #e0e0ff;
}
th.file_type {
	padding: 1px 0 1px 10px;
	background-color: #e0e0ff;
}
th a:link { color: #101010; font-weight: bold;}
th a:visited { color: #101010; font-weight: bold;}
th a:hover { color: #ff0000; font-weight: bold;}
th a:active { color: #ff0000; font-weight: bold;}
a.edit_btn {
	margin: 0 2px 0 2px;
}
a.edit_btn:link  { color: #ff8000; font-weight: normal;}
a.edit_btn:visited { color: #ff8000; font-weight: normal;}
a.edit_btn:hover { color: #ff0000; font-weight: normal; background-color: #f0f0f0}
a.edit_btn:active { color: #ff0000; font-weight: normal; background-color: #e0e0e0}
.order_mark {
	font-size: 80%;
	color: #808080;
	padding-left: 2px;
}
.file_folder {
	background-image: url(icon/folder.gif);
	background-repeat: no-repeat;
	background-position: top left;
	list-style: none;
	list-style-type: none;
	margin: 2px 0 2px 0;
	padding-left: 24px;
	font-size: 16px;
}
.file_php {
	background-image: url(icon/php.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_py {
	background-image: url(icon/python.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_yaml {
	background-image: url(icon/python.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_js {
	background-image: url(icon/js.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_html {
	background-image: url(icon/html.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
}
.file_css {
	background-image: url(icon/css.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_txt {
	background-image: url(icon/txt.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_xml{
	background-image: url(icon/txt.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_sql {
	background-image: url(icon/sql.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
}
.file_zip {
	background-image: url(icon/zip.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_other {
	background-image: url(icon/other.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_encode {
	background-image: url(icon/encode.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_photo {
	background-image: url(icon/photo.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_image {
	background-image: url(icon/palette.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_pdf {
	background-image: url(icon/pdf.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_excel {
	background-image: url(icon/excel.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_word {
	background-image: url(icon/word.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_powerpoint {
	background-image: url(icon/powerpoint.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_access {
	background-image: url(icon/access.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_csv {
	background-image: url(icon/csv.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_gps {
	background-image: url(icon/gps.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_movie {
	background-image: url(icon/film.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.encode_file {
	color: red;
	font-weight: bold;
}
p#file_name_box {
	margin: 3px 0 0 0;
}
p#create_folder {
	margin: 3px 0 0 0;
}
span#file_name {
	text-decoration: underline;
	background-color: #e0f0ff;
	border: 0px;
	padding: 1px 4px 1px 4px;
}
span#file_encode {
	background-color: #fff0e0;
	border: 0px;
	padding: 1px 4px 1px 4px;
}
html>/**/body #filemanager_body input[type="button"] {	/* IE以外 */
	padding: 0 2px;
	line-height: 1em;
}
#filemanager_body input[type="button"], x:-moz-any-link {	/* Firefox */
	height: 1.5em;
}
*+html #filemanager_body input[type="button"] {	/* IE */
	height: 1.5em;
}
*html #filemanager_body input[type="button"]) {	/* IE6 */
	height: 1.5em;
}
</style>
<link rel="stylesheet" href="../scripts/tablesorter/themes/blue/style-ok2nd.css">
<script src="../scripts/jquery.js"></script>
<script src="../scripts/jquery.cookie.js"></script>
<script>
$(function(){
	get_ajax_dir();
	get_ajax_file();
});
function get_ajax_dir() {
	$.ajax({
		type: "POST",
		url: "file-manager-ajax.php?get=dir&path=<?= urlencode($open_path) ?>",
		async: false,
		success: function(res){
			$("#print_dir").html(res);
		}
	})
}
function get_ajax_file() {
	$.ajax({
		type: "POST",
		url: "file-manager-ajax.php?get=file&path=<?= urlencode($open_path) ?>",
		async: false,
		success: function(res){
			$("#print_file").html(res);
			table_sort();
		}
	})
}
</script>
<script src="../scripts/tablesorter/jquery.tablesorter-ok2nd.js"></script>
<script src="../scripts/tablesorter/docs/js/chili/chili-1.8b.js"></script>
<script src="../scripts/tablesorter/docs/js/docs.js"></script>
<script id="js">
var tablesort_cookiename = 'file_manager';
var sort_column = <?= $_COOKIE['file_manager_sort_column']?$_COOKIE['file_manager_sort_column']:0 ?>;
var sort_order = <?= $_COOKIE['file_manager_sort_order']?$_COOKIE['file_manager_sort_order']:0 ?>;
function table_sort() {
	$("#sorttable").tablesorter({
		sortList: [[sort_column,sort_order]],
		headers: { 1: {sorter:"currency"} }
	});
}
</script>
<script src="../scripts/URLencode.js"></script>
<script>
function rename_file(path, fname){
	fname = window.prompt("新しいファイル名を入れてください。", fname);
//	window.alert(fname);
	$.ajax({
		type: "POST",
		url: 'file-rename.php?path='+URLencode(path)+'&new='+URLencode(fname),
		async: false,
		success: function(res){
			get_ajax_file();
		}
	})
}
function copy_file(path){
	$.ajax({
		type: "POST",
		url: 'file-copy.php?path='+URLencode(path),
		async: false,
		success: function(res){
			get_ajax_file();
		}
	})
}
function delete_file(path){
	fname = path.substring(path.lastIndexOf('/')+1);
	if (window.confirm('ファイル「'+fname+'」を削除しますか？')) {
		$.ajax({
			type: "POST",
			url: 'file-delete.php?path='+URLencode(path),
			async: false,
			success: function(res){
				get_ajax_file();
			}
		})
	} else {
		//window.alert('キャンセルされました');
	}
}
function unzip_file(path, dest){
	dest = window.prompt("解凍先フォルダ名を入れてください。\nフォルダ名を省略するとカレントフォルダに(上書き)解凍します。", dest);
	$.ajax({
		type: "POST",
		url: 'file-unzip.php?path='+URLencode(path)+'&dest='+URLencode(dest),
		async: false,
		success: function(res){
			get_ajax_dir();
		}
	})
}
function cipher_file(path){
	if (document.getElementById('encode_mode').checked) {
		mode = 2;
	} else {
		mode = 3;
	}
	$.ajax({
		type: "POST",
		url: 'file-cipher.php?path='+URLencode(path)+'&mode='+mode,
		async: false,
		success: function(res){
			get_ajax_file();
		}
	})
}
function create_folder(){
	$.ajax({
		type: "POST",
		url: 'folder-create.php?path=<?= urlencode($open_path) ?>&new='+URLencode(document.form0.create_folder_name.value),
		async: false,
		success: function(res){
			get_ajax_dir();
		}
	})
}
function rename_folder(path, fname){
	fname = window.prompt("新しいフォルダ名を入れてください。", fname);
//	window.alert(fname);
	$.ajax({
		type: "POST",
		url: 'folder-rename.php?path='+URLencode(path)+'&new='+URLencode(fname),
		async: false,
		success: function(res){
			get_ajax_dir();
		}
	})
}
function copy_folder(path){
	$.ajax({
		type: "POST",
		url: 'folder-copy.php?path='+URLencode(path),
		async: false,
		success: function(res){
			get_ajax_dir();
		}
	})
}
function delete_folder(path){
	fname = path.substring(path.lastIndexOf('/')+1);
	if (window.confirm('フォルダ「'+fname+'」を削除しますか？')) {
		$.ajax({
			type: "POST",
			url: 'folder-delete.php?path='+URLencode(path),
			async: false,
			success: function(res){
				get_ajax_dir();
			}
		})
	} else {
		//window.alert('キャンセルされました');
	}
}
</script>
<title>ファイルマネージャー（暗号化/復号化付き）</title>
</head>
<body>
<p id="tool_title_area">
<a href="../tools/" class="return_index">■</a>
<span id="tool_title">ファイルマネージャー（暗号化/復号化付き）</span>
<a style="margin-left:20px;" href="code-file-view.php?path=<?= urlencode($open_path) ?>">→ PHP/JavaScript ソースコード表示</a>
</p>
<div id="header">
	<form name="form0" action="<?= $_SERVER['SCRIPT_NAME'] ?>" method="post">
		<input type="button" name="" value="↑" onClick="location.href='<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode(up_folder_path($open_path)) ?>'">
		<input class="text" type="text" id="path" name="path" value="<?= my_htmlspecialchars($open_path) ?>" size=60>
		<input type="submit" name="path_change" value="変更">
		ファイル/フォルダ名：<input class="text<?= $_SESSION['file_manager_search_key'] <> '' ? ' list_filter_true' : '' ?>" type="text" name="search_key" value="<?= my_htmlspecialchars($_SESSION['file_manager_search_key']) ?>" size=16>
		<input type="submit" name="search" value="検索">
		<input type="submit" name="search_reset" value="リセット">
		<br>
		<p id="file_name_box">カレント・フォルダ：<span><?= up_folder_direct('?path=', $open_path) ?></span></p>
		<p id="create_folder">作成フォルダ名：<input class="text" type="text" name="create_folder_name" value="" size=30>
		<input type="button" name="" value="フォルダ作成" onClick="create_folder()">
		</p>
	</form>
	<form action="file-upload-single.php?path=<?= urlencode($open_path) ?>" method="post" enctype="multipart/form-data">
		ファイル・アップロード：<input type="file" size=40 name="filename" style="button-font-size:small;">
		<input class="input_form_button" type="submit" name="登録" value="登録">
		<?php	if (strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) { ?>
		<a href="file-upload.php?path=<?= urlencode($open_path) ?>" style="margin-left:10px;">複数ファイル・一括アップロード</a>
		<?php	} else { ?>
		<a href="file-upload-drag.php?path=<?= urlencode($open_path) ?>" style="margin-left:10px;">複数ファイル・一括アップロード</a>
		<?php	} ?>
	</form>
</div>
<div id="filemanager_body">
<?php
	if ($file_mode == 'Folder') {
		view_folder($open_path, $path_SJIS, $_SESSION['file_manager_search_key']);
	} else {
		echo '<p class="error_msg">'.$error_msg.'</p>';
	}
?>
</div>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function view_folder($open_path, $path_SJIS, $search_key) {
?>
	<div id="print_dir"></div>
	<div>
	<?php if (defined("FILE_MANAGER_CIPHER_SEED") and FILE_MANAGER_CIPHER_SEED <> '') { ?>
		<p style="margin: 5px 0 0 20px; color:green">
		※ 暗号化は、すでに暗号化ファイルがあった場合、上書き処理します。<br>
		※ 復号化は、元ファイルがある場合、エラーとします。<br>
		※ unZipは、元のタイムスタンプは保存されません。<br>
		※ 暗号化/復号化/unZipは、ファイルサイズが大きいとかなり処理時間がかかります。
		</p>
		<p style="margin: 0 0 5px 20px;">
		<input type="button" class="copy_button" value="Ｃ">：コピー
		<input type="button" class="copy_button" value="Ｒ">：リネーム
		<input type="button" class="copy_button" value="Ｄ">：削除
		<label><input type="checkbox" id="encode_mode" value="2"<? if ($_SESSION['file_manager_encode_mode'] == '2') echo ' checked'; ?>>XORで暗号化(暗号化キーコードが推測されるリスクがあります)</label>
		</p>
	<?php } else {?>
		<p style="margin: 10px 0 10px 20px; color:red">
		※ 実運用定義ファイルで、FILE_MANAGER_CIPHER_SEEDが定義されていないと暗号化/復号化はできません。<br>
		</p>
	<?php } ?>
	</div>
	<div id="print_file"></div>
<?php
}
function folder_check($open_path, &$path_SJIS, &$error_msg) {
	$path_SJIS = myfile_ENCODE($open_path);
	if (file_exists($path_SJIS)) {
		if (is_dir($path_SJIS)) {
			return 'Folder';
		} else {
			$error_msg =  'ファイル『 '.$open_path.' 』は表示できません。';
			return 'File';
		}
	} else {
		$error_msg =  'フォルダまたはファイル『 '.$open_path.' 』が、みつかりません。';
		return 'Error';
	}
}
?>
