<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("__define_excel-graph.php");
	my_session_start();
	require("../account/__logincheck.php");
	require("__include-common-excel-graph.php");

	if ($_GET['g'].'' <> '') {
		$_SESSION['excel_graph_html5_graph'] = $_GET['g'];
	} elseif ($_SESSION['excel_graph_html5_graph'].'' == '') {
		$_SESSION['excel_graph_html5_graph'] = "vbar";
	}
	if ($_GET['xy'].'' <> '') {
		$_SESSION['excel_graph_data_matrix'] = $_GET['xy'];
	} elseif ($_SESSION['excel_graph_data_matrix'].'' == '') {
		$_SESSION['excel_graph_data_matrix'] = 'row';
	}
	if ($_GET['bs'].'' <> '') {
		$_SESSION['excel_graph_html5_bar_shape'] = $_GET['bs'];
	} elseif ($_SESSION['excel_graph_html5_bar_shape'].'' == '') {
		$_SESSION['excel_graph_html5_bar_shape'] = "square";
	}
	if ($_GET['rs'].'' <> '') {
		$_SESSION['excel_graph_html5_radar_shape'] = $_GET['rs'];
	} elseif ($_SESSION['excel_graph_html5_radar_shape'].'' == '') {
		$_SESSION['excel_graph_html5_radar_shape'] = "polygon";
	}
	if ($_GET['w'].'' <> '') {
		$_SESSION['excel_graph_html5_width'] = $_GET['w'];
	} elseif ($_SESSION['excel_graph_html5_width'].'' == '') {
		$_SESSION['excel_graph_html5_width'] = GRAPH_WIDTH;
	}
	$_SESSION['excel_graph_html5_height'] = floor(intval($_SESSION['excel_graph_html5_width'])*3/4);
?>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<!--DOCTYPEを指定すると、IE6でレーダーチャートと折線グラフのグラフと背景が分離してしまう。-->
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER_COMMON ?>/common.css?20130927">
<link rel="stylesheet" href="<?= _STYLE_SHEET_BUTTON ?>">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools-excel-graph.css?20110622">
<title>Excel to グラフ by HTML5</title>
<!--
■ Spreadsheet_Excel_Reader
	http://sourceforge.net/projects/phpexcelreader/
		http://www.ilovex.co.jp/Division/SRD/archives/2007/08/phpexcel_2.html
		http://q.hatena.ne.jp/1207023049
■ グラフ作成ライブラリ: HTML5
	http://www.html5.jp/library/index.html
■ IEでCanvasを利用するためのライブラリ:ExplorerCanvas
	http://excanvas.sourceforge.net/
		http://d.hatena.ne.jp/unageanu/20070921/1190377760
-->
<script src="scripts/html5jp/graph/<?= $_SESSION['excel_graph_html5_graph'] ?>.js"></script>
<!--[if IE]><script src="scripts/excanvas/excanvas-compressed.js"></script><![endif]-->
<script src="scripts/cookie.js"></script>
<script>
function onLoad() {
	graphHTML5();
}
function optChange(key, val) {
	window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?" + key + "=" + val;
}
</script>
</head>
<?php	if (($excel_file = post_check('filename')) == True) { ?>
<body onload="onLoad()">
<?php	} else { ?>
<body>
<?php	} ?>
<h1></h1>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>" enctype="multipart/form-data">
<table id="form_table">
<tr>
	<td align=right>ファイル：</td>
	<td>
		<input type="file" size=40 name="filename" style="button-font-size:small">
		<a href="excel-graph-bluff.php" style="margin-left:16px">by Bluff</a>
		<span id="current_title" style="margin-left:16px">by HTML5</span>
		<a href="excel-graph-google.php" style="margin-left:16px">by Google</a>
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="submit" name="upload" value="アップロード">
		<input type="submit" name="clear" value="クリア">
		<input type="submit" name="redraw" value="再描画">
	</td>
</tr>
<tr>
	<td align=right>グラフ横幅：</td>
	<td>
		<select name="zoomsize" onChange="optChange('w', this.options[this.selectedIndex].value);">
		<?php 	for ($val=300; $val<=800; $val+=50) { ?>
			<option value="<?= $val ?>"<?= $val==$_SESSION['excel_graph_html5_width'] ? ' selected' : '' ?>><?= $val ?></option>
		<?php	} ?>
		</select>
	</td>
</tr>
<tr>
	<td align=right>データ系列：</td>
	<td>
		<input type="button" value="　行　" onClick="optChange('xy','row')">
		<input type="button" value="　列　" onClick="optChange('xy','col')">
	</td>
</tr>
<tr>
	<td align=right>グラフ種類：</td>
	<td>
		<input type="button" value="棒グラフ" onClick="optChange('g','vbar')">
		<input type="button" value="レーダーチャート" onClick="optChange('g','radar')">
		<input type="button" value="折線グラフ" onClick="optChange('g','line')">
		<input type="button" value="円グラフ(合計)" onClick="optChange('g','circle')">
	</td>
</tr>
<?php	if ($_SESSION['excel_graph_html5_graph'] == 'vbar') { ?>
<tr>
	<td align=right>棒グラフ：</td>
	<td>
		<input type="button" value="　角柱　" onClick="optChange('bs','square')">
		<input type="button" value="　円中　" onClick="optChange('bs','cylinder')">
		<input type="button" value="平坦（影あり）" onClick="optChange('bs','flat')">
		<input type="button" value="平坦（影なし）" onClick="optChange('bs','line')">
	</td>
</tr>
<?php	} elseif ($_SESSION['excel_graph_html5_graph'] == 'radar') { ?>
<tr>
	<td align=right>レーダー：</td>
	<td>
		<input type="button" value="　多角形　" onClick="optChange('rs','polygon')">
		<input type="button" value="　　円　　" onClick="optChange('rs','circle')">
	</td>
</tr>
<?php	} ?>
</table>
</form>
<?php
	if ($excel_file) {
		post_done_proc($excel_file);
	}
?>
<div id="footer">
<a href="http://www.html5.jp/library/index.html" target="_blank" style="color:#b0b0ff;">Powered by HTML5.JP</a><br />
<a href="http://sourceforge.net/projects/phpexcelreader" target="_blank" style="color:#b0b0ff;">Powered by Spreadsheet_Excel_Reader</a><br />
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function post_done_proc($excel_file) {
	if ($excel_file == EXCEL_FILE_UPLOAD) {
		$attachFile = file_upload_to_name("filename", ATTACH_FILE_FOLDER, EXCEL_FILE_NAME);
		$readFile = ATTACH_FILE_FOLDER.$attachFile;
	} else {
		$readFile = ATTACH_FILE_FOLDER.EXCEL_FILE_NAME;
	}
	require 'phpExcelReader/Excel/Reader.php';
	$excel = new Spreadsheet_Excel_Reader();
	$excel->setUTFEncoder('mb');
	$excel->setOutputEncoding('UTF-8');
	$excel->read($readFile);
	if (!list_table($excel, $dMatrix, $xNums, $yNums, $xNames, $yNames)) {
		return;
	}
	if ($_SESSION['excel_graph_data_matrix'] == 'col') {
		graph_view(swap_matrix($dMatrix), $yNums, $xNums, $yNames, $xNames);
	} else {
		graph_view($dMatrix, $xNums, $yNums, $xNames, $yNames);
	}
}
function graph_view($dMatrix, $xNums, $yNums, $xNames, $yNames) {
	if ($_SESSION['excel_graph_html5_graph'] == 'circle') {
		$items = '';
		for ($ix = 0; $ix < $xNums; $ix++) {
			if ($items <> '') $items .= ',';
			$items .= '["'.$xNames[$ix].'",'.$dMatrix[$yNums][$ix].']';
		}
	} else {
		$items = '';
		for ($iy = 0; $iy < $yNums; $iy++) {
			if ($items <> '') $items .= ',';
			$xdata = '';
			for ($ix = 0; $ix < $xNums; $ix++) {
				if ($xdata <> '') $xdata .= ',';
				$xdata .= $dMatrix[$iy][$ix];
			}
			$total[] = $dMatrix[$iy][$xNums];
			$items .= '["'.$yNames[$iy].'",'.$xdata.']';
		}
	}
	$xLabels = '';
	foreach ($xNames as $name) {
		if ($xLabels <> '') $xLabels .= ',';
		$xLabels .= '"'.$name.'"';
	}
	if ($_SESSION['excel_graph_html5_graph'] == 'vbar' or $_SESSION['excel_graph_html5_graph'] == 'line') {
		$parms = 'x: ["",'.$xLabels.'] '.', y: [""]';
	} elseif ($_SESSION['excel_graph_html5_graph'] == 'radar') {
		$parms = 'aCap: ['.$xLabels.'] ';
	}
?>
<script>
function graphHTML5() {
	var graph = new html5jp.graph.<?= $_SESSION['excel_graph_html5_graph'] ?>("graph_canvas");
	if( ! graph ) { return; }
	var items = [ <?= $items ?> ];
	var params = {
	<?= $parms ?>
<?php	if ($_SESSION['excel_graph_html5_graph'] == 'vbar') { ?>
	, gGradation: false
	, barShape: "<?= $_SESSION['excel_graph_html5_bar_shape'] ?>"
<?php	} elseif ($_SESSION['excel_graph_html5_graph'] == 'radar') { ?>
	, chartShape: "<?= $_SESSION['excel_graph_html5_radar_shape'] ?>"
<?php	} elseif ($_SESSION['excel_graph_html5_graph'] == 'circle') { ?>
	shadow: false
<?php	} ?>
	};
	graph.draw(items, params);
}
</script>
<div class="canvas"><canvas id="graph_canvas" width="<?= $_SESSION['excel_graph_html5_width'] ?>" height="<?= $_SESSION['excel_graph_html5_height'] ?>"></canvas></div>
<?php
}
?>
