<?php
// by http://developer.hatena.ne.jp/ja/documents/keyword/apis/autolink
// by http://developer.yahoo.co.jp/webapi/jlp/keyphrase/v1/extract.html
// by http://pmtarantino.github.io/wikiUp/
	require('XML/RPC.php');
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("../account/__logincheck.php");
	if(isset($_POST['sentence'])) {
		$sentence = form_str_adjust($_POST['sentence']);
	} else {
		$sentence = '';
	}
	// Yahoo! JAPAN アプリケーションID
	if (defined("YAHOO_JAPAN_APPLICATION_ID_KEYPHRASE")) {
		$appid = YAHOO_JAPAN_APPLICATION_ID_KEYPHRASE;
	} else {
		$appid = '';
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<title>はてなキーワード自動リンク & Yahoo!キーフレーズ → Weblio</title>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20120406">
<!--<link rel="stylesheet" href="../scripts/wikiUp/wikiUp.css">-->
<style>
body {
	background-color: #ffffff;
	margin: 10px;
	padding: 0px;
}
#title{
	font-size: 120%;
	font-weight: bold;
}
table#hatena td {
	border: 1px solid #888;
	margin: 4px 0;
	padding: 5px;
	line-height: 18px;
}
table#yahoo td {
	border: none;
	margin: 0;
	padding: 0;
	line-height: 14px;
}
</style>
<script src="../scripts/jquery-1.8.3.js"></script>
<!--<script src="../scripts/wikiUp/wikiUp.js"></script>-->
<script>
function clear_text() {
	$("#sentence").val('');
}
</script>
</head>
<body>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">はてなキーワード自動リンク & Yahoo!キーフレーズ → Weblio</span>
</p>
	<form method="POST">
	<textarea id="sentence" name="sentence" rows="10" style="width:600px;"><?= $sentence ?></textarea>
	<br>
	<input type="submit" name="command_query" value="実行">
	<input type="button" value="クリア" onClick="clear_text();">
	</form>
<?php
	if ($sentence) {
		$link_text = hatena_keyword_link(my_htmlspecialchars($sentence));
		if ($link_text <> '') {
			$hatena = ins_br($link_text);
?>
	<table id="hatena">
	<tr>
	<td style="width:40%;">
		<p style="line-height:20px;"><strong>はてな</strong></p>
		<?= $hatena ?>
	</td>
	<td style="width:40%;margin-left:4px;">
		<p style="line-height:20px;"><strong>→Weblio</strong></p>
		<?= hatena_2_weblio($hatena) ?>
	</td>
		<?php	if ($appid <> '') { ?>
		<td style="width:15%;margin-left:4px;">
			<p style="line-height:20px;"><strong>Yahoo!キーフレーズ</strong></p>
			<?php yahoo_keyphrase($appid, $sentence); ?>
		</td>
		</tr>
		<?php	} ?>
	</table>
<?php
		} else {
			echo '<p><br>エラーが発生しました。会社イントラ内ではプロキシの設定が必要です。</p>';
		}
	}
?>
</body>
</html>
<?php
function hatena_2_weblio($str) {
// <a class="keyword" target="_blank" href="http://d.hatena.ne.jp/keyword/エンコード単語">単語</a>
//	↓↓↓
// <a href='http://www.weblio.jp/content/単語' target='_blank'>単語</a>
	return preg_replace("/<a .*?>(.*?)<\/a>/mis", "<a href='http://www.weblio.jp/content/$1' target='_blank'>$1</a>", $str);
// <data data-lang='ja' data-wiki='単語'>単語</data>
/*	return preg_replace("/<a .*?>(.*?)<\/a>/mis", "<a href='http://www.weblio.jp/content/$1' target='_blank'><data data-lang='ja' data-wiki='$1'>$1</data></a>", $str);
*/
}
function hatena_keyword_link( $body ){
	$params = new XML_RPC_Value(array(
		"body"	 => new XML_RPC_Value($body, 'string'),
		"score"	=> new XML_RPC_Value(0, 'int'),
		"a_target" => new XML_RPC_Value('_blank', 'string'),
		"a_class"  => new XML_RPC_Value('keyword', 'string')
		), 'struct');
	$msg = new XML_RPC_Message("hatena.setKeywordLink", array($params));
	if (HTTP_PROXY_HOST.'' <> '') {
		$client = new XML_RPC_Client( "/xmlrpc" , "d.hatena.ne.jp", 80, 'tcp://'.HTTP_PROXY_HOST, HTTP_PROXY_PORT);
	} else {
		$client = new XML_RPC_Client( "/xmlrpc" , "d.hatena.ne.jp", 80);
	}
	$response = $client->send($msg);
	if ($response) {
		if (!$response->faultCode()) {
			$val = $response->value();
			$data = XML_RPC_decode($val);
			return $data;
		} else {
			return PEAR::raiseError($response->faultCode(), $response->faultString());
		}
	}
	return '';
}
function yahoo_keyphrase($appid, $sentence){
	$output = "xml";
	$request = "http://jlp.yahooapis.jp/KeyphraseService/V1/extract?";
	$request .= "appid=".$appid."&sentence=".urlencode($sentence)."&output=".$output;
	$responsexml = my_simplexml_load_file($request);
	$result_num = count($responsexml->Result);
	if($result_num > 0){
		echo '<table id="yahoo">';
		echo '<tr><td><b>→Weblio</b></td><td><b>スコア</b></td></tr>';
		for($i = 0; $i < $result_num; $i++){
			$result = $responsexml->Result[$i];
			$key = my_htmlspecialchars($result->Keyphrase);
			echo '<tr><td><a href="http://www.weblio.jp/content/'.$key.'" target="_blank">'.$key.'</a></td>';
			echo '<td>'.my_htmlspecialchars($result->Score).'</td></tr>';
		}
		echo '</table>';
	} else {
		echo '<p style="color:red;">Yahoo!キーフレーズは長文ではエラーになります。</p>';
	}
?>
<!-- Begin Yahoo! JAPAN Web Services Attribution Snippet -->
<a href="http://developer.yahoo.co.jp/about">
<img src="http://i.yimg.jp/images/yjdn/yjdn_attbtn2_105_17.gif" width="105" height="17" title="Webサービス by Yahoo! JAPAN" alt="Webサービス by Yahoo! JAPAN" border="0" style="margin:15px 15px 15px 15px"></a>
<!-- End Yahoo! JAPAN Web Services Attribution Snippet -->
<?php
}
?>
