<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("../account/__logincheck.php");
	require("__define_csv-import.php");
	ini_set("memory_limit", MEMORY_LIMIT_INI_SET);			//メモリサイズ
	ini_set("max_execution_time", MAX_EXECUTION_TIME_INI_SET);	//最大実行時間
	$csv_file_name = CSV_IMPORT_FOLDER.CSV_FILE_NAME;

	if (!myfile_file_exists($csv_file_name)) {
		redirect('csv-import.php');
	}
	$file_name = myfile_file_get_contents(CSV_IMPORT_FOLDER.CSV_UPLOAD_FILE_NAME);
	$handle = fopen($csv_file_name, 'r');
	if (($csv_head = fgetcsv($handle)) !== FALSE) {
		$numCols = count($csv_head);
	}
	$col_len = array();
	$col_type = array();
	$col_align = array();
	for ($col = 0; $col < $numCols; $col++) {
		$col_len[$col] = 1;
		$col_type[$col] = 'integer';
		$col_align[$col] = 'right';
	}
	$tbl_data = '';
	while (($data = fgetcsv($handle)) !== FALSE) {
		if ($tbl_data <> '') $tbl_data .= ',';
		$row_data = '';
		for ($col = 0; $col < $numCols; $col++) {
			if ($row_data <> '') $row_data .= ',';
			$row_data .= '"'.my_str_special($data[$col]).'"';
			if (($len = strlen($data[$col])) > $col_len[$col]) {
				$col_len[$col] = $len;
			}
			if ($data[$col].'' <> '' and !is_numeric($data[$col])) {	// integer,float,string
				$col_type[$col] = 'string';
				$col_align[$col] = 'left';
			} else {
				if (strstr($data[$col],'.') && ($col_type[$col] == 'integer')) {
					$col_type[$col] = 'float';
				}
			}
		}
		$tbl_data .= '['.$row_data."]\n";
	}
	fclose($handle);
	for ($col = 0; $col < $numCols; $col++) {
		$col_len[$col] = $col_len[$col]*2+3;
		if ($col_len[$col] > 200) {
			$col_len[$col] = 200;
		}
	}
	$tbl_head = '';
	for ($col = 0; $col < $numCols; $col++) {
		if ($tbl_head <> '') $tbl_head .= ",\n";
		$tbl_head .= '{ title:"'.my_str_special($csv_head[$col]).'", width:'.$col_len[$col].', dataType:"'.$col_type[$col].'", align: "'.$col_align[$col].'"}';
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<link rel="stylesheet" href="../scripts/jquery-ui.css">
<link rel="stylesheet" href="pqgrid.min.css">
<link rel="stylesheet" href="themes/office/pqgrid.css">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20120406">
<style>
#grid_parts {
	margin-top:5px;
}
</style>
<title>CSV to スプレッドシート風表示</title>
<script src="../scripts/jquery-1.8.3.js"></script>
<script src="../scripts/jquery-ui.min-1.10.1.js"></script>
<script src="pqgrid.min.js"></script>
<script src="localize/pq-localize-ja.js"></script>
<script>
$(function () {
	var data = [<?= $tbl_data ?>];
	var obj = { title: "【 <?= my_str_special($file_name) ?> 】" };
	obj.colModel = [<?= $tbl_head ?>];
	obj.dataModel = { data: data };
	var $grid = $("#grid_parts").pqGrid(obj);
	$("#grid_parts").pqGrid("option", "flexHeight", true);
	$("#grid_parts").pqGrid("option", "flexWidth", true);
	$("#grid_parts").pqGrid("option", "dataModel.paging", "local");
	$("#grid_parts").pqGrid("option", "topVisible", true);
	$("#grid_parts").pqGrid("option", "numberCell", false);
	$("#grid_parts").pqGrid("option", "scrollModel", { horizontal:false});
	$("#grid_parts").pqGrid("option", "dataModel.rPPOptions", [5, 10, 20, 50, 100, 500, 1000] );
	$("#grid_parts").pqGrid("option", $.paramquery.pqGrid.regional['ja']);				// Localization
	$("#grid_parts").find(".pq-pager").pqPager("option", $.paramquery.pqPager.regional['ja']);	// Localization
/*
	$("#grid_parts").pqGrid("option", "bottomVisible", true);
	$("#grid_parts").pqGrid("option", "columnBorders", true);
	$("#grid_parts").pqGrid("option", "rowBorders", true);
	$("#grid_parts").pqGrid("option", "oddRowsHighlight", true);
	$("#grid_parts").pqGrid("option", "roundCorners", true);
*/
	$("#grid_parts").pqGrid("option", "numberCellWidth", 24);
	$("#grid_parts_numberCell").change(function (evt) {	// 行番号表示
		$grid.pqGrid("option", "numberCell", $(this).is(":checked"));
	}).attr("checked", $grid.pqGrid("option", "numberCell"));
});
</script>
</head>
<body>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">CSV to スプレッドシート風表示</span>
<label style="margin-left:10px;"><input type=checkbox id="grid_parts_numberCell">行番号表示</label>
<a href="csv-import.php" style="margin-left:20px;">CSVインポート</a>
</p>
<div id="grid_parts"></div>
<div id="footer">
<a href="http://paramquery.com/" target="_blank" style="color:#b0b0ff;">Powered by paramquery.com</a><br>
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function my_str_special($str) {
	return my_htmlspecialchars(str_replace("\n",'',str_replace("\r",'',str_replace('"','”',$str))));
}
?>
