<?php
	require("../__common__/__define_common.php");
	if ($_GET['lang'].'' <> '') {
		$language = $_GET['lang'];
		setcookie('google_translate_language', $language, time() + LOGIN_COOKIE_EXPIRE, MY_SESSION_PATH);
	} elseif ($_COOKIE['google_translate_language']) {
		$language = $_COOKIE['google_translate_language'];
	} else {
		$language = 'ja';
	}
	if (isset($_GET['url'])) {
		$original = $_GET['url'];
	} elseif ($_COOKIE['google_translate_url']) {
		$original = $_COOKIE['google_translate_url'];
	}
	if ($original) {
		$translate = 'http://translate.google.com/translate?prev=hp&hl='.$language.'&js=y&u='.$original;
	}
	$lang_tbl = array();
	$lang_tbl[] = array('ja', '日本語');
	$lang_tbl[] = array('en', '英語');
	$lang_tbl[] = array('fr', 'フランス語');
	$lang_tbl[] = array('de', 'ドイツ語');
	$lang_tbl[] = array('it', 'イタリア語');
	$lang_tbl[] = array('es', 'スペイン語');
	$lang_tbl[] = array('ko', '韓国語');
	$lang_tbl[] = array('zh-CN', '中国語(簡体)');
	$lang_tbl[] = array('zh-TW', '中国語(繁体)');
	$lang_tbl[] = array('ar', 'アラビア語');
	$lang_tbl[] = array('id', 'インドネシア語');
	$lang_tbl[] = array('uk', 'ウクライナ語');
	$lang_tbl[] = array('nl', 'オランダ語');
	$lang_tbl[] = array('ca', 'カタロニア語');
	$lang_tbl[] = array('el', 'ギリシャ語');
	$lang_tbl[] = array('hr', 'クロアチア語');
	$lang_tbl[] = array('sv', 'スウェーデン語');
	$lang_tbl[] = array('sk', 'スロバキア語');
	$lang_tbl[] = array('sl', 'スロベニア語');
	$lang_tbl[] = array('sr', 'セルビア語');
	$lang_tbl[] = array('tl', 'タガログ語');
	$lang_tbl[] = array('cs', 'チェコ語');
	$lang_tbl[] = array('da', 'デンマーク語');
	$lang_tbl[] = array('no', 'ノルウェー語');
	$lang_tbl[] = array('hi', 'ヒンディー語');
	$lang_tbl[] = array('fi', 'フィンランド語');
	$lang_tbl[] = array('bg', 'ブルガリア語');
	$lang_tbl[] = array('vi', 'ベトナム語');
	$lang_tbl[] = array('iw', 'ヘブライ語');
	$lang_tbl[] = array('pl', 'ポーランド語');
	$lang_tbl[] = array('pt', 'ポルトガル語');
	$lang_tbl[] = array('lv', 'ラトビア語');
	$lang_tbl[] = array('lt', 'リトアニア語');
	$lang_tbl[] = array('ro', 'ルーマニア語');
	$lang_tbl[] = array('ru', 'ロシア語');
?><!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<style>
a.return_index { font-size: 12px; text-decoration: none; font-weight: normal;}
a.return_index:link { color: #e0e0e0; }
a.return_index:visited { color: #e0e0e0; }
a.return_index:hover { color: #ffc080; }
a.return_index:active { color: #ffc080; }
</style>
<title>Google ホームページ対訳</title>
<script src="../scripts/jquery.js"></script>
<script src="../scripts/jquery.cookie.js"></script>
<script>
function viewPage(url){
	original.location.href = url;
	$.cookie('google_translate_url',url,{path:'<?= MY_SESSION_PATH ?>'});
	translateView(url);
}
function translateView(url) {
	language = $("#language").val();
	$.cookie('google_translate_language',language,{path:'<?= MY_SESSION_PATH ?>', expires:365});
	translate.location.href = "http://translate.google.com/translate?prev=hp&hl="+language+"&js=y&u="+url;
}
function clearInput(){
	$("#url").val('');
}
$(function(){
	/*
		if ($.cookie('google_translate_language')) {
			$("#language").val($.cookie('google_translate_language'));
		}
	*/
	$("#left").css("height",window.innerHeight-30);
	$("#right").css("height",window.innerHeight-30);
	var right = $("#right");
	var left = $("#left");
	right.scroll(function(){
		left.scrollTop(right.scrollTop())
		left.scrollLeft(right.scrollLeft())
	});
});
</script>
</head>
<body style="margin:0;">
<div>
<form><a href="../tools/" class="return_index">■</a><span style="font-size:12px;">URL:</span><input id="url" class="text" type="text" style="width:500px;" name="url" value="<?= $original ?>"><button onclick="viewPage(form.url.value);return false;">翻訳</button><button onclick="clearInput();return false;">クリア</button><select id="language" onchange="translateView(form.url.value)">
<?php
	foreach ($lang_tbl as $lang) {
?>
		<option value="<?= $lang[0] ?>"<?= $lang[0] == $language ? ' selected' : '' ?>><?= $lang[1] ?></option>
<?php
		}
?>
	</select>
</form>
</div>
<div id="left" style="width:49.5%;overflow:hidden;float:left;border:1px solid #888;">
	<iframe id="original" scrolling="no" name="original" style="width:1024px;height:20000px;border-style:none;" src="<?= $original ?>"></iframe>
</div>
<div id="right" style="width:49.5%;overflow:auto;float:left;border:1px solid #888;">
	<iframe id="translate" scrolling="no" name="translate" style="width:1024px;height:20000px;border-style:none;position:relative;top:-80px;" src="<?= $translate ?>"></iframe>
</div>
<div style="clear:both"></div>
</body>
</html>
