<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<!-- Powered by http://xml-xsl.sakura.ne.jp/google_maps17/google_maps17.htm -->
<title>世界地図（国旗付き）</title>
<style type="text/css">
html {height: 100%;}
body {text-align: left; height: 100%; margin: 0; padding: 0; background: #fff; font-size: 12px; font-family: Arial,メイリオ,MS PGothic;}
#wrapper {margin: 0 auto;}
#header {position: absolute; top: 8px; left: 5px; width:100%; text-align: left; color: #000;background: #fff;}
#header a {color: #190049; margin-right:15px;}
#map_canvas {position: absolute; top: 30px; right: 200px; bottom: 5px; left: 5px; width: auto; height: auto; text-align: left; overflow: hidden;}
#side_bar {position: absolute; top: 30px; right: 5px; bottom: 5px; width: 180px; height: auto; overflow: auto; padding: 5px 5px; text-align: left; background: #fff;}
</style>
<script src="http://maps.google.com/maps/api/js?sensor=false"></script>
<script>
google.maps.visualRefresh = true;
var icon = Array();
var infowindow = new google.maps.InfoWindow();
var map;
var MY_MAPTYPE_ID = 'Simple';
function initialize(url) {
	var styley = [
		{featureType: 'landscape.natural', elementType: 'labels', stylers: [{visibility: 'off'}]},
		{featureType: 'landscape.natural', elementType: 'geometry', stylers: [{visibility: 'simplified'}]},
		{elementType: 'labels', stylers: [{visibility: 'off'}]}
	];
	var myOptions = {mapTypeId: MY_MAPTYPE_ID, mapTypeControlOptions: {mapTypeIds: [google.maps.MapTypeId.ROADMAP, MY_MAPTYPE_ID]}, panControl: false};
	map = new google.maps.Map(document.getElementById('map_canvas'), myOptions);
	google.maps.event.addListener(map, 'click', function() {infowindow.close();});
	var styledMapOptions = {name: 'Simple'};
	var simpleMapType = new google.maps.StyledMapType(styley, styledMapOptions);
	map.mapTypes.set(MY_MAPTYPE_ID, simpleMapType);
	downloadUrl(url, function(data) {
		var data = parseXml(data);
		var markers = data.documentElement.getElementsByTagName('marker');
		var sidebar = document.getElementById('side_bar');
		sidebar.innerHTML = '';
		var bounds = new google.maps.LatLngBounds();
		for (var i = 0; i < markers.length; i++) {
			var latlng = new google.maps.LatLng(parseFloat(markers[i].getAttribute('lat')), parseFloat(markers[i].getAttribute('lng')));
			var html = markers[i].getAttribute('html');
			var label = markers[i].getAttribute('label');
			html = html + '<br><a href="http://ja.wikipedia.org/wiki/' + label+ '" target="_blank">Wikipedia</a>';
			var code = markers[i].getAttribute('code');
			var marker = createMarker(latlng, html, label, code);
			var sidebarEntry = createSidebarEntry(marker, label);
			sidebar.appendChild(sidebarEntry);
			bounds.extend(latlng);
		}
		map.fitBounds(bounds);
	});
}
function createMarker(latlng, html, label, code) {
	var icoimg = new google.maps.MarkerImage('flg/flg_' + code + '.png',
		new google.maps.Size(16,11),
		new google.maps.Point(0, 0),
		new google.maps.Point(8, 5)
	);
	var marker = new google.maps.Marker({position: latlng, map: map, title: label, icon: icoimg});
	google.maps.event.addListener(marker, 'click', function() {
		if (infowindow) infowindow.close();
		infowindow = new google.maps.InfoWindow({content: html});
		infowindow.open(map, marker);
	});
	return marker;
}
function createSidebarEntry(marker, label) {
	var div = document.createElement('div');
	var html = label;
	div.innerHTML = html;
	div.style.cursor = 'pointer';
	div.style.marginBottom = '2px'; 
	google.maps.event.addDomListener(div, 'click', function() {
		google.maps.event.trigger(marker, 'click');
	});
	google.maps.event.addDomListener(div, 'mouseover', function() {
		div.style.backgroundColor = '#CCCCFF';
	});
	google.maps.event.addDomListener(div, 'mouseout', function() {
		div.style.backgroundColor = '';
	});
	return div;
}
function downloadUrl(url, callback) {
	var request = window.ActiveXObject ?
	new ActiveXObject('Microsoft.XMLHTTP') :
	new XMLHttpRequest;
	request.onreadystatechange = function() {
		if (request.readyState == 4) {
			request.onreadystatechange = doNothing;
			callback(request.responseText, request.status);
		}
	};
	request.open('GET', url, true);
	request.send(null);
}
function parseXml(str) {
	if (window.ActiveXObject) {
		var doc = new ActiveXObject('Microsoft.XMLDOM');
		doc.loadXML(str);
		return doc;
	} else if (window.DOMParser) {
		return (new DOMParser).parseFromString(str, 'text/xml');
	}
}
function doNothing() {};
</script>
</head>
<body onload="initialize('0087547as.xml')">
<div id="wrapper">
<div id="header">
<a onclick='javascript:initialize("0087547as.xml");' href="#">アジア</a>
<a onclick='javascript:initialize("0087547eu.xml");' href="#">欧州（NIS諸国を含む）</a>
<a onclick='javascript:initialize("0087547am.xml");' href="#">北米、中南米</a>
<a onclick='javascript:initialize("0087547me.xml");' href="#">中東</a>
<a onclick='javascript:initialize("0087547os.xml");' href="#">大洋州</a>
<a onclick='javascript:initialize("0087547af.xml");' href="#">アフリカ</a>
</div>
<div id="map_canvas"></div>
<div id="side_bar"></div>
</div>
</body>
</html>
