<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	if ($_SESSION['photo_open_path'] == '') {
		header("Location: index.php");
	}
	if (empty($_SESSION['photo'])) {
		header("Location: index.php");
	}
	if (empty($_SESSION['photo_img_count'])) {
		header("Location: index.php");
	}
	if ($_SESSION['photo_img_count'] < 1) {
		header("Location: index.php");
	}
	$open_path = $_SESSION['photo_open_path'];
	if (defined("photo_LIMITED_IMAGES_FOLDER") and photo_LIMITED_IMAGES_FOLDER <> '') {
		if ($_SESSION['システム管理者'] <> 'YES' or photo_LIMITED_ADMIN_NOLIMIT <> 'YES') {
			$len = strlen(photo_LIMITED_IMAGES_FOLDER);
			if (substr($open_path.'/', 0, $len+1) <> photo_LIMITED_IMAGES_FOLDER.'/') {
				header("Location: index.php");
			}
		}
	}
	if ($_GET['page'].'' <> '') {
		$page = intval($_GET['page']);
		if ($page < 1) {
			$page = 1;
		}
	} else {
		$page = 1;
	}
	$filename = $_SESSION['photo'][$page-1]['file'];
	$filepath = $open_path.'/'.$filename;
	if ($_SESSION['photo'][$page-1]['type'] == 'video' and photo_VIDEO_FFMPEG == 'YES' and $_SESSION['slide_flv_preview'] == 'on' and $slidemode <> 'ajax') {
		// 動画の再生時間を取得 (ffmpegのstderrを利用)
		$ret = shell_exec('ffmpeg -i "'.myfile_ENCODE($filepath).'" 2>&1');
		$time = trim(get_intag($ret, 'duration:', ',', $pos=0));
		$time_ar = explode(":", $time);
		$interval_time = (int)$time_ar[0]*3600+(int)$time_ar[1]*60+(int)$time_ar[2] + 2;
	} else {
		$interval_time = $_COOKIE['slide_interval_time'];
	}
	$add_meta = '';
	if ($_SESSION['slide_fullview_auto'] == 'on' and $slidemode <> 'ajax') {
		if ($page < ceil($_SESSION['photo_img_count'])) {
			$add_meta = '<meta http-equiv="refresh" content="'.$interval_time.';';
			$add_meta .= 'url='.$_SERVER['SCRIPT_NAME'].'?page='.strval($page+1);
			$add_meta .= '&mode=s&slidemode='.$slidemode.'">';
		} elseif ($_SESSION['slide_view_repeat'] == 'on') {
			$add_meta = '<meta http-equiv="refresh" content="'.$interval_time.';';
			$add_meta .= 'url='.$_SERVER['SCRIPT_NAME'].'?page=1';
			$add_meta .= '&mode=s&slidemode='.$slidemode.'">';
		}
	}
	if (VIDEO_PREVIEW == 'YES' && $_SESSION['slide_flv_preview'] == 'on' && $slidemode <> 'ajax' && is_preview_video_filename($filename) && is_ext_filename_str($filename, VIDEO_PREVIEW_CONVERT)) {
		$filepath = $open_path.'/'.$filename.'.flv';	// JWPlayerは拡張子が.flvでないと駄目なため
	} else {
		$filepath = $open_path.'/'.$filename;
	}
	$filepath_url = urlencode($filepath);
	if ($_SESSION['photo'][$page-1]['type'] == 'video') {
		$getimg = "video-jpeg.php?file=".$filepath_url."&ss=".$_SESSION['video_thumb_ss'];
	} else {
		$getimg = "img-view.php?img=".$filepath_url;
	}
	if ($page > 1) {
		$move_prev = $page - 1;
	} else {
		if ($_SESSION['slide_view_repeat'] == 'on') { 
			$move_prev = $_SESSION['photo_img_count'];
		} else {
			$move_prev = $page;
		}
	}
	if ($page < $_SESSION['photo_img_count']) {
		$move_next = $page + 1;
	} else {
		if ($_SESSION['slide_view_repeat'] == 'on') { 
			$move_next = 1;
		} else {
			$move_next = $page;
		}
	}
	if ($page + SLIDE_SMALL_NUM < $_SESSION['photo_img_count']) {
		$skip_next = $page + SLIDE_SMALL_NUM;
	} else {
		$skip_next = $_SESSION['photo_img_count'];
	}
	if ($page - SLIDE_SMALL_NUM > 1) {
		$skip_back = $page - SLIDE_SMALL_NUM;
	} else {
		$skip_back = 1;
	}
	if ($_COOKIE['photo_css_filters_contrast']) {
		$contrast = $_COOKIE['photo_css_filters_contrast'];
	} else {
		$contrast = 100;
	}
	if ($_COOKIE['photo_css_filters_brightness']) {
		$brightness = $_COOKIE['photo_css_filters_brightness'];
	} else {
		$brightness = 100;
	}
	if ($_COOKIE['photo_css_filters_grayscale']) {
		$grayscale = $_COOKIE['photo_css_filters_grayscale'];
	} else {
		$grayscale = 0;
	}
	if ($_COOKIE['photo_css_filters_saturate']) {
		$saturate = $_COOKIE['photo_css_filters_saturate'];
	} else {
		$saturate = 100;
	}
	if ($_COOKIE['photo_css_filters_hue_rotate']) {
		$hue_rotate = $_COOKIE['photo_css_filters_hue_rotate'];
	} else {
		$hue_rotate = 0;
	}
	if ($_COOKIE['photo_css_filters_sepia']) {
		$sepia = $_COOKIE['photo_css_filters_sepia'];
	} else {
		$sepia = 0;
	}
	if ($_COOKIE['photo_css_filters_invert']) {
		$invert = $_COOKIE['photo_css_filters_invert'];
	} else {
		$invert = 0;
	}
	if ($_COOKIE['photo_css_filters_blur']) {
		$blur = $_COOKIE['photo_css_filters_blur'];
	} else {
		$blur = 0;
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="description" content="Powered by http://www.propra.nl/playground/css_filters/">
<title>CSSフィルタ</title>
<style>
body { margin: 20px; }
a { text-decoration: none; color: #0080E0; }
</style>
<script src="../scripts/jquery.js"></script>
<script src="../scripts/jquery.cookie.js"></script>
<script src="../scripts/ok2nd.js"></script>
<script>
document.onkeydown = keyPress;
function keyPress(e) {
	e = e || window.event;;
	if (e.keyCode == 27) {	// Esc
		window.close();
	} else if (e.keyCode == 37 || e.keyCode == 100 || e.keyCode == 33 || e.keyCode == 29) {	// ←, Page Up, 無変換 ：Page Prev
		window.location.href = "?page=<?= $move_prev ?>";
	} else if (e.keyCode == 39 || e.keyCode == 102 || e.keyCode == 34) {	// →, Page Down ：Page Next
		window.location.href = "?page=<?= $move_next ?>";
	} else if (e.keyCode == 13 || e.keyCode == 32 || e.keyCode == 229) {	// Enter, Space (229:日本語モード) ：Page Next
		window.location.href = "?page=<?= $move_next ?>";
	} else if (e.keyCode == 9 ) {					// Tab ：Page Skip(10)
		window.location.href = "?page=<?= $skip_next ?>";
	} else if (e.keyCode == 240 ) {					// Caps Lock ：Page Skip(10) Back
		window.location.href = "?page=<?= $skip_back ?>";
	} else if (e.keyCode == 36) {					// Home ：Page Top
		window.location.href = "?page=1";
	} else if (e.keyCode == 35) {					// End ：Page Last
		window.location.href = "?page=<?= $_SESSION['photo_img_count'] ?>";
	} else if (e.keyCode == 122) {					// F11 ：全画面
		window.location.href = "?page=<?= $page ?>";		// リロード
		return true;
	} else {	// その他 (ファンクションキーなどを有効にするため)
		return true;
	}
	return false;
}
</script>
<script>
$(window).load(function(){	// 画像も読み込まれた後
	var img = new Image();
	img.src = $('#filteredimg').attr('src');
	if (img.width > img.height) {
		$("#filteredimg").css("width",((window.innerWidth)-260)+"px");
	} else {
		$("#filteredimg").css("height",(window.innerHeight-50)+"px");
	}
});
var flt = {};
function changeFilter(filter,val,spanItem) {
	flt[filter] = val;
	$.cookie('photo_css_filters_'+filter,val,{path:'<?= MY_SESSION_PATH ?>'});
	if (!(spanItem === undefined)) {
		$(spanItem).html(val);
	}
	updateFilters();
}
function updateFilters() {
	//console.log(flt);
	var css = 'contrast('+flt.contrast+'%) brightness('+flt.brightness+'%) grayscale('+flt.grayscale+'%) saturate('+flt.saturate+'%) hue-rotate('+flt.hue_rotate+'deg) sepia(' + flt.sepia + '%) invert('+flt.invert+'%) blur('+flt.blur+'px)';
	$('#filteredimg').css('border','solid 1px black');
	$('#filteredimg').css('-webkit-filter',css);
}
$(function() {
	updateFilters();
	changeFilter('contrast',<?= $contrast ?>);
	changeFilter('brightness',<?= $brightness ?>);
	changeFilter('grayscale',<?= $grayscale ?>);
	changeFilter('saturate',<?= $saturate ?>);
	changeFilter('hue_rotate',<?= $hue_rotate ?>);
	changeFilter('sepia',<?= $sepia ?>);
	changeFilter('invert',<?= $invert ?>);
	changeFilter('blur',<?= $blur ?>);
});
function all_reset() {
	change_reset('contrast',100);
	change_reset('brightness',100);
	change_reset('grayscale',0);
	change_reset('saturate',100);
	change_reset('hue_rotate',0);
	change_reset('sepia',0);
	change_reset('invert',0);
	change_reset('blur',0);
}
function change_reset(filter,val) {
	$('#set_'+filter).val(val);
	changeFilter(filter,val,$('#set_'+filter).next());
}
</script>
</head>
<body>
<div style="float:left;">
<button onclick="all_reset(); return false">All Reset</button>
<div style="width:200px">contrast (<a href=# onclick="$('#set_contrast').val(100); $('#set_contrast').change(); return false">reset</a>)</div>
<input id=set_contrast type=range min=0 max=300 value=<?= $contrast ?> onchange="changeFilter('contrast',this.value,$(this).next())"> <span><?= $contrast ?></span>%
<script>flt.contrast = 100;</script>
<br><br>
<div style="width:200px">brightness (<a href=# onclick="$('#set_brightness').val(100); $('#set_brightness').change(); return false">reset</a>)</div>
<input id=set_brightness type=range min=0 max=100 value=<?= $brightness ?> onchange="changeFilter('brightness',this.value,$(this).next())"> <span><?= $brightness ?></span>%
<script>flt.brightness = 100;</script>
<br><br>
<div style="width:200px">grayscale (<a href=# onclick="$('#set_grayscale').val(0); $('#set_grayscale').change(); return false">reset</a>)</div>
<input id=set_grayscale type=range min=0 max=100 value=<?= $grayscale ?> onchange="changeFilter('grayscale',this.value,$(this).next())"> <span><?= $grayscale ?></span>%
<script>flt.grayscale = 0;</script>
<br><br>
<div style="width:200px">saturate (<a href=# onclick="$('#set_saturate').val(100); $('#set_saturate').change(); return false">reset</a>)</div>
<input id=set_saturate type=range min=0 max=700 value=<?= $saturate ?> onchange="changeFilter('saturate',this.value,$(this).next())"> <span><?= $saturate ?></span>%
<script>flt.saturate = 100;</script>
<br><br>
<div style="width:200px">hue-hue_rotate (<a href=# onclick="$('#set_hue_rotate').val(0); $('#set_hue_rotate').change(); return false">reset</a>)</div>
<input id=set_hue_rotate type=range min=0 max=360 value=<?= $hue_rotate ?> onchange="changeFilter('hue_rotate',this.value,$(this).next())"> <span><?= $hue_rotate ?></span>deg
<script>flt.hue_rotate = 0;</script>
<br><br>
<div style="width:200px">sepia (<a href=# onclick="$('#set_sepia').val(0); $('#set_sepia').change(); return false">reset</a>)</div>
<input id=set_sepia type=range min=0 max=100 value=<?= $sepia ?> onchange="changeFilter('sepia',this.value,$(this).next())"> <span><?= $sepia ?></span>%
<script>flt.sepia = 0;</script>
<br><br>
<div style="width:200px">invert (<a href=# onclick="$('#set_invert').val(0); $('#set_invert').change(); return false">reset</a>)</div>
<input id=set_invert type=range min=0 max=100 value=<?= $invert ?> onchange="changeFilter('invert',this.value,$(this).next())"> <span><?= $invert ?></span>%
<script>flt.invert = 0;</script>
<br><br>
<div style="width:200px">blur (<a href=# onclick="$('#set_blur').val(0); $('#set_blur').change(); return false">reset</a>)</div>
<input id=set_blur type=range min=0 max=10 value=<?= $blur ?> onchange="changeFilter('blur',this.value,$(this).next())"> <span><?= $blur ?></span>px
<script>flt.blur = 0;</script>
<br><br>
</div>
<div style="float:left;">
<img id="filteredimg" src="<?= $getimg ?>">
</div>
</body>
</body>
</html>
