(function ($) {
	$.fn.FeedEk = function (opt) {
		var def = {
			FeedUrl: '',
			MaxCount: 5,
			ShowDesc: true,
			ShowPubDate: true
		};
		if (opt) {
			$.extend(def, opt)
		}
		var idd = $(this).attr('id');
		if (def.FeedUrl == null || def.FeedUrl == '') {
			$('#' + idd).empty();
			return
		}
		var pubdt;
		$('#' + idd).empty().append('<div style="text-align:left; padding:3px;"><img src="feed/loader.gif" /></div>');
		$.ajax({
			url: 'http://ajax.googleapis.com/ajax/services/feed/load?v=1.0&num=' + def.MaxCount + '&output=json&q=' + encodeURIComponent(def.FeedUrl) + '&callback=?',
			dataType: 'json',
			success: function (data) {
				$('#' + idd).empty();
				$.each(data.responseData.feed.entries, function (i, entry) {
					br_p = entry.content.search(/<<br>|\/p>/i);
					if (br_p != -1) {
						var honbun = entry.content.substr(0,br_p-1);
					} else {
						var honbun = entry.content;
					}
					honbun = honbun.rnt_strip();
					$('#' + idd).append('<div class="ItemTitle"><a href="' + entry.link + '" target="_blank" title="' + honbun.tagstrip().trim() + '">' + entry.title + '</a></div>');
					if (def.ShowPubDate) {
						pubdt = new Date(entry.publishedDate);
						$('#' + idd).append('<div class="ItemDate">' + pubdt.toLocaleDateString() + '</div>')
					}
					if (def.ShowDesc) {
						$('#' + idd).append('<div class="ItemContent">' + entry.content + '</div>');
					//	$("#dummy").html(entry.content);
					//	$('#' + idd).append('<div class="ItemContent">' + $("#dummy").text() + '</div>');
					}
				});
				$("#dummy").remove();
			}
		})
	}
})(jQuery);
