<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("__define_code-file.php");
	require("__include-common-code-file.php");
	my_session_start();
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (FILE_MANAGER_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
	if (!defined("CODE_FILE_VIEW_EDIT_DEFAULT_FOLDER")) {
		define("CODE_FILE_VIEW_EDIT_DEFAULT_FOLDER", $_SERVER['DOCUMENT_ROOT']);
	}
	if ($_GET['path'].'' <> '') {
		$open_path = my_GET('path');
	}
	$open_path = str_replace(DIRECTORY_SEPARATOR, "/", right_slash_strip($open_path));
	if ($open_path == "") {
		$open_path = CODE_FILE_VIEW_EDIT_DEFAULT_FOLDER;
	}
	$file_mode = file_check_get_text($open_path, $path_SJIS, $source_text, $source_encode, $file_type, $error_msg);
	if ($file_mode == 'Folder') {
		view_folder($open_path, $path_SJIS, $_SESSION['code_view_search_key']);
	}
?>
<?php
function view_folder($open_path, $path_SJIS, $search_key) {
	$prt_dir = array();
	$prt_file = array();
	if ($dir = opendir($path_SJIS)) {
		$files = scandir($path_SJIS);
	//	natcasesort($files);		/* サーバーサイドでのソートを廃止。*/
		$order = 0;
		foreach ($files as $file) {
			if ($file != "." && $file != "..") {
				$filepath_SJIS = $path_SJIS.'/'.$file;
				if (is_dir($filepath_SJIS)) {
					if ($_GET['get'] == 'dir') {
						$prt_dir[] = $file;
					}
				} elseif ($type = chk_source_filename($file)) {
					if ($_GET['get'] == 'file') {
						if (($stat = stat($filepath_SJIS)) <> False) {
							$prt_file[] = array($file, $type, $stat['size'], $stat['mtime']);
							$prt_file_name[] = $file;
							$prt_file_size[] = $stat['mtime'];
							// array_multisort()で日本語の順番が乱れる対策としてnatcasesort()の順番を使う
							$prt_order[] = ++$order;
						}
					}
				}
			}
		}
		closedir($dir);
	}
	if ($_GET['get'] == 'dir') {
		print_dir($open_path, $prt_dir, $search_key);
	} elseif ($_GET['get'] == 'file') {
		print_file($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size, $prt_order);
	}
}
function print_dir($open_path, $prt_dir, $search_key) {
?>
	<ul class="file_list">
<?php
	foreach ($prt_dir as $dir) {
		$file_UTF = myfile_DECODE($dir);
		$path_UTF = $open_path.'/'.myfile_DECODE($dir);
?>
		<li class="file_folder"><a href="code-file-view.php?path=<?= urlencode($path_UTF) ?>&key=<?= urlencode($search_key) ?>"><?= $file_UTF.'/' ?></a>
		<input type="button" class="copy_button" value="Ｃ" onClick="copy_folder('<?= escape_squote($path_UTF) ?>')">
		<input type="button" class="copy_button" value="Ｒ" onClick="rename_folder('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
		<input type="button" class="copy_button" value="Ｄ" onClick="delete_folder('<?= escape_squote($path_UTF) ?>')">
		</li>
<?php
	}
?>
	</ul>
<?php
}
function print_file($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size, $prt_order) {
	if (!$prt_file_name) return;
?>
	<table cellspacing="1" id="sorttable" class="tablesorter">
	<thead>
	<tr>
	<th>ファイル名</th>
	<th>サイズ</th>
	<th>更新日時</th>
	</tr>
	</thead>
	<tbody>
<?php
	foreach ($prt_file as $file) {
		$file_UTF = myfile_DECODE($file[0]);
		$path_UTF = $open_path.'/'.myfile_DECODE($file[0]);
		$path_SJIS = myfile_ENCODE($path_UTF);
		if ($search_key <> '') {
			$key_found = '';
			if ($_SESSION['code_view_search_uplow'] == 'on') {
				if (mb_strpos(file_get_contents($path_SJIS), $search_key) !== False) {
					$key_found = 'key_found';
				}
			} else {
				if (mb_stripos(file_get_contents($path_SJIS), $search_key) !== False) {
					$key_found = 'key_found';
				}
			}
		}
?>
		<tr><td class="file_list" nowrap>
	<a class="file_<?= $file[1] ?>" href="code-file-view.php?path=<?= urlencode($path_UTF) ?>&key=<?= urlencode($search_key) ?>"><span class="<?= $key_found ?>"><?= $file_UTF ?></span></a>
	<a class="edit_btn" href="code-file-edit.php?path=<?= urlencode($path_UTF) ?>&ret=up">編集</a>
	<input type="button" class="copy_button" value="Ｃ" onClick="copy_file('<?= escape_squote($path_UTF) ?>')">
	<input type="button" class="copy_button" value="Ｒ" onClick="rename_file('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
	<input type="button" class="copy_button" value="Ｄ" onClick="delete_file('<?= escape_squote($path_UTF) ?>')">
	</td>
	<td class="file_size"><?= ceil($file[2]/1024) ?> KB</td><td class="file_time"><?= date("Y/m/d H:i", $file[3]) ?></td></tr>
<?php
	}
?>
	</tbody>
	</table>
<?php
}
?>
