<?php
	@include("../__common__/__define_common.php");
	if (!defined("_DB_SERVER") && !defined("_DB_USERNAME") && !defined("_DB_PASSWORD")) {
		define("_DB_SERVER", "localhost");
		define("_DB_USERNAME", "myhome");
		define("_DB_PASSWORD", "pass123");
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<title>MySQL データベース/テーブル一覧</title>
<style>
<!--
* { margin: 0px; padding: 0px; }
h1 { font-size: 140%; font-weight: bold; }
h2 { font-size: 130%; font-weight: bold; }
h3 { font-size: 120%; font-weight: bold; margin: 0 0 5px 0; }
h4 { font-size: 110%; font-weight: bold; }
div#footer {
	margin: 20px 0 10px 0;
	font-size: 84%;
}
a { text-decoration: underline; font-weight: normal; }
a:link { color: #0000ff; font-weight: normal; }
a:visited { color: #0000ff; font-weight: normal; }
a:hover { color: #ff0000; font-weight: normal; }
a:active { color: #ff0000; font-weight: normal; }
body {
	margin: 20px;
}
a.a_cancel_back {
	text-decoration: underline;
	text-align: center;
	font-size: 84%;
	margin: 0 0 0 20px;
	padding: 0;
}
a.a_cancel_back:link { color: #ff8000; font-weight: normal; }
a.a_cancel_back:visited { color: #ff8000; font-weight: normal; }
a.a_cancel_back:hover { color: #ff0000; font-weight: normal; }
a.a_cancel_back:active { color: #ff0000; font-weight: normal; }
p.error {
	margin: 20px 0 5px 20px;
	color: red;
}
p.subtitle {
	margin: 5px 0 5px 0;
}
.db_name {
	color: #2020e0;
	font-weight: bold;
}
table.db_table {
	border: #c0c0c0 1px solid;
	background-color: #ffffff;
}
.db_table th {
	padding-right: 1px; padding-left: 1px; padding-bottom: 1px; padding-top: 1px; background-color: #c0c0ff;
}
.db_table td {
	padding-right: 1px; padding-left: 1px; padding-bottom: 1px; padding-top: 1px; background-color: #e9e9e9;
}
-->
</style>
</head>
<body>
<h3>MySQL データベース/テーブル一覧</h3>
<?php
	$con = @mysqli_connect(_DB_SERVER, _DB_USERNAME, _DB_PASSWORD);
	if ($con == False) {
		error_exit('データベース接続エラー');
	}
	mysqli_set_charset($con, 'utf8');
	if ($_GET['db'].'' == '') {
		print_database($con);
	} elseif ($_GET['tb'].'' == '') {
		print_table($con, $_GET['db']);
	} else {
		print_field($con, $_GET['db'], $_GET['tb']);
	}
	mysqli_close($con);
?>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#8080ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function print_database($con) {
	$rs = mysqli_query($con, 'show databases');
	if (!$rs) {
		error_exit('データベースなし');
	}
?>
	<table class="db_table" cellspacing=1>
	<tr><th>データベース</th></tr>
<?php
	while ($rec = mysqli_fetch_array($rs)) {
		if ($rec['Database'] <> 'information_schema') {
?>
		<tr><td>
		<a href="<?= $_SERVER['SCRIPT_NAME'] ?>?db=<?= $rec['Database'] ?>"><?= $rec['Database'] ?></a>
		</td></tr>
<?php
		}
	}
?>
	</table>
<?php
}
function print_table($con, $dbname) {
?>
	<p class="subtitle">データベース：<span class="db_name"><?= $dbname ?></span>
	<a class="a_cancel_back" href='javascript:history.back();'>戻る</a></p>
<?php
	if (!mysqli_select_db($con, $dbname)) return;
	$sql = 'select TABLE_NAME, TABLE_TYPE from INFORMATION_SCHEMA.TABLES';
	$sql .= ' where TABLE_SCHEMA="'.$dbname.'" order by table_type, table_name';
	$rs = mysqli_query($con, $sql);
	if (!$rs) {
		error_exit ($dbname.'：テーブルなし');
	}
?>
	<table class="db_table" cellspacing=1>
	<tr><th>TABLE_NAME</th><th>TABLE_TYPE</th></tr>
<?php
	while ($rec = mysqli_fetch_array($rs)) {
?>
		<tr>
		<td><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?db=<?= $dbname ?>&tb=<?= $rec['TABLE_NAME'] ?>"><?= $rec['TABLE_NAME'] ?></a></td>
		<td><?= $rec['TABLE_TYPE'] ?></td>
		</tr>
<?php
	}
?>
	</table>
<?php
}
function print_field($con, $dbname, $tblname) {
?>
	<p class="subtitle">データベース：<span class="db_name"><?= $dbname ?></span>&nbsp;
	テーブル：<span class="db_name"><?= $tblname ?></span>
	<a class="a_cancel_back" href='javascript:history.back();'>戻る</a></p>
<?php
	if (!mysqli_select_db($con, $dbname)) return;
	$rs = mysqli_query($con, 'desc '.$tblname);
	if (!$rs) {
		error_exit ($tblname.'：フィールドなし');
	}
?>
	<table class="db_table" cellspacing=1>
	<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>
<?php
	while ($rec = mysqli_fetch_array($rs)) {
?>
		<tr>
		<td><?= $rec['Field'] ?></td>
		<td><?= $rec['Type'] ?></td>
		<td><?= $rec['Null'] ?></td>
		<td><?= $rec['Key'] ?></td>
		<td><?= $rec['Default'] ?></td>
		<td><?= $rec['Extra'] ?></td>
		</tr>
<?php
	}
?>
	</table>
<?php
}
function error_exit($message) {
	echo '<p class="error">'.$message.'</p>';
	exit();
}
?>
