<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<title><?= HTML_TITLE ?></title>
<!--
Ghostwriter, (c) Skookum, released under the GPL
for more information, contact the author, Hunter Loftis <hunter@skookum.com>
-->
<link href='ghostwriter/css/main.css' media='all' rel='stylesheet' type='text/css'>
<?php
	if ($_GET['id'].'' <> '') {
		$id = intval($_GET['id']);
	} else {
		$id = 0;
	}
	if ($id == 0) {
		$draw = '';
		$subject = '';
		if ($_COOKIE['draw_bg_paper_texture'] <> '') {
			$bg_image = $_COOKIE['draw_bg_paper_texture'];
		} else {
			$bg_image = draw_CANVAS_TEXTURE_DEFAULT;
		}
	} else {
		$con = my_mysqli_connect(_DB_SCHEMA);
		$sql = "select * from v_draw where id_draw = ".$id;
		$rs = my_mysqli_query($sql);
		if (mysqli_num_rows($rs) == 0) {
			rec_not_found('データがありません。');
			return;
		}
		$rec = mysqli_fetch_array($rs);
		$draw = str_replace(' ', '+', $rec['c_drawdata']);
		$subject = $rec['c_subject'];
		$bg_image = $rec['c_background'];
	}
?>
<style>
#drawing {
	background: url(<?= draw_CANVAS_TEXTURE_FOLDER ?>/<?= $bg_image ?>);
}
button.paper_texture {
	width: 40px;
	height: 40px;
}
</style>
<script>
var record_id = <?= $id ?>;
var subj = '<?= $subject ?>';
var mp_list_page = '<?= $_GET['page'] ?>';
var mp_list_move = '<?= $_GET['move'] ?>';
var mp_list_row = '<?= $_GET['row'] ?>';
var bg_image = '<?= $bg_image ?>';
function storeIMAGE() {
	subj = window.prompt("タイトルを入れてください。", subj);
	if (subj != null) {	// subj == '' は許可
		var data = {id:record_id, subj:subj, bg:bg_image, draw:amplify.store('ghostwriter.drawing')};
		$.ajax({
			type: "POST",
			url: "write.php",
			data: data,
			async: false,
			success: function(id){
				location.href='view.php?id='+id+'&page='+mp_list_page+'&move='+mp_list_move+'&row='+mp_list_row;
			}
		})
	}
}
function getMyDraw() {
	var drawing_image = '<?= $draw ?>';
	amplify.store('ghostwriter.drawing', drawing_image);
}
function paperTexture(image) {
	bg_image = image;
	$("#drawing").css("background","url(<?= draw_CANVAS_TEXTURE_FOLDER ?>/"+image+")");
	$.cookie("draw_bg_paper_texture",bg_image,{ path:'<?= MY_SESSION_PATH ?>', expires:365 });
}
var color_palette_no = 1;
function colorPalette() {
	off_no = color_palette_no;
	on_no = off_no + 1;
	if (on_no == 5) {
		on_no = 1;
	}
	$("#colors"+off_no).css("display","none");
	$("#colors"+on_no).css("display","");
	color_palette_no = on_no;
}
</script>
</head>
<body>
<button onclick="storeIMAGE(); return false">保存</button>
<?php if ($id <> 0) {	?>
<button onclick="location.href='view.php?<?= $_SERVER['QUERY_STRING'] ?>'">戻る</button>
<?php }	?>
<button onclick="location.href='list.php?<?= $_SERVER['QUERY_STRING'] ?>'">一覧</button>
<?php
	$images = explode(',', draw_CANVAS_TEXTURE_IMAGES);
	foreach ($images as $image) {
?>
<button onclick="paperTexture('<?= $image ?>'); return false" class="paper_texture" style="background:url(<?= draw_CANVAS_TEXTURE_FOLDER ?>/<?= $image ?>)"></button>
<?php
	}
?>
<div id="wrap">
	<div id="highlights">
		<!--
		<ul>
			<li>with:</li>
			<li>HTML5</li>
			<li>CSS3</li>
			<li>Canvas</li>
			<li>LocalStorage</li>
		</ul>
		-->
	</div>
	<div id="drawing">
		<canvas id="artboard" width="750" height="500"></canvas>
		<canvas id="workboard" width="750" height="500"></canvas>
		<div id="eraser" data-bind-eraser="visible: visible, css: {down: down}, style: {left: left, top: top, zIndex: zIndex}">
			<div class="shadow" data-bind-eraser="style: {webkitTransform: shadowTransform, MozTransform: shadowTransform, msTransform: shadowTransform, transform: shadowTransform}"></div>
			<div class="brush" data-bind-eraser="style: {webkitTransform: transform, MozTransform: transform, msTransform: transform, transform: transform}"></div>
		</div>
		<div id="pen" data-bind-pen="visible: visible, css: {down: down}, style: {left: left, top: top, zIndex: zIndex}">
			<div class="shadow" data-bind-pen="style: {webkitTransform: shadowTransform, MozTransform: shadowTransform, msTransform: shadowTransform, transform: shadowTransform}"></div>
			<div class="brush" data-bind-pen="style: {webkitTransform: transform, MozTransform: transform, msTransform: transform, transform: transform}"></div>
		</div>
		<div id="spraygun" data-bind-spray="visible: visible, css: {down: down}, style: {left: left, top: top, zIndex: zIndex}">
			<div class="shadow" data-bind-spray="style: {webkitTransform: shadowTransform, MozTransform: shadowTransform, msTransform: shadowTransform, transform: shadowTransform}"></div>
			<div class="brush" data-bind-spray="style: {webkitTransform: transform, MozTransform: transform, msTransform: transform, transform: transform}"></div>
		</div>
		<div id="marker" data-bind-marker="visible: visible, css: {down: down}, style: {left: left, top: top, zIndex: zIndex}">
			<div class="shadow" data-bind-marker="style: {webkitTransform: shadowTransform, MozTransform: shadowTransform, msTransform: shadowTransform, transform: shadowTransform}"></div>
			<div class="brush" data-bind-marker="style: {webkitTransform: transform, MozTransform: transform, msTransform: transform, transform: transform}"></div>
		</div>
	</div>
	<div id="sidebar">
		<div id="palette">
			<a class="cbSmall cButton cbcClear" id="newbutton" data-bind-controls="click: clear" href='#'><span>クリア</span></a>
			<a class="cbSmall cButton cbcColChg" href="javascript:colorPalette();">色替</a>
			<ul class="colors" id="colors1">
			<?php
				$colors = explode(',', draw_COLOR_PALETTE_1);
				foreach ($colors as $color) {
			?>
				<li class='color' data-color='<?= hex2rgb($color) ?>'><div class="swatch"></div></li>
			<?php
				}
			?>
			</ul>
			<ul class="colors" id="colors2" style="display:none;">
			<?php
				$colors = explode(',', draw_COLOR_PALETTE_2);
				foreach ($colors as $color) {
			?>
				<li class='color' data-color='<?= hex2rgb($color) ?>'><div class="swatch"></div></li>
			<?php
				}
			?>
			</ul>
			<ul class="colors" id="colors3" style="display:none;">
			<?php
				$colors = explode(',', draw_COLOR_PALETTE_3);
				foreach ($colors as $color) {
			?>
				<li class='color' data-color='<?= hex2rgb($color) ?>'><div class="swatch"></div></li>
			<?php
				}
			?>
			</ul>
			<ul class="colors" id="colors4" style="display:none;">
			<?php
				$colors = explode(',', draw_COLOR_PALETTE_4);
				foreach ($colors as $color) {
			?>
				<li class='color' data-color='<?= hex2rgb($color) ?>'><div class="swatch"></div></li>
			<?php
				}
			?>
			</ul>
		</div>
	</div>
	<div id="toolbox">
		<ul>
			<li id="eraser_holder" data-bind-eraser="css: {invisible: active}, click: activate"></li>
			<li id="marker_holder" data-bind-marker="css: {invisible: active}, click: activate"></li>
			<li id="spraygun_holder" data-bind-spray="css: {invisible: active}, click: activate"></li>
			<li id="pen_holder" data-bind-pen="css: {invisible: active}, click: activate"></li>
		</ul>
	</div>
	<div id="footer">
		<!--
		<ul>
			<li><strong>Ghostwriter &copy; <a href="http://skookum.com">Skookum</a></strong> 2011 --- open sourced at <a href="https://github.com/Skookum/ghostwriter">github</a></li>
		</ul>
		-->
	</div>
</div>
<!-- JS Libraries -->
<script src="ghostwriter/js/lib/jquery-1.5.1.min.js"></script>
<script src="../scripts/jquery.cookie.js"></script>
<script src="ghostwriter/js/lib/knockout-latest.debug.js"></script>
<script src="ghostwriter/js/lib/amplify.min.js"></script>
<script src="ghostwriter/js/lib/procrastinate.js"></script>
<!-- ViewModels -->
<script src="ghostwriter/js/viewmodels/mouse.js"></script>
<script src="ghostwriter/js/viewmodels/brush.js"></script>
<script src="ghostwriter/js/viewmodels/canvas.js"></script>
<script src="ghostwriter/js/viewmodels/palette.js"></script>
<script src="ghostwriter/js/viewmodels/controls.js"></script>
<script src="ghostwriter/js/viewmodels/drawing.js"></script>
<!-- Brush Renderers -->
<script src="ghostwriter/js/renderers/spray.js"></script>
<script src="ghostwriter/js/renderers/ink.js"></script>
<script src="ghostwriter/js/renderers/marker.js"></script>
<script src="ghostwriter/js/renderers/eraser.js"></script>
<!-- Main -->
<script src="ghostwriter/js/main.js"></script>
</body>
</html>
