/**
 * common configurations of N3 application.
 *
 * project: @N3.ProjectName@
 * author : @N3.AuthorName@
 */
N3.Config = Class.cast({
    // ###########################
    // ##### CONSTANT VALUES #####
    // ###########################
    Const: {
        /**
         * project name
         */
        PROJECT_NAME: "@N3.ProjectName@",

        /**
         * application name (inner)
         */
        APP_NAME: "@N3.AppName@",

        /**
         *  navigation viewer class
         */
        NAVI_VIEWER_CLASS: N3C.StackViewer,

        /**
         *  contents viewer class
         */
        CONT_VIEWER_CLASS: N3C.DefaultViewer,

        /**
         * viewer effects
         */
        INTER_VIEWRR_EFFECT: N3C.DefaultViewer.NO_EFFECT,
        JUMP_VIEWRR_EFFECT : N3C.DefaultViewer.NO_EFFECT,
        NAVI_VIEWER_EFFECT : N3C.DefaultViewer.NO_EFFECT,
        CONT_VIEWER_EFFECT : N3C.DefaultViewer.NO_EFFECT,

        /**
         * N3C.DefaultViewer parameters
         */
        // DVP_FLICK_DISABLED: true,
        DVP_CEASE_NAVI: false,
        DVP_FLICK_DIFF: [44, 4],        // this means maximu degree of flick difference
        DVP_FLICK_XRANGE: [5, 80],      // this means range of flick width
        DVP_NAVI_SIZE: [24, 24],
        DVP_NAVI_ONLY_IMAGE: false,
        DVP_NAVI_DESIGN: "n3_navi_design",
        DVP_KEEP_SCROLL: true,
        DVP_WATCH_TIME: 250,
        DVP_PINCH_ZOOM: true,
        DVP_NAVI_IMAGES: N3C.DefaultViewer.DEF_NAVI_BUTTON,
        DVP_NAVI_IMAGE_POS: null,

        /**
         * use page added notification
         */
        PAGE_ADDED_NOTIFICATION: false,

        /**
         * use inner location change
         */
        INNER_LOCATEION: true,

        /**
         * use history or not
         */
        HISTORY_BACK: false,

        /**
         * article position priority
         */
        ARTICLE_POSITION_PRIORITY: false,

        /**
         * Script secure ( !Caution. If you release this switch, application can be destroyed by Core data. )
         */
        // SCRIPT_SECURE: true,

        /**
         * secure modules
         */
        SEC_MODULES: [
            // N3C.Secure.HtmlFilter,
            // N3C.Secure.HtmlZeroFilter,
            // N3C.Secure.CrossSiteChecker
        ]
    }
});

/**
 * @N3.ProjectName@ application
 */
// setup drawers
N3.@N3.AppClassName@ = Class.cast({
    // ######################
    // ##### BASE CLASS  ####
    // ######################
    Extends: N3.Application,

    // ######################
    // ##### INTERFACES #####
    // ######################

    // ###########################
    // ##### CONSTANT VALUE #####
    // ###########################
    /*
    Const: {
    },
    */

    // ############################
    // ##### CLASS PROPERTIES #####
    // ############################
    /*
    Static: {
    },
    */

    // ##############################
    // ##### PRIVATE PROPERTIES  ####
    // ##############################

    // #######################
    // ##### CONSTRUCTOR #####
    // #######################
    /**
     * constructor
     *
     */
    newInstance: function() {
        // call super class constructor
        this.superClass();
    },

    // ###########################
    // ##### VIRTUAL METHODS #####
    // ###########################

    // ####################################
    // ##### OVERRIDE VIRTUAL METHODS  ####
    // ####################################
    // initializer
    init: function() {
    },

    // ###################################
    // ##### DEFINE ABSTRACT METHODS  ####
    // ###################################

    // #############################
    // ##### INTERFACE METHODS  ####
    // #############################

    // ##########################
    // ##### PUBLIC METHODS  ####
    // ##########################

    // ###########################
    // ##### PRIVATE METHODS  ####
    // ###########################

    // ########################
    // ##### CLASS LOADER  ####
    // ########################
    Loader: function() {
        // register application class
        N3.Application.regAppClass(this);
    },

    // #######################
    // ##### INNER CLASS #####
    // #######################
});
