<?php
/* ----------------------------------------------------
 * Nazzo
 * @version 0.9.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 

class MobileComponent extends Object
{
	function beforeRender(&$controller)
	{
		if (!empty($controller->params['prefix']) )
		{
			$controller->layout = $controller->params['prefix'];
		}
	}
	
	function beforeRedirect(&$controller, $url, $status = null, $exit = true)
	{
    return MobileComponent::getUrl($controller->params, $url); 
	}

	function getUrl($params, $url)
	{
 		if (!empty($controller->params['prefix']) && $controller->params['prefix'] == 'mobile')
		{
		        if (is_array($url)) 
				{
          			$url[$params['prefix']] = true;
      			} else if (is_string($url)) {
        				if (!preg_match("#^http[s]?://#", $url)) {
          					$prefix = preg_match("#^/m/#", $url) ? '' : '/m';
          					$url = sprintf("%s%s", $prefix, $url);
        				}
      			}
		}
		return $url;
    }
}
?>
