<?php
/* ----------------------------------------------------
 * Nazzo
 * @version 0.9.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 

class PostsController extends AppController {

	var $name = 'Posts';
	var $uses = array('Post','User','Tag');
	var $helpers = array('Html', 'Form','Paginator','Parser','Ajax','Javascript','Cache');
	var $components = array('mobile');
	var $paginate = array(
						'limit'=> 10,
						'recursive'=> 0
						);
	var $cacheAction = array(
						'index'=> '+1 day',
						'tagidx'=> '+1 day',
						'mobile_index'=> '+1 day',
						'mobile_tagidx'=> '+1 day'
						);
	
	function beforeFilter() {
	
		if($this->User->find('count') == 0) {
			$this->Auth->allow('admin_add');
			$this->Session->setFlash(__('The user is not registered.Please register a new user.', true));
			$this->redirect(array('controller' => 'users', 'action' => 'add', 'admin' => true));
			exit;
    	}else{
    		$this->Auth->allow('index','tagidx','random','search','mobile_index','mobile_tagidx','mobile_random','mobile_search');
    	}
    	return parent:: beforeFilter();
	}


	function index() {
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$posts = $this->paginate();
		$this->set('posts', $posts);
		$tag = $this->Post->Tag->find('all');
		$this->set('tags', $tag);
	}


	function tagidx($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid Post.', true));
			$this->redirect(array('action'=>'index'));
		}
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$posts = $this->paginate('Post', array('Post.tag_id =' => $id));
		$this->set('posts', $posts);
		$this->set('tagid', $id);
		$tag = $this->Post->Tag->find('all');
		$this->set('tags', $tag);
	}

	function random($id = null) {
		if (!$id) {
			$where = '1=1';
		}else{
			$where = array('Post.tag_id =' => $id);
		}
		$this->params['order'] = 'rand()';
		$posts = $this->paginate('Post', $where);
		$this->set('posts', $posts);
		$tag = $this->Post->Tag->find('all');
		$this->set('tags', $tag);
	}

	function search() {
		if (empty($this->data)) {
			$this->Session->setFlash(__('Invalid Post.', true));
			$this->redirect(array('action'=>'index'));
		} 
		$search = $this->data['Post']['name'];
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$posts = $this->paginate('Post', array('Post.name LIKE ' => "%$search%"));
		$this->set('posts', $posts);
		$tag = $this->Post->Tag->find('all');
		$this->set('tags', $tag);		
	}	

	function mobile_index() {
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$posts = $this->paginate();
		$this->set('posts', $posts);
		$tag = $this->Post->Tag->find('all');
		$this->set('tags', $tag);
	}
	
	function mobile_tagidx($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid Post.', true));
			$this->redirect(array('action'=>'index'));
		}
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$posts = $this->paginate('Post', array('Post.tag_id =' => $id));
		$this->set('posts', $posts);
		$this->set('tagid', $id);
		$tag = $this->Post->Tag->find('all');
		$this->set('tags', $tag);
	}

	function mobile_random($id = null) {
		if (!$id) {
			$where = '1=1';
		}else{
			$where = array('Post.tag_id =' => $id);
		}
		$this->params['order'] = 'rand()';
		$posts = $this->paginate('Post', $where);
		$this->set('posts', $posts);
		$tag = $this->Post->Tag->find('all');
		$this->set('tags', $tag);
	}

	function mobile_search() {
		if (empty($this->data)) {
			$this->Session->setFlash(__('Invalid Post.', true));
			$this->redirect(array('action'=>'index'));
		} 
		$search = $this->data['Post']['name'];
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$posts = $this->paginate('Post', array('Post.name LIKE ' => "%$search%"));
		$this->set('posts', $posts);
		$tag = $this->Post->Tag->find('all');
		$this->set('tags', $tag);		
	}	
	

	function admin_index() {
		if($this->Tag->find('count') == 0) {
			$this->Session->setFlash(__('At first,Please register a tag from the upper [Tags] menu.', true));
    	}
		if (!empty($this->data)) {
			$this->Post->create();
			if ($this->Post->save($this->data)) {
				$this->Session->setFlash(__('The Post has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__($this->data['user_id'], true));
			}
		}
		$this->Post->Tag->displayField = 'name';
 		$tag_id = $this->Post->Tag->find('list');
 		$this->set('tag_id',$tag_id);
 		$this->set('user_id',$this->Auth->user('id'));
 		
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$posts = $this->paginate();
		$this->set('posts', $posts);
	}

	function admin_add() {
		if (!empty($this->data)) {
			$this->Post->create();
			if ($this->Post->save($this->data)) {
				$this->Session->setFlash(__('The Post has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__($this->data['user_id'], true));
			}
		}
		$this->Post->Tag->displayField = 'name';
 		$tag_id = $this->Post->Tag->find('list');
 		$this->set('tag_id',$tag_id);
 		$this->set('user_id',$this->Auth->user('id'));
	}

	function admin_edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid Post', true));
			$this->redirect(array('action'=>'index'));
		}
		if (!empty($this->data)) {
			if ($this->Post->save($this->data)) {
				$this->Session->setFlash(__('The Post has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__('The Post could not be saved. Please, try again.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Post->read(null, $id);
		}
		$tags = $this->Post->Tag->find('list');
		$this->set(compact('tags'));
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Post', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->Post->delete($id)) {
			$this->Session->setFlash(__('Post deleted', true));
			$this->redirect(array('action'=>'index'));
		}
	}

}
?>