/*
    TCFbECustomTableEx.h    December 4, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbECustomTableExH
#define TCFbECustomTableExH
//---------------------------------------------------------------------------
// #include "Maprof.h"

#include "TCFbECell.h"
#include "TCFbEToolkit.h"
#include "TCFbERowColumnCachedTable.h"
#include "TCFbEColumnCachedTable.h"
#include "TCFbERowCachedTable.h"
#include "TCFbERowRowCachedTable.h"
#include "TCFbEColumnColumnCachedTable.h"
//---------------------------------------------------------------------------
// v@\tLbVue[u
class TCFbECustomTableEx : public TCFbERowColumnCachedTable
{
public:
    virtual __fastcall TCFbECustomTableEx(void);    // RXgN^iLbV쐬
    virtual __fastcall TCFbECustomTableEx(TStringList* RowLabelList, TStringList* ColumnLabelList);    // w肳ꂽse[u쐬
    virtual __fastcall TCFbECustomTableEx(TStringList* SourceCsvStringList);   // RXgN^
    __fastcall ~TCFbECustomTableEx();    // fXgN^

    virtual void __fastcall InitCache(void);    // LbV

    virtual bool __fastcall Normalize(int TargetRowIndex, int TargetColumnIndex, double MaxValue, double MinValue);    // Normalize 
    virtual void __fastcall PartialNormalize(int ColumnIndex);      // Table ̗vf𕔕I Normalize 
    virtual void __fastcall Normalize(void);                        // Table ̗vf Normalize 

    virtual bool __fastcall Standardize(int TargetRowIndex, int TargetColumnIndex, double AverageValue, double StdevValue);   // Standardize 
    virtual void __fastcall PartialStandardize(int ColumnIndex);    // Table ̗vf𕔕I Standardize 
    virtual void __fastcall Standardize(void);                      // Table ̗vf Standardize 

    virtual void __fastcall Ordering(TList* SortedCellList);        // Ordering 
    virtual void __fastcall PartialOrdering(int ColumnIndex);       // Table ̗vf𕔕I Ordering 
    virtual void __fastcall Ordering(void);                         // Table ̗vf Ordering 

    virtual void __fastcall PartialRowNormalize(int RowIndex);      // Table ̗vfɕI Normalize 
    virtual void __fastcall RowNormalize(void);                     // Table ̗vf Normalize 
    virtual void __fastcall PartialRowStandardize(int RowIndex);    // Table ̗vfɕI Standardize 
    virtual void __fastcall RowStandardize(void);                   // Table ̗vf Standardize 
    virtual void __fastcall PartialRowOrdering(int RowIndex);       // Table ̗vfɕI Ordering 
    virtual void __fastcall RowOrdering(void);                      // Table ̗vf Ordering 

    virtual double __fastcall DisNormalize(int ColumnIndex, double NormalizedValue);    // ColumnIndex ڂ Normalize ꂽl NormalizedValue  DisNormalize ĕԂ
    virtual double __fastcall DisStandardize(int ColumnIndex, double StandardizedValue);    // ColumnIndex ڂ Standardize ꂽl StandardizedValue  DisStandardize ĕԂ
    virtual double __fastcall DisOrdering(int ColumnIndex, double Order, TDoubleDynArray& SortedOrders);    // ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ

    virtual double __fastcall DisRowNormalize(int RowIndex, double RowNormalizedValue);    // RowIndex ڂ̉ Normalize ꂽl RowNormalizedValue  DisRowNormalize ĕԂ
    virtual double __fastcall DisRowStandardize(int RowIndex, double RowStandardizedValue);    // RowIndex ڂ̉ Standardize ꂽl RowStandardizedValue  DisRowStandardize ĕԂ
    virtual double __fastcall DisRowOrdering(int RowIndex, double RowOrder, TDoubleDynArray& SortedOrders);    // RowIndex ڂ̉ Ordering ꂽl RowOrder  DisRowOrdering ĕԂ

    virtual double __fastcall DisOrderingCommon(int Index, double Order, TDoubleDynArray& SortedOrders, TDoubleDynArray& SortedValues);    // DisOrdering  DisRowOrdering Ŏgʂ̏

    virtual double  __fastcall GetICFCoefficient(int j);    // j ڂ Inverse Case Frequency Coefficient 𓾂

    virtual double __fastcall GetMaxOfRow(int i);       // s̍őlԂD
    virtual double __fastcall GetMinOfRow(int i);       // s̍ŏlԂD
    virtual double __fastcall GetAverageOfRow(int i);   // s̕ϒlԂD
    virtual double __fastcall GetMedianOfRow(int i);    // s̒ԒlԂD
    virtual double __fastcall GetStdevOfRow(int i);     // s̕W΍ԂD
    virtual double __fastcall GetInversedDistanceOfRow(int BaseRowIndex, int ComparedRowIndex);     // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Inversed Distance ԂD
    virtual double __fastcall GetAveragedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex);   // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Averaged Multiplier ԂD
    virtual double __fastcall GetMedianOfMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex);   // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Median of Multiplier ԂD
    virtual double __fastcall GetWeightedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex, int BaseColumnIndex);  // BaseColumnIndex Ԗڂ̗Ɋւ ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Weighted Multiplier ԂD

    virtual double __fastcall GetMaxOfColumn(int j);        // ̍őlԂD
    virtual double __fastcall GetMinOfColumn(int j);        // ̍ŏlԂD
    virtual double __fastcall GetAverageOfColumn(int j);    // ̕ϒlԂD
    virtual double __fastcall GetMedianOfColumn(int j);     // ̒ԒlԂD
    virtual double __fastcall GetStdevOfColumn(int j);      // ̕W΍ԂD
    virtual double __fastcall GetInversedDistanceOfColumn(int BaseColumnIndex, int ComparedColumnIndex);    // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Inversed Distance ԂD
    virtual double __fastcall GetAveragedMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex);  // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Averaged Multiplier ԂD
    virtual double __fastcall GetMedianOfMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex);  // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Median of Multiplier ԂD
    virtual double __fastcall GetWeightedMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex, int BaseRowIndex);    // BaseRowIndex Ԗڂ̍sɊւ BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Weighted Multiplier ԂD
    
protected:
    virtual TCFbECachedTable* __fastcall CreateClone(void) = 0;         // g̃N[쐬
    virtual TCFbECachedTable* __fastcall CreateRotatedClone(void) = 0;  // g̍sƗ񂪓ւN[쐬

    //  0: MaxRowCache, "Max.row"
    virtual TCFbECachedTable* __fastcall GetMaxRowCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[0];
    }

    //  1: MinRowCache, "Min.row"
    virtual TCFbECachedTable* __fastcall GetMinRowCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[1];
    }

    //  2: AverageRowCache, "Average.row"
    virtual TCFbECachedTable* __fastcall GetAverageRowCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[2];
    }

    //  3: MedianRowCache, "Median.row"
    virtual TCFbECachedTable* __fastcall GetMedianRowCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[3];
    }

    //  4: StdevRowCache, "Stdev.row"
    virtual TCFbECachedTable* __fastcall GetStdevRowCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[4];
    }

    //  5: IDRowCache, "InversedDistance.row"
    virtual TCFbECachedTable* __fastcall GetIDRowCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[5];
    }

    //  6: MaxColumnCache, "Max.column"
    virtual TCFbECachedTable* __fastcall GetMaxColumnCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[6];
    }

    //  7: MinColumnCache, "Min.column"
    virtual TCFbECachedTable* __fastcall GetMinColumnCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[7];
    }

    //  8: AverageColumnCache, "Average.column"
    virtual TCFbECachedTable* __fastcall GetAverageColumnCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[8];
    }

    //  9: MedianColumnCache, "Median.column"
    virtual TCFbECachedTable* __fastcall GetMedianColumnCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[9];
    }

    //  10: StdevColumnCache, "Stdev.column"
    virtual TCFbECachedTable* __fastcall GetStdevColumnCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[10];
    }

    //  11:IDColumnCache, "InversedDistance.column"
    virtual TCFbECachedTable* __fastcall GetIDColumnCache(void) {
        return (TCFbECachedTable*)this->ChildCacheList->Items[11];
    }


private:

};
//---------------------------------------------------------------------------
#endif
