/*
    TCFbEDataLoader.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEDataLoaderH
#define TCFbEDataLoaderH
//---------------------------------------------------------------------------
#include <stdio.h>

#include "TCFbECommandLineParser.h"
#include "TCFbEDataSetEx.h"
//---------------------------------------------------------------------------
// g[jOf[^̐\񋓌^
enum TTargetColumnType { tmtTooSparsity=-1, tmtEmpty=0, tmtPredictable=1 };
// tmtEmpty:        f[^݂Ȃ
// tmtPredictable:    \\ȃgNX
// tmtTooSparsity:    \s\ȃgNXiNeighborsSize g[jOf[^Ȃ
//---------------------------------------------------------------------------
class TCFbEDataLoader : public TObject
{
public:
    virtual __fastcall TCFbEDataLoader(TCFbECommandLineParser* Parser, bool IsVerbose=false);    // RXgN^
    __fastcall ~TCFbEDataLoader();    // fXgN^

    TCFbEDataSetEx* LearningData;
    TCFbEDataSetEx* EstimatingData;

    int    ErrorCode;    // G[R[hiG[Ȃꍇ 0
    AnsiString    ErrorParameter;    // G[p[^

protected:
    virtual TTargetColumnType __fastcall TargetColumnCheck(AnsiString TargetColumnLabel, const int NeighborsSize);
    virtual void __fastcall AdoptData(TCFbEDataSetEx* BaseDataSet, TCFbEDataSetEx*& AdoptedDataSet);    // AdoptedDataSet  BaseDataSet ɍ킹ēK
    virtual bool __fastcall CompareStringList(TStrings* StringList0, TStrings* StringList1) ;    // StringList0  StringList1 r

private:

};
//---------------------------------------------------------------------------
#endif
