/*
    EDocfbeError.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.           

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "EDocfbeError.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iargc  argv ɂăR}hC^
__fastcall EDocfbeError::EDocfbeError(int ErrorCode, AnsiString Parameter, AnsiString AddedMessage)
    : Exception("")
{
    this->ErrorCode = ErrorCode;

    if (ErrorCode == ecNoLearningDataFileName) {
        this->Message = "No learning data file name.";

    } else if (ErrorCode == ecLearningDataNotFound) {
        this->Message = "Learning data file \"" + Parameter + "\" is not found.";

    } else if (ErrorCode == ecNoEstimatingDataFileName) {
        this->Message = "No estimating data file name.";

    } else if (ErrorCode == ecNoSimilarityComputationAlgorithm) {
        this->Message = "No similarity computation algorithm.";

    } else if (ErrorCode == ecNoPredictionAlgorithm) {
        this->Message = "No prediction algorithm.";

    } else if (ErrorCode == ecTooLongCommandLineArguments) {
        this->Message = "Too long commandline arguments.\nIt has to be less than 1024 characters.";

    } else if (ErrorCode == ecEstimatingDataNotFound) {
        this->Message = "Estimating data file \"" + Parameter + "\" is not found.";

    } else if (ErrorCode == ecIllegalSimilarityComputationAlgorithm) {
        this->Message = "Similarity computation algorithm \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecIllegalPredictionAlgorithm) {
        this->Message = "Prediction algorithm \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecIllegalNormalizationMethod) {
        this->Message = "Normalization method \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecIllegalNeighborsSize) {
        this->Message = "Neighbors size \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecOutputDirectoryCantBeMade) {
        this->Message = "Output directory \"" + Parameter + "\" cannot be made.";

    } else if (ErrorCode == ecLearningDataCantBeOpened) {
        this->Message = "Learning data file \"" + Parameter + "\" cannot be opened.";

    } else if (ErrorCode == ecEstimatingDataCantBeOpened) {
        this->Message = "Estimating data file \"" + Parameter + "\" cannot be opened.";

    } else if (ErrorCode == ecDatasetsAreInconsistency) {
        this->Message = "There is inconsistency between \"" + Parameter + "\".";

    } else if (ErrorCode == ecLearningDataHasNoTargetedColumn) {
        this->Message = "The learning data has not specified target column \"" + Parameter + "\".";

    } else if (ErrorCode == ecLearningDataHasLessTargetdData) {
        this->Message = "The learning data has too less rows for estimating the targeted column \"" + Parameter +"\".";

    } else if (ErrorCode == ecOutputFileCantBeWritten) {
        this->Message = "Cannot write to the output file \"" + Parameter + "\".";

    } else if (ErrorCode == ecUnknown){
        if (Parameter.IsEmpty()) {
            Parameter = "Unknown";
        }
        this->Message = "Unknown error occurred at " + Parameter + " section.";

    } else if (ErrorCode == ecIllegalDefaultValue) {
        this->Message = "Default value \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecIllegalMergeBase) {
        this->Message = "For merging, base data \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecIllegalCaseAmplifier) {
        this->Message = "Case amplifier \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecIllegalVWSimilarityAlgorithm) {
        this->Message = "Variable weighting algorithm (for similarity computation) \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecIllegalVWPredictionAlgorithm) {
        this->Message = "Variable weighting algorithm (for prediction) \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecVWPredictionAlgorithmIllegallySpecified) {
        this->Message = "Prediction algorithm (\"" + Parameter + "\") is not AmplifiedWeightedSumWithVWWeightedMultiplier although variable weighting algorithm is specified.";

    } else if (ErrorCode == ecNoTargetColumn) {
        this->Message = "No target column is specified.";

    } else if (ErrorCode == ecNoVWPredictionAlgorithm) {
        this->Message = "Variable weighting algorithm (for prediction) is not specified although prediction algorithm is AmplifiedWeightedSumWithVWWeightedMultiplier.";

    } else if (ErrorCode == ecIllegalOption) {
        this->Message = "Option \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecIllegalCombinedRatio) {
        this->Message = "Combined ratio \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == ecDuplicatedRow) {
        this->Message = "Row \"" + Parameter + "\" is duplicated in the data file.";

    } else if (ErrorCode == ecDuplicatedColumn) {
        this->Message = "Column \"" + Parameter + "\" is duplicated in the data file.";

    } else if (ErrorCode == ecRowIsContainedBothFile) {
        this->Message = "Row \"" + Parameter + "\" is contained in both of learning and estimating data.";
    }

    if (!AddedMessage.IsEmpty()) {
        this->Message += "\nUnknown error occurred!\nCould you e-mail to <naoki-o@is.naist.jp> with the following message?\n[ " + AddedMessage + "]";
    }
}

//---------------------------------------------------------------------------
__fastcall EDocfbeError::~EDocfbeError()
{
}

//---------------------------------------------------------------------------

