/*
    TCFbEDistanceSimilarityWithMedian.h    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEDistanceSimilarityWithMedianH
#define TCFbEDistanceSimilarityWithMedianH
//---------------------------------------------------------------------------
#include <math.h>
#include "TCFbESimilarityComputationAlgorithm.h"
#include "TCFbEToolkit.h"
#include "TCFbECustomTableEx.h"
//---------------------------------------------------------------------------
class TCFbEDistanceSimilarityWithMedian : public TCFbESimilarityComputationAlgorithm
{
public:
    virtual __fastcall TCFbEDistanceSimilarityWithMedian(void);    // RXgN^
    __fastcall ~TCFbEDistanceSimilarityWithMedian();    // fXgN^

    // vZɕKvȃLbV
    virtual void __fastcall PrepareCache(TCFbECustomTableEx* SimilarityComputationTable) {
        SimilarityComputationTable->AddChildCache(new TCFbEColumnCachedTable(SimilarityComputationTable), "Max.column", true);
        SimilarityComputationTable->AddChildCache(new TCFbEColumnCachedTable(SimilarityComputationTable), "Min.column", true);
    }

    virtual double __fastcall ComputeSimilarity(TCFbECustomTableEx* SimilarityComputationTable, int TargetRowIndex, int ComparedRowIndex);    // TargetRowIndex  AnotherRowIndex ̗ގxvZ

protected:

private:

};
//---------------------------------------------------------------------------
#endif
