/*
    TCFbEGeneralCommandLineParser.cpp    January 13, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEGeneralCommandLineParser.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// TODO 3 -oNaoki Ohsugi : `̃R}hC񂪓nꂽƂɃG[Ԃ悤ɏD
// RXgN^iargc  argv ɂăR}hC^
__fastcall TCFbEGeneralCommandLineParser::TCFbEGeneralCommandLineParser(int argc, char* argv[])
{
    // ϐ̏
    this->FOptionList = new TStringList();
    this->ErrorCode = ecNone;
    this->ErrorParameter = "";

    // R}hC 1024 ȏ
    if (StrLen(CmdLine) >= 1024) {
        this->ErrorCode = ecTooLongCommandLineArguments;
        return;
    }

    if (argc > 0) {
        for (int i = 1; i < argc; i++) {
            this->FOptionList->Add(AnsiString(argv[i]));
        }
    } else {
        for (int i = 1; i < ParamCount(); i++) {
            this->FOptionList->Add(ParamStr(i));
        }
    }
}

//---------------------------------------------------------------------------
__fastcall TCFbEGeneralCommandLineParser::~TCFbEGeneralCommandLineParser()
{
    delete this->FOptionList;
}

//---------------------------------------------------------------------------

// R}hCp[XăG[R[hԂ

int __fastcall TCFbEGeneralCommandLineParser::DoParse(void)

{

    for (int i = 0; i < this->FOptionList->Count; i++) {

        AnsiString OptionName = this->FOptionList->Strings[i];
        AnsiString Parameter = "";

        // p[^IvV
        if (OptionName.Pos("=") > 1) {
            OptionName = this->FOptionList->Names[i];
            Parameter = this->FOptionList->Values[OptionName];
        } else {
            Parameter = "";
        }

        if (!this->OptionObserved(OptionName, Parameter)) {
            this->ErrorCode = ecIllegalOption;
            this->ErrorParameter = OptionName;
            return this->ErrorCode;
        }
    }
    return ecNone;
}


//---------------------------------------------------------------------------

// ȉCprotected \bh
//---------------------------------------------------------------------------
// IvVȂ
bool __fastcall TCFbEGeneralCommandLineParser::IsEmpty(void)
{
    return (this->FOptionList->Count == 0);
}

//---------------------------------------------------------------------------
bool __fastcall TCFbEGeneralCommandLineParser::OptionNameIs(AnsiString Option, AnsiString ShortForm, AnsiString LongForm)
{
    return Option == ShortForm || Option == LongForm;
}

//---------------------------------------------------------------------------

